/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseStatisticsServer;
import com.sap.hdb.sl.lib.instance.DatabaseXmlParameter;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.AbapPreLoadExecution;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class RestoreDatabaseSettings
implements CmdClazz {
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection = null;

    protected RestoreDatabaseSettings() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        File parameterFile;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if (!(parameterFile = new File(AbapPreLoadExecution.PARAMETER_FILE_NAME)).exists() || !parameterFile.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "No parameter file found. Nothing to do.");
            return;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(parameterFile));
            while ((line = br.readLine()) != null) {
                DatabaseXmlParameter databaseXmlParameter = DatabaseXmlParameter.fromText(line);
                DatabaseConfiguration configFile = new DatabaseConfiguration(this.connection, this.systemUser, databaseXmlParameter.getConfigurationFileName());
                DatabaseConfigurationSection section = configFile.getSection(databaseXmlParameter.getSectionName());
                section.unsetParameter(databaseXmlParameter.getParameterName());
            }
        }
        catch (FileNotFoundException e) {
            LogFactory.writeLogEntry(this.getClass(), "No parameter file found. Nothing to do.");
            return;
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            DatabaseStatisticsServer statServer = new DatabaseStatisticsServer();
            statServer.setOn(this.connection, this.systemUser);
        }
        parameterFile.delete();
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

