/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class ResultFileWriter
extends Writer {
    protected PrintWriter writer = null;

    protected ResultFileWriter(String fileName) {
        File resultFile = this.createFile(fileName);
        this.writer = this.createWriter(resultFile);
    }

    private File createFile(String fileName) {
        File resultFile = new File(fileName);
        if (!resultFile.exists()) {
            try {
                boolean created = resultFile.createNewFile();
                if (!created) {
                    throw new HdbException(resultFile + " could not be created!");
                }
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
        }
        return resultFile;
    }

    private PrintWriter createWriter(File resultFile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(resultFile);
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        return pw;
    }

    public Writer append(String line) {
        return this.append(new String[]{line});
    }

    public Writer append(String[] lines) {
        for (String line : lines) {
            this.writer.println(line);
            this.writer.flush();
        }
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.append(Character.toString(c));
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.append(((Object)csq.subSequence(start, end)).toString());
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

