/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import java.util.ArrayList;
import java.util.List;

public class SQLScriptParser {
    private static final String STR_END_BLOCK_PATTERN = "^\\s*END\\s*;?\\s*$";
    private static final String STR_BEGIN_BLOCK_PATTERN = "^\\s*BEGIN\\s*$";
    private static final String STR_BEGIN_COMMENT = "/*";
    private static final String STR_END_COMMENT = "*/";
    private static final String STR_END_STATEMENT = ";";
    private boolean inComment = false;
    private boolean inProcedure = false;

    public List<String> parseStatements(List<String> scriptContent) {
        this.reset();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder statement = new StringBuilder();
        for (String line : scriptContent) {
            String raw = this.stripComments(line.trim()).trim();
            if (raw.isEmpty()) continue;
            if (line.matches(STR_BEGIN_BLOCK_PATTERN)) {
                this.inProcedure = true;
            } else if (line.matches(STR_END_BLOCK_PATTERN)) {
                this.inProcedure = false;
            }
            if (!this.inProcedure) {
                int endStatement = -1;
                endStatement = raw.indexOf(STR_END_STATEMENT);
                if (endStatement >= 0) {
                    statement.append(raw.substring(0, endStatement));
                    result.add(statement.toString());
                    statement = new StringBuilder();
                    if (raw.substring(endStatement + 1).isEmpty()) continue;
                    statement.append(raw.substring(endStatement + 1) + "\n");
                    continue;
                }
                statement.append(raw + "\n");
                continue;
            }
            statement.append(raw + "\n");
        }
        if (!statement.toString().trim().isEmpty()) {
            result.add(statement.toString());
        }
        return result;
    }

    private void reset() {
        this.inComment = false;
        this.inProcedure = false;
    }

    private String stripComments(String line) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < line.length(); ++i) {
            if (!this.inComment) {
                if (i + STR_BEGIN_COMMENT.length() <= line.length()) {
                    if (!line.substring(i, i + STR_BEGIN_COMMENT.length()).equals(STR_BEGIN_COMMENT)) {
                        result.append(line.charAt(i));
                        continue;
                    }
                    this.inComment = true;
                    i += STR_BEGIN_COMMENT.length() - 1;
                    continue;
                }
                result.append(line.charAt(i));
                continue;
            }
            if (i + STR_END_COMMENT.length() > line.length() || !line.substring(i, i + STR_END_COMMENT.length()).equals(STR_END_COMMENT)) continue;
            this.inComment = false;
            i += STR_END_COMMENT.length() - 1;
        }
        String temporaryResult = result.toString();
        if (temporaryResult.matches("^\\s*--.*$")) {
            return "";
        }
        return temporaryResult;
    }
}

