/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class SanityCalcengineEnableDeprecatedComponentFlags
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected SanityCalcengineEnableDeprecatedComponentFlags() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.systemUser);
        this.executeConfiguration();
    }

    private void executeConfiguration() {
        try {
            DatabaseConfiguration indexserverConfig = new DatabaseConfiguration(this.connection, this.systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
            DatabaseConfigurationSection section = indexserverConfig.getSection("calcengine");
            section.setParameter("enable_deprecated_component_flags", "8192");
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not change the configuration for SAP note 2789289.");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

