/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class SanityLogicalMigrationPagedTables
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private List<TableRelpayTime> tables = new ArrayList<TableRelpayTime>();
    private Timestamp sp4UpgradeStamp = null;

    protected SanityLogicalMigrationPagedTables() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.sqlUser);
        if (this.needsMigration()) {
            this.findPagedTables();
        }
        if (0 == this.tables.size()) {
            return;
        }
        this.loadTables();
    }

    private boolean needsMigration() {
        boolean needsMigration = true;
        String dbVersionSql = "SELECT VERSION FROM SYS.M_DATABASE";
        String dbHistorySql = "SELECT VERSION FROM SYS.M_DATABASE_HISTORY ORDER BY INSTALL_TIME DESC";
        List<String> versions = this.connection.executeSQLCommand(dbVersionSql);
        String currentVersion = versions.get(0);
        if (!this.isSP4(currentVersion)) {
            return false;
        }
        versions = this.connection.executeSQLCommand(dbHistorySql);
        this.sp4UpgradeStamp = this.findSP4UpgradeStamp(versions);
        if (!this.isUpgradedFromSP3(versions)) {
            return false;
        }
        return needsMigration;
    }

    private Timestamp findSP4UpgradeStamp(List<String> versions) {
        String firstSP4Version = null;
        TreeMap<Integer, String> sortedMapSP4 = new TreeMap<Integer, String>();
        TreeMap<Integer, String> sortedMapSP5 = new TreeMap<Integer, String>();
        for (String version : versions) {
            HdbVersion hdbVersion = new HdbVersion(version);
            int major = hdbVersion.getMajorVersion();
            int revision = hdbVersion.getRevision();
            if (major == 2 && revision >= 40 && revision < 50) {
                sortedMapSP4.put(revision, version);
            }
            if (major != 2 || revision < 50 || revision >= 60) continue;
            sortedMapSP5.put(revision, version);
        }
        if (sortedMapSP4.size() > 0) {
            firstSP4Version = (String)sortedMapSP4.firstEntry().getValue();
        } else if (sortedMapSP5.size() > 0) {
            firstSP4Version = (String)sortedMapSP5.firstEntry().getValue();
        }
        String firstSP4StampSql = "SELECT INSTALL_TIME FROM SYS.M_DATABASE_HISTORY WHERE VERSION = '" + firstSP4Version + "'";
        List<Timestamp> res = this.selectTimestampSQLCommand(this.connection, firstSP4StampSql);
        return res.get(0);
    }

    private boolean isUpgradedFromSP3(List<String> versions) {
        for (String version : versions) {
            HdbVersion hdbVersion = new HdbVersion(version);
            int major = hdbVersion.getMajorVersion();
            int revision = hdbVersion.getRevision();
            if (major != 2 || revision >= 40) continue;
            return true;
        }
        return false;
    }

    private boolean isSP4(String currentVersion) {
        HdbVersion version = new HdbVersion(currentVersion);
        int major = version.getMajorVersion();
        int revision = version.getRevision();
        return major == 2 && revision >= 40 && revision < 50;
    }

    private void loadTables() {
        String loadTableSql = "select count(*) from \"";
        for (TableRelpayTime table : this.tables) {
            if (this.isLoadedAfterUpgradetoSP4(table)) continue;
            this.connection.executeSQLCommand(loadTableSql + table.getTable() + "\"");
        }
    }

    private boolean isLoadedAfterUpgradetoSP4(TableRelpayTime tableReplay) {
        Timestamp stampReplayLog = tableReplay.getLastReplayLogTime();
        if (null == stampReplayLog) {
            return false;
        }
        return stampReplayLog.after(this.sp4UpgradeStamp);
    }

    private void findPagedTables() {
        String pagedTablesSql = "select distinct table_name, LAST_REPLAY_LOG_TIME from sys.m_cs_tables where schema_name = CURRENT_SCHEMA and load_unit = 'PAGE' union select distinct tb.table_name, t.LAST_REPLAY_LOG_TIME  from table_partitions tb, sys.m_cs_tables t where tb.schema_name = CURRENT_SCHEMA  and tb.load_unit = 'PAGE' and tb.table_name = t.table_name and tb.schema_name = t.schema_name union select distinct tc.table_name, t.LAST_REPLAY_LOG_TIME from sys.table_columns tc, sys.m_cs_tables t where tc.schema_name = CURRENT_SCHEMA and tc.load_unit = 'PAGE' and tc.table_name = t.table_name and tc.schema_name = t.schema_name";
        ResultSet resultSet = null;
        try {
            Statement stmt = this.connection.getConnection().createStatement();
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + pagedTablesSql);
            if (stmt.execute(pagedTablesSql)) {
                resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    do {
                        String table = resultSet.getString(1);
                        Timestamp replayTime = resultSet.getTimestamp(2);
                        TableRelpayTime tableReplay = new TableRelpayTime(table, replayTime);
                        this.tables.add(tableReplay);
                    } while (resultSet.next());
                }
                resultSet.close();
            }
            stmt.close();
        }
        catch (SQLException sqle) {
            String message = "Error during execution of SQL command: " + pagedTablesSql + " " + sqle.getMessage();
            LogFactory.writeLogEntry(this.getClass(), message);
            this.connection.closeConnection();
            throw new HdbException(message);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find tables with paged attribute. " + e.getMessage());
        }
    }

    public List<Timestamp> selectTimestampSQLCommand(JdbcConnection connection, String statement) {
        Statement stmt = null;
        ResultSet resultSet = null;
        ArrayList<Timestamp> sqlResult = new ArrayList<Timestamp>();
        try {
            stmt = connection.getConnection().createStatement();
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + statement);
            if (stmt.execute(statement)) {
                resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    do {
                        Timestamp timestampResult = resultSet.getTimestamp(1);
                        sqlResult.add(timestampResult);
                    } while (resultSet.next());
                }
                resultSet.close();
            }
            stmt.close();
        }
        catch (SQLException e) {
            String message = "Error during execution of SQL command: " + statement + " " + e.getMessage();
            LogFactory.writeLogEntry(this.getClass(), message);
            connection.closeConnection();
            throw new HdbException(message);
        }
        return sqlResult;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    class TableRelpayTime {
        String table;
        Timestamp lastReplayLogTime;

        public TableRelpayTime(String table, Timestamp replayTime) {
            this.table = table;
            this.lastReplayLogTime = replayTime;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public Timestamp getLastReplayLogTime() {
            return this.lastReplayLogTime;
        }

        public void setLastReplayLogTime(Timestamp lastReplayLogTime) {
            this.lastReplayLogTime = lastReplayLogTime;
        }
    }
}

