/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionPool;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SanityMergeOldPersistenceTables
implements CmdClazz {
    private Database database = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private JdbcConnectionPool pool = null;
    private ResultFileWriter resultFileWriter;
    private List<String> tables = new ArrayList<String>();
    private boolean createSqlFile = false;
    Integer parprocs = null;
    private boolean dd09l_only = false;
    private String addOptions = null;
    private static String CHECK = "CHECK";
    private static String SHD_EXECUTE = "SHD_EXECUTE";
    String countStarSql = "SELECT COUNT(*) FROM \"";
    String mergeTableSql = "MERGE DELTA OF \"";
    List<Future> tasks = new ArrayList<Future>();
    String oldPersictenceTablesSql = "select distinct TABLE_NAME from M_CS_COLUMNS_PERSISTENCE where SCHEMA_NAME = CURRENT_SCHEMA and PERSISTENCE_TYPE = 'VIRTUAL_FILE' or PERSISTENCE_TYPE = 'VIRTUAL_PAGED'";

    protected SanityMergeOldPersistenceTables() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            this.addOptions = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
    }

    @Override
    public void execute() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        String memParams = null;
        if (null != mem) {
            memParams = mem.read("[MergeOldPersictenceTables]");
        }
        if (null != memParams && (memParams.equalsIgnoreCase("false") || memParams.equalsIgnoreCase("no") || memParams.equalsIgnoreCase("0"))) {
            LogFactory.writeLogEntry(this.getClass(), "found [MergeOldPersictenceTables]" + memParams + ". Stop MergeOldPersictenceTables");
            return;
        }
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.sqlUser);
        this.unsetNseConfiguration(this.connection, this.sqlUser);
        if (null != this.addOptions) {
            this.readParams(this.addOptions);
        }
        if (null != memParams) {
            this.readParams(memParams);
        }
        if (this.needsMigration()) {
            this.findOldPersictenceTables();
        }
        if (0 == this.tables.size()) {
            this.resultFileWriter.append("true");
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Found " + this.tables.size() + " tables in old persistence format");
        if (this.createSqlFile) {
            this.createSqlFile();
            this.resultFileWriter.append("false");
            return;
        }
        if (null == this.parprocs) {
            this.mergeTables();
        } else if (this.parprocs < 2) {
            this.mergeTables();
        } else {
            this.mergeTablesParalell(this.parprocs);
        }
        this.resultFileWriter.append("true");
    }

    private void unsetNseConfiguration(JdbcConnection connection, DatabaseUser user) {
        LogFactory.writeLogEntry(this.getClass(), "Checking enable_native_storage_extension configuration...");
        DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
        DatabaseConfigurationSection section = config.getSection("nseconfig");
        String nse_config = section.getParameterValue("enable_native_storage_extension");
        if (null != nse_config && nse_config.equalsIgnoreCase("false")) {
            LogFactory.writeLogEntry(this.getClass(), "Found parameter enable_native_storage_extension: " + nse_config);
            section.unsetParameter("enable_native_storage_extension");
        }
    }

    private void createSqlFile() {
        PrintWriter pw;
        String fileName = "oldPersistenceTables.sql";
        File file = this.createFile(fileName);
        try {
            pw = new PrintWriter(new FileWriter(file, false));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
        for (String table : this.tables) {
            StringBuilder sb = new StringBuilder(this.countStarSql).append(table).append("\";");
            pw.println(sb.toString());
            sb = new StringBuilder(this.mergeTableSql).append(table).append("\" FORCE REBUILD;");
            pw.println(sb.toString());
            pw.flush();
        }
        pw.close();
        LogFactory.writeLogEntry(this.getClass(), "Sql script " + file.getAbsolutePath() + " generated.");
    }

    private File createFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new HdbException(file + " could not be created!");
                }
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
        }
        return file;
    }

    private void readParams(String params) {
        String[] splits = params.split(",");
        String parProcsParam = "";
        for (String part : splits) {
            part.trim();
            if (part.startsWith("parprocs=")) {
                parProcsParam = part.substring(part.indexOf("=") + 1);
            }
            if (part.equalsIgnoreCase(CHECK)) {
                this.createSqlFile = true;
            }
            if (part.equalsIgnoreCase(SHD_EXECUTE)) {
                this.dd09l_only = true;
            }
            LogFactory.writeLogEntry(this.getClass(), "Received option: " + part);
        }
        if (parProcsParam.length() > 0) {
            try {
                this.parprocs = Integer.parseInt(parProcsParam);
            }
            catch (NumberFormatException e) {
                LogFactory.writeLogEntry(this.getClass(), parProcsParam + " is not a number. " + e.getMessage());
            }
        }
    }

    private boolean needsMigration() {
        boolean needsMigration = true;
        String dbVersionSql = "SELECT VERSION FROM SYS.M_DATABASE";
        List<String> versions = this.connection.executeSQLCommand(dbVersionSql);
        String currentVersion = versions.get(0);
        if (!this.isSP4orHigher(currentVersion)) {
            return false;
        }
        return needsMigration;
    }

    private boolean isSP4orHigher(String currentVersion) {
        HdbVersion version = new HdbVersion(currentVersion);
        int major = version.getMajorVersion();
        int revision = version.getRevision();
        return major == 2 && revision >= 40;
    }

    private void mergeTables() {
        for (String table : this.tables) {
            this.connection.executeSQLCommand(this.countStarSql + table + "\"");
            this.connection.executeSQLCommand(this.mergeTableSql + table + "\" FORCE REBUILD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mergeTablesParalell(int jobs) {
        Object worker;
        int i;
        if (this.tables.size() < jobs) {
            jobs = this.tables.size();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(jobs);
        ArrayList chunks = new ArrayList();
        HashMap chunksMap = new HashMap(jobs);
        for (i = 0; i < jobs; ++i) {
            chunks.add(new ArrayList());
            chunksMap.put(i, new ArrayList());
        }
        for (i = 0; i < this.tables.size(); ++i) {
            ((List)chunksMap.get(i % jobs)).add(this.tables.get(i));
        }
        this.pool = new JdbcConnectionPool(this.jdbcDriver, this.database, jobs);
        for (i = 0; i < jobs; ++i) {
            class MergeThread
            implements Runnable {
                List<String> tablesToMerge;

                MergeThread(List<String> list) {
                    this.tablesToMerge = list;
                }

                @Override
                public void run() {
                    JdbcConnection conn = SanityMergeOldPersistenceTables.this.pool.getConnection();
                    conn.setConnectUser(SanityMergeOldPersistenceTables.this.sqlUser);
                    for (String table : this.tablesToMerge) {
                        conn.executeSQLCommand(SanityMergeOldPersistenceTables.this.mergeTableSql + table + "\" FORCE REBUILD");
                    }
                    SanityMergeOldPersistenceTables.this.pool.releaseConnection(conn);
                }
            }
            worker = new MergeThread((List)chunksMap.get(i));
            Future<?> future = executorService.submit((Runnable)worker);
            this.tasks.add(future);
        }
        int waitTime = 1000;
        worker = this;
        synchronized (worker) {
            while (!this.allTasksCompleted()) {
                try {
                    this.wait(waitTime);
                    if (waitTime >= 20000) continue;
                    waitTime += 1000;
                }
                catch (InterruptedException e) {
                    LogFactory.writeLogEntry(this.getClass(), "Error while waiting all tasks to complete " + e.getMessage());
                }
            }
        }
        try {
            executorService.awaitTermination(800L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            executorService.shutdownNow();
        }
        this.pool.shutdown();
        executorService.shutdown();
    }

    private boolean allTasksCompleted() {
        for (Future task : this.tasks) {
            if (task.isDone()) continue;
            return false;
        }
        return true;
    }

    private boolean cancelAllTasks() {
        for (Future task : this.tasks) {
            if (task.isDone()) continue;
            task.cancel(true);
        }
        return true;
    }

    private int determineCoresNumber() {
        int res = 10;
        int core = 0;
        ArrayList<Integer> threadsList = new ArrayList<Integer>();
        String cpuSql = "select value from SYS.M_HOST_INFORMATION where key in ('cpu_cores')";
        List<String> cores = this.connection.executeSQLCommand(cpuSql);
        for (String number : cores) {
            try {
                core = new Integer(number);
                threadsList.add(core);
            }
            catch (NumberFormatException e) {
                LogFactory.writeLogEntry(this.getClass(), number + " is not a number. " + e.getMessage());
            }
        }
        int sum = 0;
        for (Integer threads : threadsList) {
            sum += threads.intValue();
        }
        res = sum / threadsList.size();
        return res;
    }

    private void findOldPersictenceTables() {
        if (this.dd09l_only) {
            this.findOldPersictenceTablesWithLoadUnitP();
            return;
        }
        try {
            this.tables = this.connection.executeSQLCommand(this.oldPersictenceTablesSql);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find tables in old persictence format. " + e.getMessage());
        }
    }

    private void findOldPersictenceTablesWithLoadUnitP() {
        if (!BasisUtils.tableHasField("DD09L~", "LOAD_UNIT", this.connection)) {
            return;
        }
        try {
            this.tables = this.connection.executeSQLCommand("select TABNAME from \"DD09L~\" where LOAD_UNIT = 'P' and TABNAME in (" + this.oldPersictenceTablesSql + ")");
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find tables in old persictence format which have LOAD_UNIT = 'P' in DD09L~. " + e.getMessage());
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

