/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.HashMap;

public class SetDatabaseSystemUserPassword
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSystemUserPassword newSystemUserPassword = null;

    protected SetDatabaseSystemUserPassword() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.newSystemUserPassword = PasswordFactory.getDatabaseSystemUserNewPassword(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        LogFactory.writeLogEntry(this.getClass(), "Alter password for user SYSTEM");
        HashMap<String, String> policyBackup = PasswordPolicy.getCurrentPolicy(this.connection, this.systemUser);
        try {
            LogFactory.writeLogEntry(this.getClass(), "Disabling password policy temporary.");
            PasswordPolicy.disableCurrentPolicy(this.connection, this.systemUser);
            this.systemUser.alterPassword(this.connection, this.newSystemUserPassword);
        }
        catch (Exception e) {
            throw new HdbException(e);
        }
        finally {
            LogFactory.writeLogEntry(this.getClass(), "Restoring password policy.");
            PasswordPolicy.setPolicy(this.connection, this.systemUser, policyBackup);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

