/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.HashMap;
import java.util.Map;

public class SetDatabaseUserPassword
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSqlUserPassword newSqlUserPassword = null;

    protected SetDatabaseUserPassword() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.newSqlUserPassword = PasswordFactory.getDatabaseSqlUserPassword(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        LogFactory.writeLogEntry(this.getClass(), "Alter password for user: " + this.databaseUser.getName().get());
        HashMap<String, String> policyBackup = PasswordPolicy.getCurrentPolicy(this.connection, this.systemUser);
        Map<String, String> usergroupPolicyBackup = this.databaseUser.getCurrentUserGroupPolicy(this.connection, this.systemUser);
        try {
            LogFactory.writeLogEntry(this.getClass(), "Disabling password policy temporary.");
            if (usergroupPolicyBackup == null) {
                PasswordPolicy.disableCurrentPolicy(this.connection, this.systemUser);
            } else {
                PasswordPolicy.disableCurrentPolicy(this.connection, this.systemUser, this.databaseUser);
            }
            this.databaseUser.alterPassword(this.connection, this.systemUser, this.newSqlUserPassword);
        }
        catch (Exception e) {
            throw new HdbException(e);
        }
        finally {
            LogFactory.writeLogEntry(this.getClass(), "Restoring password policy configuration.");
            PasswordPolicy.setPolicy(this.connection, this.systemUser, policyBackup);
            if (usergroupPolicyBackup != null) {
                LogFactory.writeLogEntry(this.getClass(), "Restoring password policy user group.");
                this.databaseUser.setCurrentUserGroupPolicy(this.connection, this.systemUser, usergroupPolicyBackup);
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

