/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseLogMode;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class SetLogModeNormal
implements CmdClazz {
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;
    private DatabaseLogMode dbLogMode;
    private static String ARCHIVING_ENABLED_SUCCESSFULLY = "ARCHIVING_ENABLED_SUCCESSFULLY";
    private static String ARCHIVING_WAS_ENABLED = "ARCHIVING_WAS_ENABLED";
    private static String ARCHIVING_CANNOT_ENABLE = "ARCHIVING_CANNOT_ENABLE";
    private static String ARCHIVING_ENABLED_BUT_NO_BACKUP = "ARCHIVING_ENABLED_BUT_NO_BACKUP";

    protected SetLogModeNormal() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.dbLogMode = new DatabaseLogMode();
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.systemUser);
        }
        this.dbLogMode.check(this.connection, this.systemUser);
        if (this.dbLogMode.fullBackupExists()) {
            if (this.dbLogMode.isLogModeNormal()) {
                this.resultFileWriter.append(ARCHIVING_WAS_ENABLED);
                LogFactory.writeLogEntry(this.getClass(), "log_mode is already set to normal.");
            } else if (this.dbLogMode.isLogModeOverwrite()) {
                boolean success = this.dbLogMode.setLogMode(this.connection, this.systemUser, DatabaseLogMode.NORMAL);
                if (success) {
                    this.resultFileWriter.append(ARCHIVING_ENABLED_SUCCESSFULLY);
                    LogFactory.writeLogEntry(this.getClass(), "log_mode was successfully set to normal.");
                } else {
                    this.resultFileWriter.append(ARCHIVING_CANNOT_ENABLE);
                    LogFactory.writeLogEntry(this.getClass(), "log_mode could not be set to normal.");
                }
            } else if (this.dbLogMode.isLogModeNull()) {
                boolean success = false;
                try {
                    success = this.dbLogMode.setLogMode(this.connection, this.systemUser, DatabaseLogMode.NORMAL);
                }
                catch (HdbException e) {
                    LogFactory.writeLogEntry(this.getClass(), "log_mode could not be set to normal. " + e.getMessage());
                }
                if (success) {
                    this.resultFileWriter.append(ARCHIVING_ENABLED_SUCCESSFULLY);
                    LogFactory.writeLogEntry(this.getClass(), "log_mode was successfully set to normal.");
                } else {
                    this.resultFileWriter.append(ARCHIVING_CANNOT_ENABLE);
                    LogFactory.writeLogEntry(this.getClass(), "log_mode could not be set to normal.");
                }
            }
        } else {
            this.resultFileWriter.append(ARCHIVING_ENABLED_BUT_NO_BACKUP);
            LogFactory.writeLogEntry(this.getClass(), "No full backup exists, log_mode normal behaves like overwrite, ask user to make a full backup.");
        }
        this.resultFileWriter.append(this.dbLogMode.log_mode);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

