/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseLogMode;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class SetLogModeOverwrite
implements CmdClazz {
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;
    private DatabaseLogMode dbLogMode;
    private static String ARCHIVING_DISABLED_SUCCESSFULLY = "ARCHIVING_DISABLED_SUCCESSFULLY";
    private static String ARCHIVING_WAS_DISABLED = "ARCHIVING_WAS_DISABLED";
    private static String ARCHIVING_CANNOT_DISABLE = "ARCHIVING_CANNOT_DISABLE";

    protected SetLogModeOverwrite() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.dbLogMode = new DatabaseLogMode();
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.systemUser);
        }
        this.dbLogMode.check(this.connection, this.systemUser);
        if (this.dbLogMode.fullBackupExists()) {
            if (this.dbLogMode.isLogModeOverwrite()) {
                this.resultFileWriter.append(ARCHIVING_WAS_DISABLED);
                LogFactory.writeLogEntry(this.getClass(), "log_mode is already set to overwrite.");
            } else if (this.dbLogMode.isLogModeNormal()) {
                boolean success = this.dbLogMode.setLogMode(this.connection, this.systemUser, DatabaseLogMode.OVERWRITE);
                if (success) {
                    this.resultFileWriter.append(ARCHIVING_DISABLED_SUCCESSFULLY);
                    LogFactory.writeLogEntry(this.getClass(), "log_mode was successfully set to overwrite.");
                } else {
                    this.resultFileWriter.append(ARCHIVING_CANNOT_DISABLE);
                    LogFactory.writeLogEntry(this.getClass(), "log_mode could not be set to overwrite.");
                }
            }
        } else {
            this.resultFileWriter.append(ARCHIVING_WAS_DISABLED);
            LogFactory.writeLogEntry(this.getClass(), "No full backup exists, log_mode normal behaves like overwrite, no user interaction necessary.");
        }
        this.resultFileWriter.append(this.dbLogMode.log_mode);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

