/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.du.DU;
import com.sap.hdb.sl.lib.du.DUInStack;
import com.sap.hdb.sl.lib.du.DUPair;
import com.sap.hdb.sl.lib.du.DUReaderDB;
import com.sap.hdb.sl.lib.du.StackXmlReader;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class StackCheck
extends BatchExecutionBase {
    private Database database = null;
    private DatabaseUser systemUser = null;
    private DatabaseSqlUserName sqlUserName = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private String stackXml = null;
    List<DUPair> needsUpgradeList = null;
    private ResultFileWriter resultFileWriter = null;
    private String componentName;
    private String StackCheckAction;

    protected StackCheck() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
        this.stackXml = parameters.get(CmdClazzParameterName.STACK_XML).getValue();
        this.StackCheckAction = parameters.get(CmdClazzParameterName.STACK_CHECK_ACTION).getValue();
        if (this.StackCheckAction.equals(actions.CHECK_HANA_COMPONENT.name())) {
            this.componentName = parameters.get(CmdClazzParameterName.COMPONENT_NAME).getValue();
            this.database = InstanceFactory.getDatabaseInstance(parameters);
            this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
            this.jdbcDriver = new JdbcDriver(parameters);
            if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_NAME)) {
                this.sqlUserName = new DatabaseSqlUserName(parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_NAME).getValue());
            }
        }
    }

    @Override
    public void execute() {
        List<DUInStack> dUnitsInStack = null;
        if (null != this.stackXml) {
            LogFactory.writeLogEntry(this.getClass(), "Using stack xml " + this.stackXml);
            try {
                StackXmlReader reader = new StackXmlReader(this.stackXml);
                dUnitsInStack = reader.findDUs();
            }
            catch (ParserConfigurationException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error during parsing of stack.xml " + this.stackXml + " message: " + e.getMessage());
                throw new HdbException(e);
            }
            catch (SAXException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error during parsings of stack.xml " + this.stackXml + " message: " + e.getMessage());
                throw new HdbException(e);
            }
            catch (IOException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error during reading of stack.xml " + this.stackXml + " message: " + e.getMessage());
                throw new HdbException(e);
            }
        }
        if (dUnitsInStack.size() == 0) {
            this.resultFileWriter.append("false");
            this.resultFileWriter.append("No HANA Software components found in stack file.");
            LogFactory.writeLogEntry(this.getClass(), "No HANA Software components found in in stack file.");
            return;
        }
        String components = "";
        for (DUInStack du : dUnitsInStack) {
            components = components + "," + du.getDELIVERY_UNIT();
        }
        components = components.substring(1);
        LogFactory.writeLogEntry(this.getClass(), "HANA Software components found in stack file.: " + components + ".");
        if (this.StackCheckAction.equals(actions.GET_HANA_COMPONENTS.name())) {
            this.resultFileWriter.append("true");
            this.resultFileWriter.append(components);
        } else if (this.StackCheckAction.equals(actions.CHECK_HANA_COMPONENT.name())) {
            DU dUnitInStack = null;
            for (DUInStack du : dUnitsInStack) {
                if (!du.getDELIVERY_UNIT().equalsIgnoreCase(this.componentName)) continue;
                dUnitInStack = du;
            }
            if (dUnitInStack == null) {
                this.resultFileWriter.append("false");
                this.resultFileWriter.append("HANA Software component " + this.componentName + " not found in stack file.");
                LogFactory.writeLogEntry(this.getClass(), "HANA Software component " + this.componentName + " not found in stack file.");
                return;
            }
            this.resultFileWriter.append("true");
            LogFactory.writeLogEntry(this.getClass(), dUnitInStack.print());
            if (!this.checkStackComponentInDB((DUInStack)dUnitInStack)) {
                this.resultFileWriter.append("true");
                this.resultFileWriter.append(this.componentName + ": Missing or older software component found in DB.");
                LogFactory.writeLogEntry(this.getClass(), this.componentName + ": Missing or older component found in DB.");
            } else {
                this.resultFileWriter.append("false");
                this.resultFileWriter.append(this.componentName + ": Software component already installed.");
                LogFactory.writeLogEntry(this.getClass(), this.componentName + ": Software component already installed.");
            }
        } else {
            this.resultFileWriter.append("false");
            this.resultFileWriter.append("Incorrect stack.xml option.");
            LogFactory.writeLogEntry(this.getClass(), this.StackCheckAction + ": Incorrect stack.xml option.");
        }
    }

    private boolean checkStackComponentInDB(DUInStack dUnitInStack) {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.systemUser);
        List<DU> dUnitsInDb = DUReaderDB.listDUs(this.connection);
        List<DU> pluginsInDb = DUReaderDB.listPlugins(this.connection);
        dUnitsInDb.addAll(pluginsInDb);
        return this.checkOnDB(dUnitInStack, dUnitsInDb);
    }

    private boolean checkOnDB(DUInStack duInStack, List<DU> dUnitsInDb) {
        for (DU duInDb : dUnitsInDb) {
            if (!duInStack.sameName(duInDb)) continue;
            return duInDb.getDuVersion().isVersionBiggerOrEqual(duInStack.getDuVersion());
        }
        return false;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    private static enum actions {
        GET_HANA_COMPONENTS,
        CHECK_HANA_COMPONENT;

    }
}

