/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class StartDatabaseBackup
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSystemUser systemUser = null;
    private Database database = null;
    private JdbcConnection connection = null;
    private DatabaseBackupName backupName;
    private ResultFileWriter resultFileWriter;

    protected StartDatabaseBackup() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.jdbcDriver = new JdbcDriver(parameters);
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.database.setConnectUser(this.systemUser);
        this.backupName = new DatabaseBackupName(parameters);
    }

    @Override
    public void execute() {
        long dbSize;
        List<String> result;
        if (this.connection == null) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if ((result = this.connection.executeSQLCommand("SELECT SUM(CASE WHEN \"LOG_SIZE\" = -1 then \"DATA_SIZE\" else \"LOG_SIZE\" END) AS TOTAL_BYTES from \"PUBLIC\".\"M_VOLUME_SIZES\"")) == null || result.size() == 0) {
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append("Error determining the database size.");
            return;
        }
        try {
            dbSize = Long.parseLong(result.get(0));
        }
        catch (NumberFormatException e) {
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append("The database size returned by the database is not a valid number: " + result.get(0));
            return;
        }
        try {
            this.connection.executeSQLCommandNoReslt("BACKUP CHECK USING FILE ('" + this.backupName.getValue() + "') SIZE " + dbSize);
        }
        catch (HdbException e) {
            this.resultFileWriter.append(String.valueOf(false));
            if (this.connection.getErrorCode() == 14) {
                this.resultFileWriter.append("There is not enough space available on the backup volume.");
            } else {
                this.resultFileWriter.append("An unknown error occurred: " + e.getMessage());
            }
            return;
        }
        String limitation = "ALL";
        if (this.connection.isMultiDB()) {
            limitation = " FOR " + this.database.getSid();
        }
        try {
            this.connection.executeSQLCommandNoReslt("BACKUP DATA " + limitation + " USING FILE ('" + this.backupName.getValue() + "')");
        }
        catch (HdbException e) {
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append("An error occurred while executing the database backup: " + e.getMessage());
            return;
        }
        this.resultFileWriter.append(String.valueOf(true));
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

