/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseBackupLocation;
import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class StartDatabaseBackupTenant
implements CmdClazz {
    private DatabaseBackupName backupName;
    private DatabaseBackupLocation backupLocation;
    private String backupOptions = "";
    private Sid tenantSid;
    private DatabaseSystemUser systemDatabaseUser;
    private Database systemDatabase;
    private JdbcDriver jdbcDriver;
    private ResultFileWriter resultWriter;

    protected StartDatabaseBackupTenant() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.backupName = new DatabaseBackupName(parameters);
        this.backupLocation = new DatabaseBackupLocation(parameters);
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_BACKUP_OPTIONS)) {
            this.backupOptions = parameters.get(CmdClazzParameterName.DATABASE_BACKUP_OPTIONS).getValue();
        }
    }

    @Override
    public void execute() {
        String backupPath = this.backupLocation.getValue() + "/" + this.backupName.getValue();
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
        LogFactory.writeLogEntry(this.getClass(), "Starting backup of HANA tenant  " + this.tenantSid + " to location " + backupPath + " with backup options: [" + this.backupOptions + "]");
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        tenant.startBackup(connection, this.systemDatabaseUser, backupPath, this.backupOptions);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

