/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.instance.DatabaseBackupLocation;
import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.DoesDataBackupExist;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.Holder;

public class StartDatabaseRecovery
implements CmdClazz {
    private static final long SHUTDOWN_TIMEOUT = 1800000L;
    private static final long STARTUP_TIMEOUT = 3600000L;
    private OperatingSystemUser systemUser;
    private SAPControlWsdlUrl wsdlUrl;
    private DatabaseBackupName backupName;
    private DatabaseBackupLocation backupLocation;
    private ResultFileWriter resultWriter;
    private DoesDataBackupExist doesDataBackupExist;
    private SAPControlHelper helper = new SAPControlHelper();

    protected StartDatabaseRecovery() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.systemUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        this.backupName = new DatabaseBackupName(parameters);
        this.backupLocation = new DatabaseBackupLocation(parameters);
        this.doesDataBackupExist = new DoesDataBackupExist();
        this.doesDataBackupExist.setArguments(parameters);
    }

    @Override
    public void execute() {
        LogFactory.writeLogEntry(this.getClass(), "Creating SAPControl web service client.");
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.systemUser.getName().get(), this.systemUser.getPassword().get());
        boolean backupExists = this.doesDataBackupExist.doesDataBackupExist(port);
        if (!backupExists) {
            String message = "A backup named '" + this.backupName.getValue() + "' does not exist at " + this.backupLocation.getValue();
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.BACKUP_DOES_NOT_EXIST.toString());
            this.resultWriter.append(message);
            return;
        }
        boolean onWindows = this.helper.onWindows(port);
        LogFactory.writeLogEntry(this.getClass(), "Getting HANA system environment.");
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (instanceDir == null) {
            String message = "Unable to determine the value of environment variable DIR_INSTANCE. Please set the variable on the HANA database host and retry.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.DIR_INSTANCE_NOT_FOUND.toString());
            this.resultWriter.append(message);
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Stopping HANA instance at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort());
        try {
            this.helper.stopSystem(port, 1800000L);
        }
        catch (TimeoutException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.TIMEOUT_SHUTDOWN.toString());
            this.resultWriter.append(e.getMessage());
            return;
        }
        catch (InterruptedException e1) {
            String message = "The current thread was interrpted while waiting for the database to shut down.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.TIMEOUT_SHUTDOWN.toString());
            this.resultWriter.append(message);
            return;
        }
        String backupPath = this.backupLocation.getValue() + "/" + this.backupName.getValue();
        LogFactory.writeLogEntry(this.getClass(), "Starting recovery of HANA database at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort() + " from files " + backupPath + "*");
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = onWindows ? instanceDir + "/HDBSettings.bat recoverSys.py --command=\"RECOVER DATA ALL USING FILE ('" + backupPath + "') CLEAR LOG\" --wait" : instanceDir + "/HDBSettings.sh recoverSys.py --command=RECOVER\\ DATA\\ ALL\\ USING\\ FILE\\ ('" + backupPath + "')\\ CLEAR\\ LOG --wait";
        port.osExecute(command, 0, 0, "recoverStart.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        int rc = 0;
        for (String line : ((ArrayOfString)lines.value).getItem()) {
            int rcIndex = line.indexOf("rc");
            if (rcIndex <= 0 || line.length() <= rcIndex + 7) continue;
            String result = line.substring(rcIndex + 2, rcIndex + 7);
            if (!(result = result.trim()).startsWith("=")) continue;
            result = result.substring(1);
            if (!this.isInteger(result = result.trim())) continue;
            rc = new Integer(result);
        }
        if (exitcode.value == null || (Integer)exitcode.value != 0 || rc != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Recovery failed (rc = " + rc + ").");
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.RECOVERY_ERROR.toString());
            this.resultWriter.append("Error triggering recovery (RC=" + rc + ").");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                this.resultWriter.append(line);
            }
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Starting HANA instance at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort());
        try {
            this.helper.startSystem(port, 3600000L);
        }
        catch (TimeoutException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            this.resultWriter.append(String.valueOf(true));
            this.resultWriter.append(Status.TIMEOUT_STARTUP.toString());
            this.resultWriter.append(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "The current thread was interrpted while waiting for the database to start up.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(true));
            this.resultWriter.append(Status.TIMEOUT_STARTUP.toString());
            this.resultWriter.append(message);
        }
        this.resultWriter.append(String.valueOf(true));
        this.resultWriter.append(Status.SUCCESS.toString());
        LogFactory.writeLogEntry(this.getClass(), "Database recovery was successful.");
    }

    private boolean isInteger(String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (i == 0 && string.charAt(i) == '-' && string.length() > 1 || Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    private static enum Status {
        SUCCESS,
        TIMEOUT_SHUTDOWN,
        TIMEOUT_STARTUP,
        BACKUP_DOES_NOT_EXIST,
        DIR_INSTANCE_NOT_FOUND,
        RECOVERY_ERROR;

    }
}

