/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.ExternalBackupTool;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.DoesBackintFolderExist;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.Holder;

public class StartDatabaseRecoveryBackint
implements CmdClazz {
    private static final long SHUTDOWN_TIMEOUT = 1800000L;
    private OperatingSystemUser systemUser;
    private SAPControlWsdlUrl wsdlUrl;
    private DatabaseBackupName backupName;
    private ResultFileWriter resultWriter;
    private SAPControlHelper helper = new SAPControlHelper();
    private ExternalBackupTool externalBackupTool;
    private DoesBackintFolderExist doesBackintFolderExist;

    protected StartDatabaseRecoveryBackint() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.systemUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        this.backupName = new DatabaseBackupName(parameters);
        this.externalBackupTool = new ExternalBackupTool(parameters);
        this.doesBackintFolderExist = new DoesBackintFolderExist();
        this.doesBackintFolderExist.setArguments(parameters);
    }

    @Override
    public void execute() {
        LogFactory.writeLogEntry(this.getClass(), "Creating SAPControl web service client.");
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.systemUser.getName().get(), this.systemUser.getPassword().get());
        boolean backintFolderExists = this.doesBackintFolderExist.doesBackintFolderExist(port);
        if (!backintFolderExists) {
            String message = "The external backup interface is called but the global backint folder is missing: '" + this.externalBackupTool.getBackintLocation();
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.BACKUP_DOES_NOT_EXIST.toString());
            this.resultWriter.append(message);
            return;
        }
        boolean onWindows = this.helper.onWindows(port);
        LogFactory.writeLogEntry(this.getClass(), "Getting HANA system environment.");
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (instanceDir == null) {
            String message = "Unable to determine the value of environment variable DIR_INSTANCE. Please set the variable on the HANA database host and retry.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.DIR_INSTANCE_NOT_FOUND.toString());
            this.resultWriter.append(message);
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Stopping HANA instance at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort());
        try {
            this.helper.stopSystem(port, 1800000L);
        }
        catch (TimeoutException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.TIMEOUT_SHUTDOWN.toString());
            this.resultWriter.append(e.getMessage());
            return;
        }
        catch (InterruptedException e1) {
            String message = "The current thread was interrpted while waiting for the database to shut down.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.TIMEOUT_SHUTDOWN.toString());
            this.resultWriter.append(message);
            return;
        }
        String backupPath = "";
        backupPath = this.backupName.getValue();
        LogFactory.writeLogEntry(this.getClass(), "Starting recovery of HANA database at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort() + " using external backup " + backupPath + "*");
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = onWindows ? instanceDir + "/HDBSettings.bat recoverSys.py --command=\"RECOVER DATA USING SOURCE '" + this.externalBackupTool.getSourceSid() + "' USING BACKINT ('" + backupPath + "') CLEAR LOG\" --wait" : instanceDir + "/HDBSettings.sh recoverSys.py --command=RECOVER\\ DATA\\ USING\\ SOURCE\\ '" + this.externalBackupTool.getSourceSid() + "'\\ USING\\ BACKINT\\ ('" + backupPath + "')\\ CLEAR\\ LOG --wait";
        port.osExecute(command, 0, 0, "recoverStart.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0 || this.containsError((Holder<ArrayOfString>)lines)) {
            LogFactory.writeLogEntry(this.getClass(), "Recovery failed !");
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.RECOVERY_ERROR.toString());
            this.resultWriter.append("Error triggering recovery");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                this.resultWriter.append(line);
                LogFactory.writeLogEntry(this.getClass(), line);
            }
            return;
        }
        this.resultWriter.append(String.valueOf(true));
        this.resultWriter.append(Status.SUCCESS.toString());
        LogFactory.writeLogEntry(this.getClass(), "Database recovery was successful.");
    }

    private boolean containsError(Holder<ArrayOfString> lines) {
        boolean containsError = false;
        for (String line : ((ArrayOfString)lines.value).getItem()) {
            if (!line.contains("ERROR")) continue;
            containsError = true;
        }
        return containsError;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    private static enum Status {
        SUCCESS,
        TIMEOUT_SHUTDOWN,
        TIMEOUT_STARTUP,
        BACKUP_DOES_NOT_EXIST,
        DIR_INSTANCE_NOT_FOUND,
        RECOVERY_ERROR;

    }
}

