/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseBackupLocation;
import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class StartDatabaseRecoveryTenant
implements CmdClazz {
    private DatabaseBackupName backupName;
    private DatabaseBackupLocation backupLocation;
    private Sid tenantSid;
    private DatabaseSystemUser systemDatabaseUser;
    private Database systemDatabase;
    private JdbcDriver jdbcDriver;
    private ResultFileWriter resultWriter;

    protected StartDatabaseRecoveryTenant() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.backupName = new DatabaseBackupName(parameters);
        this.backupLocation = new DatabaseBackupLocation(parameters);
    }

    @Override
    public void execute() {
        LogFactory.writeLogEntry(this.getClass(), "Stopping HANA tenant " + this.tenantSid);
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        LogFactory.writeLogEntry(this.getClass(), "Stopping HANA tenant " + this.tenantSid + "...", true);
        tenant.stop(connection, this.systemDatabaseUser);
        String backupPath = this.backupLocation.getValue() + "/" + this.backupName.getValue();
        LogFactory.writeLogEntry(this.getClass(), "Starting recovery of HANA tenant  " + this.tenantSid + " from files " + backupPath + "*");
        tenant.startRecoveryAsync(connection, this.systemDatabaseUser, backupPath);
        LogFactory.writeLogEntry(this.getClass(), "Starting HANA tenant " + this.tenantSid, true);
        tenant.start(connection, this.systemDatabaseUser);
        LogFactory.writeLogEntry(this.getClass(), "Database recovery was successful.");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

