/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.TableConsistencyChecksHelper;

public class TableConsistencyChecksDisable
implements CmdClazz {
    private Database database = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSystemUser systemUser = null;
    private String collectorStatus = "";
    private ResultFileWriter writer;

    protected TableConsistencyChecksDisable() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        if (TableConsistencyChecksHelper.skipExecution(this.connection, this.systemUser)) {
            return;
        }
        try {
            this.showCollectorSchedule();
            this.saveCollectorState();
            this.disableCollector();
            this.writer.append("true");
        }
        catch (Exception e) {
            this.writer.append("false");
        }
    }

    private void showCollectorSchedule() {
        this.collectorStatus = TableConsistencyChecksHelper.executeProcedure(TableConsistencyChecksHelper.SHOW_SCHEDULE_PROCEDURE, this.connection);
        LogFactory.writeLogEntry(this.getClass(), "Found Collector_Global_Table_Consistency: " + this.collectorStatus);
    }

    private void saveCollectorState() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        mem.save(TableConsistencyChecksHelper.COLLECTOR_GLOBAL_TABLE_CONSISTENCY, this.collectorStatus);
    }

    private void disableCollector() {
        String newCollectorStatus = TableConsistencyChecksHelper.executeProcedure(TableConsistencyChecksHelper.DISABLE_COLLECTOR_PROCEDURE, this.connection);
        LogFactory.writeLogEntry(this.getClass(), "Changed Collector_Global_Table_Consistency schedule from " + this.collectorStatus + " to " + newCollectorStatus);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

