/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TableConsistencyChecksHelper {
    public static String COLLECTOR_GLOBAL_TABLE_CONSISTENCY = "[Collector_Global_Table_Consistency]";
    public static String SHOW_SCHEDULE_PROCEDURE = "{CALL CHECK_TABLE_CONSISTENCY('SHOW_SCHEDULE', NULL, NULL)}";
    public static String ENABLE_COLLECTOR_PROCEDURE = "{CALL CHECK_TABLE_CONSISTENCY('SET_COLLECTOR_SCHEDULE', 'STATUS', 'ACTIVE')}";
    public static String DISABLE_COLLECTOR_PROCEDURE = "{CALL CHECK_TABLE_CONSISTENCY('SET_COLLECTOR_SCHEDULE', 'STATUS', 'INACTIVE')}";
    public static String INACTIVE = "Inactive";
    public static String ACTIVE = "Active";
    public static String IDLE = "Idle";

    public static String executeProcedure(String procedure, JdbcConnection connection) {
        String status = "";
        try {
            CallableStatement cs = connection.getConnection().prepareCall(procedure);
            cs.execute();
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                String name = rs.getString("NAME");
                if (!name.equalsIgnoreCase("COLLECTOR")) continue;
                status = rs.getString("STATUS");
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 328 || e.getErrorCode() == 8) {
                LogFactory.writeLogEntry(TableConsistencyChecksHelper.class, "received from database: " + e.getMessage() + " I give up.");
            }
            throw new HdbException(e.getMessage());
        }
        return status;
    }

    public static boolean skipExecution(JdbcConnection connection, DatabaseUser user) {
        HdbVersion version = new HdbVersion(connection, user);
        if (version.getMajorVersion() == 1 && version.getRevision() == 122 && version.getSubRevision() == 22) {
            LogFactory.writeLogEntry(TableConsistencyChecksHelper.class, "Skip disable/enable Collector_Global_Table_Consistency on HANA Version " + version.get());
            return true;
        }
        return false;
    }
}

