/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class UpdateRepairRolesAndPrivileges
extends BatchExecutionBase {
    private JdbcConnection connection;
    private DatabaseSqlUser sqlUser;
    private DatabaseSystemUser systemUser;
    private String option = null;

    protected UpdateRepairRolesAndPrivileges() {
    }

    @Override
    public void execute() {
        this.sqlUser = DatabaseSqlUserFactory.getUser(this.parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(this.parameters);
        Database database = InstanceFactory.getDatabaseInstance(this.parameters);
        JdbcDriver jdbcDriver = new JdbcDriver(this.parameters);
        this.connection = JdbcConnectionFactory.getInstance(jdbcDriver, database);
        String userName = this.sqlUser.getName().get();
        if (this.parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            this.option = this.parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
            if (null != this.option && this.option.startsWith("destvers=")) {
                String destvers = this.option.substring(this.option.indexOf("=") + 1);
                try {
                    Integer.parseInt(destvers);
                    LogFactory.writeLogEntry(UpdateRepairRolesAndPrivileges.class, "Using: " + this.option);
                    HdbsllibMem mem = HdbsllibMem.getInstance();
                    mem.save(HdbsllibMem.DESTVERS, destvers);
                }
                catch (NumberFormatException nfe) {
                    destvers = null;
                }
            }
        }
        this.abortForForbiddenUserNames(userName);
        if ("DBACOCKPIT".equalsIgnoreCase(userName)) {
            this.repairRolesForUserDbacockpit();
        } else {
            this.repairRolesForUserDbacockpit();
            this.repairRolesForSqlUser();
        }
        HdbsllibMem mem = HdbsllibMem.getInstance();
        mem.delete(HdbsllibMem.DESTVERS);
        this.writer.append("true");
    }

    private void repairRolesForSqlUser() {
        DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.USER);
        this.parameters.put(CmdClazzParameterName.DATABASE_USER_ROLE, new DatabaseUserRoleName(DatabaseUserRoleName.Role.USER));
        MissingPrivileges missing = role.checkPrivileges(this.connection, this.systemUser, this.sqlUser);
        if (missing.hasMissing()) {
            this.executeCmdClazz(CmdClazzName.CREATE_ROLE);
        }
        this.grantRoleToUser(role, this.sqlUser);
        this.executeCmdClazzes(new CmdClazzNameIF[]{CmdClazzName.ADD_SQL_PRIVILEGES_TO_DBACOCKPIT_ROLE, CmdClazzName.CREATE_ABAP_ROLES, CmdClazzName.ADD_SQL_PRIVILEGES_TO_ABAP_ROLES, CmdClazzName.ADD_AFL_ROLES_TO_USER, CmdClazzName.CREATE_LCAALERTS_SCHEMA, CmdClazzName.ADD_PRIVILEGES_TO_SYS_REPO, CmdClazzName.CREATE_TABLE_REDISTRIBUTION_ROLE, CmdClazzName.HDI_CHECK_REPAIR_PRIVILEGES, CmdClazzName.CREATE_DATABASE_CONFIGURATIONS, CmdClazzName.ADD_PRIVILEGES_FOR_EPM});
    }

    private void repairRolesForUserDbacockpit() {
        DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.DBA_COCKPIT);
        this.parameters.put(CmdClazzParameterName.DATABASE_USER_ROLE, new DatabaseUserRoleName(DatabaseUserRoleName.Role.DBA_COCKPIT));
        MissingPrivileges missing = role.checkPrivileges(this.connection, this.systemUser, this.sqlUser);
        if (missing.hasMissing()) {
            this.executeCmdClazz(CmdClazzName.CREATE_ROLE);
        }
        this.grantRoleToUser(role, this.sqlUser);
    }

    private void abortForForbiddenUserNames(String userName) {
        if (userName.equalsIgnoreCase("SYSTEM") || userName.equalsIgnoreCase("SYS") || userName.startsWith("_")) {
            throw new HdbException(userName + " is not a valid SQL user for this CmdClazz!");
        }
    }

    public void grantRoleToUser(DatabaseUserRole role, DatabaseSqlUser sqlUser) {
        boolean granted = PrivilegesUtils.checkRole(this.connection, role.getName().get(), sqlUser.getName().get());
        if (!granted) {
            role.grantTo(this.connection, this.systemUser, sqlUser);
        }
    }
}

