/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class VLSchema
implements CmdClazz {
    private ResultFileWriter writer;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private String addOptions = null;
    private String action = null;
    private String schemaName = null;

    protected VLSchema() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            this.addOptions = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        if (null != this.addOptions) {
            this.readOptions(this.addOptions);
        }
        if (null == this.schemaName && "CREATE".equalsIgnoreCase(this.action)) {
            this.findSchemaName();
        }
        if (null == this.schemaName) {
            this.writer.append("false");
            return;
        }
        if ("CREATE".equalsIgnoreCase(this.action)) {
            if (this.schemaExist()) {
                LogFactory.writeLogEntry(this.getClass(), "Schemas " + this.schemaName + " exist on the database! Stop execution.");
                this.writer.append("false");
                this.writer.append("SCHEMA_EXIST");
                return;
            }
            this.createSchema();
        } else if ("DROP".equalsIgnoreCase(this.action)) {
            if (this.schemaExist()) {
                this.dropSchema();
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Schemas " + this.schemaName + " does not exist on the database! Nothing to DROP.");
            }
        }
        this.writer.append("true");
    }

    private void findSchemaName() {
        String vl = this.databaseUser.getName().get() + "VL";
        boolean vlExist = false;
        String vlx = this.databaseUser.getName().get() + "VLX";
        boolean vlxExist = false;
        String sql = "SELECT SCHEMA_NAME FROM SCHEMAS WHERE SCHEMA_NAME like '<SAPSID>VL%'";
        sql = sql.replace("<SAPSID>", this.databaseUser.getName().get());
        List<String> result = this.connection.executeSQLCommand(sql);
        for (String schema : result) {
            if (schema.equalsIgnoreCase(vl)) {
                vlExist = true;
                continue;
            }
            if (!schema.equalsIgnoreCase(vlx)) continue;
            vlxExist = true;
        }
        if (vlExist && vlxExist) {
            LogFactory.writeLogEntry(this.getClass(), "Both Schemas " + vl + " and " + vlx + " exist on the database! Stop execution.");
        } else if (!vlExist) {
            this.schemaName = vl;
        } else if (!vlxExist) {
            this.schemaName = vlx;
        }
    }

    private void createSchema() {
        String sql = "CREATE SCHEMA <SCHEMA_NAME> OWNED BY <SAPSID>";
        sql = sql.replace("<SCHEMA_NAME>", this.schemaName);
        sql = sql.replace("<SAPSID>", this.databaseUser.getName().get());
        this.connection.executeSQLCommandNoReslt(sql);
    }

    private void dropSchema() {
        if (null != this.databaseUser.getPassword()) {
            this.connection.setConnectUser(this.databaseUser);
        }
        String sql = "DROP SCHEMA <SCHEMA_NAME> CASCADE";
        sql = sql.replace("<SCHEMA_NAME>", this.schemaName);
        this.connection.executeSQLCommandNoReslt(sql);
    }

    private boolean schemaExist() {
        String sql = "SELECT SCHEMA_NAME FROM SCHEMAS WHERE SCHEMA_NAME = '" + this.schemaName + "'";
        List<String> result = this.connection.executeSQLCommand(sql);
        if (result.isEmpty()) {
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "VL Schema exists: " + result.get(0));
        return true;
    }

    private void readOptions(String params) {
        String[] splits;
        for (String part : splits = params.split(",")) {
            part.trim();
            if (part.startsWith("action=")) {
                this.action = part.substring(part.indexOf("=") + 1);
            }
            if (part.startsWith("schemaName=")) {
                this.schemaName = part.substring(part.indexOf("=") + 1);
            }
            LogFactory.writeLogEntry(this.getClass(), "Received option: " + part);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

