/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.core.main.cmd;

import com.sap.hdb.core.exceptions.HdbException;
import com.sap.hdb.core.main.log.OutWriter;
import com.sap.hdb.core.manifest.HdbCoreManifest;
import com.sap.hdb.core.manifest.HdbCoreVersion;
import com.sap.hdb.sl.lib.HdbSlLib;
import com.sap.hdb.sl.lib.HdbSlLibFactory;
import com.sap.hdb.sl.lib.logging.LogEvent;
import com.sap.hdb.sl.lib.logging.LogManager;
import com.sap.hdb.sl.lib.logging.LogWriter;
import com.sap.hdb.sl.lib.logging.LogWriterFile;
import com.sap.hdb.sl.lib.manifest.HdbSlLibVersion;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzRunner;
import java.io.File;
import java.io.IOException;

public class HdbCmdMain {
    private OutWriter cmdWriter = null;
    private HdbSlLib hdbSlLib = null;
    private LogManager logManager = null;
    private LogWriter logFileWriter = null;
    private LogWriter stderrWriter = null;
    private String[] args = null;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            int read;
            byte[] buffer = new byte[80];
            String input = "";
            String lineSep = System.getProperty("line.separator");
            while ((read = System.in.read(buffer, 0, 80)) != -1) {
                input = input + new String(buffer, 0, read, "UTF-8");
            }
            args = input.split(lineSep);
        }
        try {
            HdbCmdMain cmd = new HdbCmdMain(args);
            cmd.execute();
        }
        catch (HdbException e) {
            System.exit(1);
        }
    }

    public HdbCmdMain(String[] args) throws HdbException {
        this.args = args;
        this.hdbSlLib = HdbSlLibFactory.getInstance();
        this.logFileWriter = this.getLogWriterImplementation();
        this.stderrWriter = this.getStderrWriterImplementation();
        this.logManager = this.hdbSlLib.getLogManager();
        this.logManager.addLogWriter(this.logFileWriter);
    }

    public void execute() throws HdbException {
        try {
            this.writeStartEntry();
            CmdClazzRunner cmdClazzRunner = this.hdbSlLib.getCmdClazzRunner(this.args);
            CmdClazz cmdClazz = cmdClazzRunner.getCmdClazz();
            this.writeNameOfCmdClazz(cmdClazz);
            cmdClazz.execute();
            this.writeEndOfSection(cmdClazz);
        }
        catch (Exception e) {
            if (null != e.getMessage()) {
                this.writeError(e);
                throw new HdbException(e.getMessage());
            }
            throw new HdbException(e);
        }
        finally {
            if (null != this.hdbSlLib) {
                this.hdbSlLib.closeJdbcConnections();
            }
            this.writeSectionSeparator();
        }
    }

    private void writeSectionSeparator() {
        this.logManager.writeLogEntry(this.getClass(), "*************************************************************");
    }

    private void writeError(Exception e) {
        this.logManager.writeLogEntry(this.getClass(), "Error during execution of HdbCmdClazz section!");
        this.logManager.addLogWriter(this.stderrWriter);
        this.logManager.writeLogEntry(this.getClass(), e.getMessage());
        this.logManager.removeLogWriter(this.stderrWriter);
        StackTraceElement[] sArr = e.getStackTrace();
        for (int i = 0; i < sArr.length; ++i) {
            this.logManager.writeLogEntry(this.getClass(), sArr[i].toString());
        }
    }

    private void writeEndOfSection(CmdClazz cmdClazz) {
        this.logManager.writeLogEntry(this.getClass(), "End of HdbCmdClazz section: " + cmdClazz.getClass());
    }

    private void writeNameOfCmdClazz(CmdClazz cmdClazz) {
        this.logManager.writeLogEntry(this.getClass(), "Name of HdbCmdClazz: " + cmdClazz.getClass());
    }

    private void writeStartEntry() {
        this.logManager.writeLogEntry(this.getClass(), "Start new command section");
        HdbCoreManifest hdbManifest = new HdbCoreManifest();
        HdbCoreVersion hdbCoreVersion = new HdbCoreVersion(hdbManifest);
        String hdbCoreChangeList = hdbCoreVersion.getChangelist();
        String hdbCoreApiVersion = hdbCoreVersion.getApiVersion();
        String hdbCoreRelease = hdbCoreVersion.getRelease();
        this.logManager.writeLogEntry(this.getClass(), "Version of com.sap.hdb.core.jar | Changelist: " + hdbCoreChangeList + " | Release: " + hdbCoreRelease + " | API-Version: " + hdbCoreApiVersion);
        HdbSlLibVersion hdbSlLibVersion = this.hdbSlLib.getVersion();
        String hdbSlLibChangeList = hdbSlLibVersion.getChangelist();
        String hdbSlLibApiVersion = hdbSlLibVersion.getApiVersion();
        String hdbSlLibRelease = hdbSlLibVersion.getRelease();
        this.logManager.writeLogEntry(this.getClass(), "Version of com.sap.hdb.sl.lib.jar | Changelist: " + hdbSlLibChangeList + " | Release: " + hdbSlLibRelease + " | API-Version: " + hdbSlLibApiVersion);
    }

    private LogWriter getLogWriterImplementation() {
        final File fileName = new File("HdbCmdOut.log");
        this.cmdWriter = OutWriter.getInstance(fileName);
        LogWriterFile cmdLogger = new LogWriterFile(){

            public void append(LogEvent event) {
                HdbCmdMain.this.cmdWriter.writeToFile(event.getTimestamp() + " | " + event.getClassName() + " | " + event.getMessage());
            }

            public File getLogFile() {
                return new File(fileName.getAbsolutePath());
            }
        };
        return cmdLogger;
    }

    private LogWriter getStderrWriterImplementation() {
        LogWriter stderrLogger = new LogWriter(){

            public void append(LogEvent event) {
                System.err.println(event.getTimestamp() + " | " + event.getClassName() + " | " + event.getMessage());
            }
        };
        return stderrLogger;
    }
}

