/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.core.main.log;

import com.sap.hdb.core.main.log.OutFileWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class OutWriter {
    private OutFileWriter writer = null;
    private static OutWriter instance = null;

    public static OutWriter getInstance(File logFile) {
        if (instance == null) {
            instance = new OutWriter(logFile);
        }
        return instance;
    }

    private OutWriter(File logFile) {
        try {
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            FileWriter fw = new FileWriter(logFile, true);
            this.writer = new OutFileWriter(new PrintWriter(fw));
        }
        catch (Exception e) {
            try {
                this.writer = new OutFileWriter(new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")));
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException(e1.getMessage());
            }
        }
    }

    public void writeToFile(String line) {
        this.writer.writeLogEvent(line);
    }
}

