/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.core.manifest;

import com.sap.hdb.core.exceptions.HdbException;
import com.sap.hdb.core.manifest.HdbManifest;
import com.sap.hdb.core.manifest.HdbManifestClazz;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class HdbCoreManifest
implements HdbManifest {
    private Manifest manifest = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getAbsolutPathOfArchive() {
        File f;
        String s;
        String jarPath;
        File dir = null;
        String fullString = new HdbManifestClazz().getAbsolutePathToThisClazz();
        int mark = fullString.indexOf("!");
        String path = "";
        if (mark <= 0) throw new HdbException(fullString + " Cannot create directory from path. Not in Jar file!");
        path = jarPath = fullString.substring(0, mark);
        if ((path = path.replace("\\", "/")).startsWith(s = "jar:file:/")) {
            path = path.substring(s.length());
        }
        if (null == (dir = (f = new File(path)).getParentFile())) throw new HdbException(path + " cannot create File object from String!");
        if (dir.isDirectory()) return dir;
        throw new HdbException(dir + " is not a directory! Fullpath from class was: " + fullString);
    }

    public HdbCoreManifest() {
        Manifest manifest = null;
        if (null != this.manifest) {
            manifest = this.manifest;
        } else {
            String pathToThisClass = new HdbManifestClazz().getAbsolutePathToThisClazz();
            int mark = pathToThisClass.indexOf("!");
            if (mark > 0) {
                String pathToManifest = pathToThisClass.substring(0, mark + 1);
                pathToManifest = pathToManifest + "/META-INF/MANIFEST.MF";
                try {
                    manifest = new Manifest(new URL(pathToManifest).openStream());
                }
                catch (MalformedURLException e) {
                    throw new HdbException(e);
                }
                catch (IOException e) {
                    throw new HdbException(e);
                }
            } else {
                throw new HdbException("Error: I am not part of a jar file. Cannot determine version since there is no Manifest!");
            }
        }
        this.manifest = manifest;
    }

    public HdbCoreManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Manifest get() throws Exception {
        return this.manifest;
    }

    public void getAttributeValues() {
    }

    public boolean doesAttributeExist(String attributeName) {
        boolean exist = false;
        if (null != this.getValue(attributeName)) {
            exist = true;
        }
        return exist;
    }

    public String getAttributeValue(Attribute attributeName) {
        return this.getAttributeValue(attributeName.toString());
    }

    public String getAttributeValue(String attributeName) {
        String value = "";
        if (this.doesAttributeExist(attributeName)) {
            value = this.getValue(attributeName);
        }
        return value;
    }

    private String getValue(String attributeName) {
        String value = null;
        Attributes allAttributes = this.getAllAttributes();
        for (Map.Entry<Object, Object> attribute : allAttributes.entrySet()) {
            Attributes.Name attributekey = (Attributes.Name)attribute.getKey();
            String attributeValue = (String)attribute.getValue();
            if (!attributeName.equalsIgnoreCase(attributekey.toString())) continue;
            value = attributeValue;
            break;
        }
        return value;
    }

    private Attributes getAllAttributes() {
        Attributes allAttributes = new Attributes();
        Attributes mainAttributes = this.manifest.getMainAttributes();
        for (Map.Entry<Object, Object> mainAttribute : mainAttributes.entrySet()) {
            allAttributes.put(mainAttribute.getKey(), mainAttribute.getValue());
        }
        Map<String, Attributes> entries = this.manifest.getEntries();
        for (Map.Entry<String, Attributes> e : entries.entrySet()) {
            String key = e.getKey();
            Attributes attributes = e.getValue();
            for (Map.Entry<Object, Object> attribute : attributes.entrySet()) {
                Attributes.Name attributeKey = (Attributes.Name)attribute.getKey();
                String attributeValue = (String)attribute.getValue();
                allAttributes.put(attributeKey, attributeValue);
            }
        }
        return allAttributes;
    }

    public boolean doesHdbSectionExist() {
        boolean exists = false;
        Map<String, Attributes> entries = this.manifest.getEntries();
        for (Map.Entry<String, Attributes> e : entries.entrySet()) {
            String sectionName = e.getKey();
            if (!Section.COM_SAP_HDB_CORE.toString().equalsIgnoreCase(sectionName)) continue;
            exists = true;
        }
        return exists;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Section {
        COM_SAP_HDB_CORE;


        public String toString() {
            String rString = "";
            switch (this) {
                case COM_SAP_HDB_CORE: {
                    rString = "com.sap.hdb.core";
                    break;
                }
                default: {
                    rString = this.toString();
                }
            }
            return rString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        IMPLEMENTATION_TITLE,
        IMPLEMENATION_VENDOR_ID,
        IMPLEMENTATION_VERSION,
        CHANGELIST,
        API_VERSION,
        RELEASE;


        public String toString() {
            String rString = "";
            switch (this) {
                case IMPLEMENTATION_TITLE: {
                    rString = "Implementation-Title";
                    break;
                }
                case IMPLEMENATION_VENDOR_ID: {
                    rString = "Implementation-Vendor-Id";
                    break;
                }
                case IMPLEMENTATION_VERSION: {
                    rString = "Implementation-Version";
                    break;
                }
                case CHANGELIST: {
                    rString = "Changelist";
                    break;
                }
                case API_VERSION: {
                    rString = "API-Version";
                    break;
                }
                case RELEASE: {
                    rString = "release";
                    break;
                }
                default: {
                    rString = this.toString();
                }
            }
            return rString;
        }
    }
}

