/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.core.manifest;

import com.sap.hdb.core.manifest.HdbCoreManifest;
import com.sap.hdb.core.manifest.HdbManifest;

public class MainClass {
    private static void writeHelp() {
        System.out.println("usage: java -jar <Classpath e.g.: ./com.sap.hdb.core.jar> [<options>]");
        System.out.println("\t<options>:");
        System.out.println("\t\t-a Attribute from META-INF/MANIFEST.MF within jar file.");
        System.out.println("\t\t   Example: java -jar ./com.sap.hdb.core.jar -a API-Version");
    }

    public static void main(String[] args) throws Exception {
        MainClass mainClass = new MainClass();
        if (args.length == 0) {
            HdbCoreManifest hdbManifest = new HdbCoreManifest();
            mainClass.writeFullVersionToStdout(hdbManifest);
        } else if (args[0].equalsIgnoreCase("-h")) {
            MainClass.writeHelp();
        } else if (args[0].equalsIgnoreCase("-a") && args.length == 2) {
            String attributeName = args[1];
            HdbCoreManifest hdbManifest = new HdbCoreManifest();
            mainClass.writeAttributeToStdout(hdbManifest, attributeName);
        } else {
            MainClass.writeHelp();
        }
    }

    public void writeAttributeToStdout(HdbManifest hdbManifest, String attributeName) {
        String value = null;
        if (attributeName.endsWith(":")) {
            attributeName = attributeName.substring(0, attributeName.indexOf(":"));
        }
        value = hdbManifest.doesAttributeExist(attributeName) ? hdbManifest.getAttributeValue(attributeName) : "";
        System.out.println(attributeName + ": " + value);
    }

    public void writeFullVersionToStdout(HdbManifest hdbManifest) {
        HdbCoreManifest.Attribute[] attributes;
        HdbCoreManifest.Section coreSection = HdbCoreManifest.Section.COM_SAP_HDB_CORE;
        if (hdbManifest.doesHdbSectionExist()) {
            System.out.println("package: " + (Object)((Object)coreSection));
        } else {
            System.out.println((Object)((Object)coreSection) + " No such package found in Manifest!");
        }
        for (HdbCoreManifest.Attribute attribute : attributes = HdbCoreManifest.Attribute.values()) {
            String attributeName = attribute.toString();
            this.writeAttributeToStdout(hdbManifest, attributeName);
        }
    }
}

