-- com.sap.hdb.sl.lib.utils.scripts.create_S4_audit_policies.sql
-- Version 1.00 (05.03.2021) 
CREATE PROCEDURE S4HANA_CREATE_AUDIT_POLICIES()
LANGUAGE SQLSCRIPT
SQL SECURITY DEFINER
AS

   policycount INT := 1;
   has_privilege INT := 0;
   global_auditing_state INT := 0;

BEGIN

    select count (distinct audit_policy_name) into  policycount from  audit_policies;
    select count (distinct user_name) into has_privilege from PUBLIC.EFFECTIVE_privileges where user_name = (select session_user from dummy) and privilege = 'AUDIT ADMIN';
    select count(*) into global_auditing_state FROM PUBLIC.M_INIFILE_CONTENTS 
        WHERE FILE_NAME = 'global.ini' AND SECTION = 'auditing configuration' AND KEY = 'global_auditing_state' AND LAYER_NAME = 'SYSTEM' AND VALUE = 'true';

    IF (policycount = 0 AND has_privilege != 0) THEN

        EXEC 'CREATE AUDIT POLICY "_SAP_session connect"
          AUDITING UNSUCCESSFUL
            CONNECT
          LEVEL ALERT TRAIL TYPE TABLE RETENTION 20';
        EXEC 'ALTER AUDIT POLICY "_SAP_session connect" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_session validate"
          AUDITING ALL
            VALIDATE USER
          LEVEL ALERT TRAIL TYPE TABLE RETENTION 20';
        EXEC 'ALTER AUDIT POLICY "_SAP_session validate" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_authorizations"
          AUDITING ALL
            GRANT ANY,
            REVOKE ANY
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_authorizations" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_user administration"
          AUDITING SUCCESSFUL
              ALTER ROLE,
              ALTER USER,
              ALTER USERGROUP,
              CREATE ROLE,
              CREATE USER,
              CREATE USERGROUP,
              DROP ROLE,
              DROP USER,
              DROP USERGROUP
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_user administration" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_structured privileges"
          AUDITING SUCCESSFUL
              ALTER STRUCTURED PRIVILEGE,
              CREATE STRUCTURED PRIVILEGE,
              DROP STRUCTURED PRIVILEGE
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_structured privileges" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_certificates"
          AUDITING ALL
              ALTER PSE,
              CREATE CERTIFICATE,
              CREATE PSE,
              DROP CERTIFICATE,
              DROP PSE
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_certificates" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_authentication provider"
          AUDITING ALL
              ALTER JWT PROVIDER,
              ALTER LDAP PROVIDER,
              ALTER SAML PROVIDER,
              CREATE JWT PROVIDER,
              CREATE LDAP PROVIDER,
              CREATE SAML PROVIDER,
              DROP JWT PROVIDER,
              DROP LDAP PROVIDER,
              DROP SAML PROVIDER,
              VALIDATE LDAP PROVIDER
          LEVEL CRITICAL TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_authentication provider" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_clientside encryption"
          AUDITING ALL
              ALTER CLIENTSIDE ENCRYPTION COLUMN KEY,
              ALTER CLIENTSIDE ENCRYPTION KEYPAIR,
              CREATE CLIENTSIDE ENCRYPTION COLUMN KEY,
              CREATE CLIENTSIDE ENCRYPTION KEYPAIR,
              DROP CLIENTSIDE ENCRYPTION COLUMN KEY,
              DROP CLIENTSIDE ENCRYPTION KEYPAIR
          LEVEL CRITICAL TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_clientside encryption" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_designtime privileges"
          AUDITING SUCCESSFUL
            EXECUTE ON
              "_SYS_REPO"."GRANT_ACTIVATED_ANALYTICAL_PRIVILEGE",
              "_SYS_REPO"."GRANT_ACTIVATED_ROLE",
              "_SYS_REPO"."GRANT_APPLICATION_PRIVILEGE",
              "_SYS_REPO"."GRANT_PRIVILEGE_ON_ACTIVATED_CONTENT",
              "_SYS_REPO"."GRANT_SCHEMA_PRIVILEGE_ON_ACTIVATED_CONTENT",
              "_SYS_REPO"."REVOKE_ACTIVATED_ANALYTICAL_PRIVILEGE",
              "_SYS_REPO"."REVOKE_ACTIVATED_ROLE",
              "_SYS_REPO"."REVOKE_APPLICATION_PRIVILEGE",
              "_SYS_REPO"."REVOKE_PRIVILEGE_ON_ACTIVATED_CONTENT",
              "_SYS_REPO"."REVOKE_SCHEMA_PRIVILEGE_ON_ACTIVATED_CONTENT"
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_designtime privileges" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_configuration changes"
          AUDITING ALL
            STOP SERVICE,
            SYSTEM CONFIGURATION CHANGE
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_configuration changes" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_license addition"
            AUDITING ALL
                SET SYSTEM LICENSE
            LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_license addition" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_license deletion"
            AUDITING ALL
                UNSET SYSTEM LICENSE
            LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_license deletion" ENABLE';

        EXEC 'CREATE AUDIT POLICY "_SAP_recover database"
          AUDITING ALL
            BACKUP CATALOG DELETE,
              BACKUP DATA,
              RECOVER DATA
          LEVEL INFO TRAIL TYPE TABLE RETENTION 180';
        EXEC 'ALTER AUDIT POLICY "_SAP_recover database" ENABLE';

        IF (global_auditing_state = 0) THEN
            EXEC 'ALTER SYSTEM ALTER CONFIGURATION ('''||'global.ini'''||', '''||'system'''||')
                set ('''||'auditing configuration'''||', '''||'global_auditing_state'''||') = '''||'true'''||'  with reconfigure';
        END IF;
    END IF;
END;