/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

function trimString(string) {
    var ar = string.split(": ");
    var res = ar[1];
    res = res.replace(/[\n\r]+/g, '');
    return res;
};

function getVersionString(func) {
    $.ajax({
        type: "GET",
        url: "../summanifest.mf",
        dataType: "text",
        cache: false,
        success: $.proxy(function(mfcontent) {
            var st1 = "release: ";
            var st2 = "support package: ";
            var st3 = "patch number: ";
            var ar = mfcontent.split("\n");
            var version_string = "";
            for (i = 0; i < ar.length; i++) {
                if (ar[i].indexOf(st1) > -1) 		version_string += trimString(ar[i]);
                else if (ar[i].indexOf(st2) > -1) 	version_string += " SP" + trimString(ar[i]);
                else if (ar[i].indexOf(st3) > -1) 	version_string += " (PL" + trimString(ar[i]) + ")";
            }
            func(version_string);
        }, this),
        error: function(xhr, options, errorText) {
            sap.m.MessageBox.error("SUM Version Info: " + errorText);
            func("");
        }
    });
};

function pollChecksLog(fulltext) {
    if ((typeof oStub.oFather.oProcExe === 'undefined') || (oStub.oFather.oProcExe.globalPollingActive)) {
        $.ajax({
            type: "GET",
            url: "../manual_actions?xsl=0",
            dataType: "text",
            cache: false,
            success: $.proxy(function(xml) {
                var countInfo = 0;
                var countError = 0;
                if (!(this.oStub && this.oStub.oFather && this.oStub.oFather.oProcExe)) return;
                var oUIProcDel = this.oStub.oFather.oProcExe.oUIProc;
				// bad browsers don't support <xsl:text disable-output-escaping="yes">, so we need a stupid(!) workaround!!!
				// see https://bugzilla.mozilla.org/show_bug.cgi?id=98168 (never ending story...)
				if (navigator.userAgent.indexOf("Firefox") > -1) xml = xml.replace(/&lt;/g, "<![CDATA[&lt;]]>").replace(/&gt;/g, "<![CDATA[&gt;]]>");
                var adapter = oUIProcDel._getAdapter("/manual_actions");
                if (adapter && !oUIProcDel.rule) oUIProcDel.rule = oUIProcDel._loadAdapterRule(adapter.sRulePath);
                var tempDoc = oUIProcDel._applyAdapterRule(xml, oUIProcDel.rule);
                if (typeof tempDoc === "string") xml = tempDoc;
                else xml = new XMLSerializer().serializeToString(tempDoc);
                oModel.setXML(xml);
                oModel.refresh(true);
                var currentManualActionsJXML = $(tempDoc);
                var countInfo = currentManualActionsJXML.find("action>type:contains(Information)").length;
                var countWarning = currentManualActionsJXML.find("action>type:contains(Warning)").length;
                var countError = currentManualActionsJXML.find("action>type:contains(Error)").length;
                var toolPopup = this.oStub.oFather.getRootShell().getToolPopups()[0];
                var icon = "slui/resources/taskstate/empty.png";
                var toolTip = "";
                if (toolPopup) {
                    toolPopup.getContent()[0].setEnabled(true);
                    if (countError > 0) {
                        icon = "slui/resources/taskstate/error2.png";
                        toolTip = "There are unprocessed items";
                    }
                    else if (countWarning > 0) {
                        icon = "slui/resources/taskstate/warning2.png";
                        toolTip = "There are unprocessed items";
                    }
                    else if (countInfo > 0) {
                        icon = "slui/resources/taskstate/info2.png";
                        toolTip = "Information";
                    }
                    else {
                        toolPopup.getContent()[0].setEnabled(false);
                        fulltext = false;
                    }
                    toolPopup.setIcon(icon).setIconHover(icon).setTooltip(toolTip).setTitle(toolTip);
                }
                if (fulltext) $("[id$=notificationTool]").click();
            }, this),
            error: function (xhr, options, errorText)
            {
                //we just dont care
            }
        });
    }
};

function addMessageIcon() {
    var oControl = new sap.ui.commons.Button("cMessages", {text: "Click", height: "0px", width: "0px", press: function(oEvent) {
            oMessagePopover.openBy(oEvent.getSource());
        }});
    oStub.oFather.getRootShell().addToolPopup(new sap.ui.ux3.ToolPopup("notificationTool", {
        content: oControl,
        opened: function() {
            $("#cMessages").css("visibility", "hidden");
            if (oControl.getEnabled()) oControl.firePress();
            else this.close();
        }
    }));
};

function addBucketIcon() {
    var oControl = new sap.ui.commons.Button("cBuckets", {text: "Click", height: "0px", width: "0px", enabled: false, press: function(oEvent) {
            oStub.oFather.getRootShell().getToolPopups()[1].close();
            var sluiguiExt = window.open("../slui_ext/#buckets");
        }});
    oStub.oFather.getRootShell().addToolPopup(new sap.ui.ux3.ToolPopup("bucketTool", {
        content: oControl,
        opened: function() {
            $("#cBuckets").css("visibility", "hidden");
            if (oControl.getEnabled()) oControl.firePress();
            else this.close();
        }
    }));
};

function showBucketIcon(bStatus) {
    var toolPopup = oStub.oFather.getRootShell().getToolPopups()[1];
    if (!toolPopup) return;
    var icon = "slui/resources/taskstate/empty.png";
    var toolTip = "";
    toolPopup.getContent()[0].setEnabled(bStatus);
    if (bStatus) {
        icon = "slui/resources/taskstate/warning2.png";
        toolTip = "There are failed process buckets";
    }
    toolPopup.setIcon(icon).setIconHover(icon).setTooltip(toolTip).setTitle(toolTip);
};
