<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : manualactions.xsl
    Created on : 13. November 2015, 12:54
    Author     : d034742
    Description:
        Resource '/manual_actions?xsl=0' has a structure that is not compatible with the UI control
        MessagePopover. This transformation makes it possible.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template match="/">
        <Actions>
            <xsl:for-each select="//action">
                <xsl:variable name="mtype">
                    <xsl:choose>
                        <xsl:when test="@type='error'">
                            <xsl:text disable-output-escaping="yes">Error</xsl:text>
                        </xsl:when>                            
                        <xsl:when test="@type='warning'">
                            <xsl:text disable-output-escaping="yes">Warning</xsl:text>
                        </xsl:when>                            
                        <xsl:otherwise>
                            <xsl:text disable-output-escaping="yes">Information</xsl:text>
                        </xsl:otherwise>                        
                    </xsl:choose>
                </xsl:variable>
                <action>
                    <type>
                        <xsl:value-of select="$mtype"/>                       
                    </type>
                    <title>
                        <xsl:value-of select="@title" />                   
                        <xsl:if test="not(@title)">
                            <xsl:value-of select="$mtype"/> 
                        </xsl:if>                   
                    </title>
                    <description>
                        <xsl:text disable-output-escaping="yes">&#60;![CDATA[</xsl:text>
                        <xsl:text disable-output-escaping="yes">&#60;html&#62;&#60;head&#62;&#60;H4&#62;</xsl:text>  
                        <xsl:text disable-output-escaping="yes">SUM-Phase: </xsl:text>
                        <xsl:value-of select="@id" />
                        <xsl:text disable-output-escaping="yes">&#60;/H4&#62;&#60;/head&#62;&#60;body&#62;&#60;div class="popoverCont" style="padding-bottom: 20px"&#62;</xsl:text>  
                        <xsl:apply-templates select="html/body/*" />
                        <xsl:text disable-output-escaping="yes">&#60;/div&#62;&#60;/body&#62;&#60;/html&#62;</xsl:text>  
                        <xsl:text disable-output-escaping="yes">]]&#62;</xsl:text>
                    </description>
                </action>
            </xsl:for-each>   
        </Actions>
    </xsl:template>

    <xsl:template match="html//pre">
        <xsl:text disable-output-escaping="yes">&#60;code&#62;</xsl:text>
        <xsl:apply-templates select="node()"/>   
        <xsl:text disable-output-escaping="yes">&#60;/code&#62;&#60;br/&#62;</xsl:text>        
    </xsl:template>

    <xsl:template match="*">
        <xsl:text disable-output-escaping="yes">&#60;</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:apply-templates select="@*"/>
        <xsl:text disable-output-escaping="yes">&#62;</xsl:text>
        <xsl:apply-templates select="node()"/>   
        <xsl:text disable-output-escaping="yes">&#60;/</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:text disable-output-escaping="yes">&#62;</xsl:text>
    </xsl:template>

    <xsl:template match="@*">
        <xsl:text disable-output-escaping="yes">&#32;</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:text disable-output-escaping="yes">&#61;&#34;</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text disable-output-escaping="yes">&#34;</xsl:text>
    </xsl:template>

    <xsl:template match="text()">
        <xsl:value-of select="."/>
    </xsl:template>
	
</xsl:stylesheet>
