<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<dialogs>
			<xsl:for-each select="metadialog">
				<Dialog display="true">
					<id>
						<xsl:value-of select="@id" />
					</id>
					<db>
						<xsl:value-of select="doc/@db" />
					</db>
					<opt>
						<xsl:value-of select="doc/@opt" />
					</opt>
					<loio>
						<xsl:value-of select="doc/@loio" />
					</loio>
					<aboutDialogHelp />
					<metadaInformation />
					<dialogHeader>
						<xsl:if test="content/header/title">
							<caption>
								<xsl:value-of select="content/header/title" />
							</caption>
						</xsl:if>
						<xsl:if test="content/header/longdescr">
							<longDescription>
								<xsl:value-of select="content/header/longdescr" />
							</longDescription>
						</xsl:if>
					</dialogHeader>
					<dialogBody>
						<xsl:call-template name="transformGroup">
							<xsl:with-param name="element" select="content/group" />
							<xsl:with-param name="parentId" select="@id" />
						</xsl:call-template>
					</dialogBody>
				</Dialog>
			</xsl:for-each>
		</dialogs>
	</xsl:template>

	<xsl:template name="transformElements">
		<xsl:param name="element" />
		<xsl:param name="parentId" />
		<xsl:for-each select="$element/child::node()">
			<xsl:choose>
				<!-- transform group element -->
				<xsl:when test="name() = 'group' ">
					<xsl:call-template name="transformGroup">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="parentId" select="$element/@id" />
					</xsl:call-template>
				</xsl:when>
				<!-- transform text element -->
				<xsl:when test="name() = 'text' ">
					<xsl:call-template name="transformText">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="parentId" select="$element/@id" />
					</xsl:call-template>
				</xsl:when>
				<!-- transform input element -->
				<xsl:when test="name() = 'input' ">
					<xsl:choose>
						<!-- multistring -->
						<xsl:when test="./multistring">
							<!-- not used in sum4abap -->
						</xsl:when>
						<!-- multipath -->
						<xsl:when test="./multipath">
							<!-- not used in sum4abap -->
						</xsl:when>
						<!-- multinumeric -->
						<xsl:when test="./multinumeric">
							<!-- not used in sum4abap -->
						</xsl:when>
						<!-- other input (password, string, numeric, path) -->
						<xsl:otherwise>
							<xsl:call-template name="transformInput">
								<xsl:with-param name="element" select="." />
								<xsl:with-param name="parentId" select="$element/@id" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- transform choice element -->
				<xsl:when test="name() = 'choice' ">
					<xsl:if test="./multichoice">
						<xsl:call-template name="transformMultichoice">
							<xsl:with-param name="element" select="./multichoice" />
							<xsl:with-param name="choice" select="." />
							<xsl:with-param name="parentId" select="$element/@id" />
						</xsl:call-template>
						<xsl:variable name="countItems">
							<xsl:value-of select="count(./multichoice/item)" />
                        </xsl:variable>
                        <xsl:for-each select="./multichoice/item">
							<!-- add dynamically showing/hiding group -->
							<xsl:for-each select="./enables">
								<xsl:choose>
									<xsl:when test="$countItems = 1">
										<xsl:call-template name="transformGroup">
										<xsl:with-param name="element" select="./group" />
										<xsl:with-param name="parentId" select="$element/@id" />
										<xsl:with-param name="visible" select="true()"></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="transformGroup">
										<xsl:with-param name="element" select="./group" />
										<xsl:with-param name="parentId" select="$element/@id" />
										<xsl:with-param name="visible" select="false()"></xsl:with-param>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
							<xsl:for-each select="./disables">
								<xsl:choose>
									<xsl:when test="$countItems = 1">
										<xsl:call-template name="transformGroup">
										<xsl:with-param name="element" select="./group" />
										<xsl:with-param name="parentId" select="$element/@id" />
										<xsl:with-param name="visible" select="false()"></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="transformGroup">
										<xsl:with-param name="element" select="./group" />
										<xsl:with-param name="parentId" select="$element/@id" />
										<xsl:with-param name="visible" select="true()"></xsl:with-param>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
                        </xsl:for-each>
					</xsl:if>
					<xsl:if test="./singlechoice">
						<xsl:call-template name="transformSinglechoice">
							<xsl:with-param name="element" select="./singlechoice" />
							<xsl:with-param name="choice" select="." />
							<xsl:with-param name="parentId" select="$element/@id" />
						</xsl:call-template>
						<!-- add dynamically showing/hiding group -->
						<xsl:if test="./singlechoice/enables">
							<xsl:call-template name="transformGroup">
								<xsl:with-param name="element"
									select="./singlechoice/enables/group" />
								<xsl:with-param name="parentId" select="$element/@id" />
								<xsl:with-param name="visible" select="false()"></xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="./singlechoice/disables">
							<xsl:call-template name="transformGroup">
								<xsl:with-param name="element"
									select="./singlechoice/disables/group" />
								<xsl:with-param name="parentId" select="$element/@id" />
							</xsl:call-template>
						</xsl:if>
					</xsl:if>
				</xsl:when>
				<!-- transform table element -->
				<xsl:when test="name() = 'table' ">
					<xsl:call-template name="transformTable">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="parentId" select="$element/@id" />
					</xsl:call-template>
				</xsl:when>
				<!-- transform output element -->
				<xsl:when test="name() = 'output' ">
					<!-- not used in sum4abap -->
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="transformGroup">
		<xsl:param name="element" />
		<xsl:param name="parentId" />
		<xsl:param name="visible" select="true()" />
		<groupView id="{$element/@id}" parentId="{$parentId}"
			visible="{$visible}">
			<xsl:if test="$element/caption">
				<groupCaption>
					<xsl:value-of select="$element/caption" />
				</groupCaption>
			</xsl:if>
			<children>
				<xsl:call-template name="transformElements">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="parentId" select="$element/@id" />
				</xsl:call-template>
			</children>
		</groupView>
	</xsl:template>

	<xsl:template name="transformText">
		<xsl:param name="element" />
		<xsl:param name="parentId" />
		<textView parentId="{$parentId}">
			<xsl:choose>
				<xsl:when test="$element/@id">
					<xsl:attribute name="id">
						<xsl:value-of select="$element/@id" />
		    		</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$element/html">
					<xsl:attribute name="htmlEnabled">
						<xsl:value-of select="true()" />
		    		</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<value>
				<xsl:copy-of select="$element/child::node()" />
			</value>
		</textView>
	</xsl:template>

	<xsl:template name="transformMultichoice">
		<xsl:param name="element" />
		<xsl:param name="choice" />
		<xsl:param name="parentId" />
		<valueSelectorGroupView id="{$choice/@id}"
			parentId="{$parentId}" childType="radioButton" selectionType="singleSelection">
			<xsl:if test="$choice/caption">
				<caption>
					<xsl:value-of select="$choice/caption" />
				</caption>
			</xsl:if>
			<selectorValueProvider>
				<xsl:for-each select="$element/item">
					<xsl:variable name="i" select="position()" />
					<instanceValueProvider id="{concat($i, $choice/@id)}"
						parentId="{$choice/@id}">
						<xsl:choose>
							<xsl:when test="@selected">
								<xsl:attribute name="selected">
									<xsl:value-of select="@selected" />
					    		</xsl:attribute>
							</xsl:when>
						</xsl:choose>
						<value>
							<xsl:value-of select="@id" />
						</value>
						<caption>
							<xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
							<xsl:apply-templates select="./stringvalue" />
							<xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
						</caption>
					</instanceValueProvider>
				</xsl:for-each>
			</selectorValueProvider>
			<clientEventReference>
				<xsl:for-each select="$element/item">
					<xsl:variable name="currentId" select="@id"/>
					<xsl:for-each select="$element/item/enables">
						<xsl:variable name="groupsToDisable">
							<xsl:choose>
								<xsl:when test="not(../@id = $currentId)">true</xsl:when>
								<xsl:otherwise>false</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="$groupsToDisable = 'true'">
							<eventReference roundTrip="false">
								<eventType>onSelect</eventType>
								<stateValue><xsl:value-of select="$currentId"/></stateValue>
								<reference>
									<refParamIds>
									<id><xsl:value-of select="./group/@id"></xsl:value-of></id>
									</refParamIds>
									<refProperty>visible</refProperty>
									<refValue>false</refValue>
								</reference>
							</eventReference>
						</xsl:if>
						<xsl:if test="$groupsToDisable = 'false'">
							<eventReference roundTrip="false">
								<eventType>onSelect</eventType>
								<stateValue><xsl:value-of select="$currentId"/></stateValue>
								<reference>
									<refParamIds>
									<id><xsl:value-of select="./group/@id"></xsl:value-of></id>
									</refParamIds>
									<refProperty>visible</refProperty>
									<refValue>true</refValue>
								</reference>
							</eventReference>
						</xsl:if>
					</xsl:for-each>
					<xsl:for-each select="$element/item/disables">
						<xsl:variable name="groupsToEnable">
							<xsl:choose>
								<xsl:when test="not(../@id = $currentId)">true</xsl:when>
								<xsl:otherwise>false</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="$groupsToEnable = 'true'">
							<eventReference roundTrip="false">
								<eventType>onSelect</eventType>
								<stateValue><xsl:value-of select="$currentId"/></stateValue>
								<reference>
									<refParamIds>
									<id><xsl:value-of select="./group/@id"></xsl:value-of></id>
									</refParamIds>
									<refProperty>visible</refProperty>
									<refValue>true</refValue>
								</reference>
							</eventReference>
						</xsl:if>
						<xsl:if test="$groupsToEnable = 'false'">
							<eventReference roundTrip="false">
								<eventType>onSelect</eventType>
								<stateValue><xsl:value-of select="$currentId"/></stateValue>
								<reference>
									<refParamIds>
									<id><xsl:value-of select="./group/@id"></xsl:value-of></id>
									</refParamIds>
									<refProperty>visible</refProperty>
									<refValue>false</refValue>
								</reference>
							</eventReference>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</clientEventReference>
		</valueSelectorGroupView>
	</xsl:template>

	<xsl:template name="transformSinglechoice">
		<xsl:param name="element" />
		<xsl:param name="choice" />
		<xsl:param name="parentId" />
		<valueSelectorGroupView id="{$choice/@id}"
			parentId="{$parentId}" childType="checkBox" selectionType="multiSelection">
			<selectorValueProvider>
				<instanceValueProvider id="{concat('1', $choice/@id)}"
					parentId="{$choice/@id}">
					<xsl:choose>
						<xsl:when test="$element/@selected">
							<xsl:attribute name="selected">
								<xsl:value-of select="$element/@selected" />
				    		</xsl:attribute>
						</xsl:when>
					</xsl:choose>
					<value>
						<xsl:value-of select="$choice/@id"></xsl:value-of>
					</value>
					<xsl:if test="$choice/caption">
						<caption>
							<xsl:value-of select="$choice/caption" />
						</caption>
					</xsl:if>
				</instanceValueProvider>
			</selectorValueProvider>
			<clientEventReference>
				<xsl:if test="$element/enables">
					<eventReference roundTrip="false">
						<eventType>onChange</eventType>
						<stateValue>true</stateValue>
						<reference>
							<refParamIds>
								<id>
									<xsl:value-of select="$element/enables/group/@id"></xsl:value-of>
								</id>
							</refParamIds>
							<refProperty>visible</refProperty>
							<refValue>true</refValue>
						</reference>
					</eventReference>
					<eventReference roundTrip="false">
						<eventType>onChange</eventType>
						<stateValue>false</stateValue>
						<reference>
							<refParamIds>
								<id>
									<xsl:value-of select="$element/enables/group/@id"></xsl:value-of>
								</id>
							</refParamIds>
							<refProperty>visible</refProperty>
							<refValue>false</refValue>
						</reference>
					</eventReference>
				</xsl:if>
				<xsl:if test="$element/disables">
					<eventReference roundTrip="false">
						<eventType>onChange</eventType>
						<stateValue>true</stateValue>
						<reference>
							<refParamIds>
								<id>
									<xsl:value-of select="$element/disables/group/@id"></xsl:value-of>
								</id>
							</refParamIds>
							<refProperty>visible</refProperty>
							<refValue>false</refValue>
						</reference>
					</eventReference>
					<eventReference roundTrip="false">
						<eventType>onChange</eventType>
						<stateValue>false</stateValue>
						<reference>
							<refParamIds>
								<id>
									<xsl:value-of select="$element/disables/group/@id"></xsl:value-of>
								</id>
							</refParamIds>
							<refProperty>visible</refProperty>
							<refValue>true</refValue>
						</reference>
					</eventReference>
				</xsl:if>
			</clientEventReference>
		</valueSelectorGroupView>
	</xsl:template>

	<xsl:template name="transformInput">
		<xsl:param name="element" />
		<xsl:param name="parentId" />
		<textInputView id="{$element/@id}" parentId="{$parentId}">
			<!-- CHANGED, not needed anymore? input elements have an other id from the remotecontrol -->
			<!-- 
			<xsl:if test="$element/remotecontrol ">
				<xsl:attribute name="id">
	      			<xsl:value-of select="$element/remotecontrol/@id" />
	      				<xsl:if test="$element/remotecontrol/@arg">_<xsl:value-of
					select="$element/remotecontrol/@arg" /></xsl:if>
	    		</xsl:attribute>
			</xsl:if>
			-->
			<!-- add required attribute -->
			<xsl:choose>
				<xsl:when test="$element/@required">
			    	<xsl:attribute name="required">
			        	<xsl:value-of select="$element/@required" />
			        </xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="required">
			        	<xsl:value-of select="true()" />
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<!-- add type attribute -->
			<xsl:choose>
				<xsl:when test="$element/numeric">
					<xsl:attribute name="type">
						<xsl:value-of select="'numberInput'" />
		    		</xsl:attribute>
				</xsl:when>
				<xsl:when test="$element/password">
					<xsl:if test="$element/password/@type='create'">
						<xsl:attribute name="type">
							<xsl:value-of select="'confirmInput'" />
						</xsl:attribute>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$element/path">
					<xsl:if test="$element/path/@type='file'">
						<xsl:attribute name="type">
							<xsl:value-of select="'fileInput'" />
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="$element/path/@type='dir'">
						<xsl:attribute name="type">
							<xsl:value-of select="'directoryInput'" />
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="$element/path/@bwslash">
						<xsl:attribute name="bwslash">
		      				<xsl:value-of select="$element/path/@bwslash" />
		    			</xsl:attribute>
					</xsl:if>
					<xsl:if test="$element/path/@endswith">
						<xsl:attribute name="endswith">
		      				<xsl:value-of select="$element/path/@endswith" />
		    			</xsl:attribute>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="type">
						<xsl:value-of select="'standardInput'" />
		    		</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<!-- add secure attribute -->
			<xsl:choose>
				<xsl:when test="$element/password">
					<xsl:attribute name="secure">
		      			<xsl:value-of select="true()" />
		    		</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<!-- add minValue attribute -->
			<xsl:if test="$element/numeric/@min">
				<xsl:attribute name="minValue">
	      			<xsl:value-of select="$element/numeric/@min" />
	    		</xsl:attribute>
			</xsl:if>
			<!-- add maxValue attribute -->
			<xsl:if test="$element/numeric/@max">
				<xsl:attribute name="maxValue">
	      			<xsl:value-of select="$element/numeric/@max" />
	    		</xsl:attribute>
			</xsl:if>
			<!-- add minCharLength attribute -->
			<xsl:if test="$element/*[2]/@minlength">
				<xsl:attribute name="minCharLength">
	      			<xsl:value-of select="$element/*[2]/@minlength" />
	    		</xsl:attribute>
			</xsl:if>
			<!-- add maxCharLength attribute -->
			<xsl:if test="$element/*[2]/@maxlength">
				<xsl:attribute name="maxCharLength">
	      			<xsl:value-of select="$element/*[2]/@maxlength" />
	    		</xsl:attribute>
			</xsl:if>
			<!-- add stringCase attribute -->
			<xsl:if test="$element/*[2]/@uppercase = 'true'">
				<xsl:attribute name="stringCase">
	      			<xsl:value-of select="'upper'" />
	    		</xsl:attribute>
			</xsl:if>
			<!-- add caption element -->
			<xsl:if test="$element/caption">
				<caption>
					<xsl:value-of select="$element/caption" />
				</caption>
			</xsl:if>
			<!-- add value element -->
			<value>
				<xsl:choose>
					<xsl:when test="$element/password">
						<xsl:value-of select="$element/password/passvalue" />
					</xsl:when>
					<xsl:when test="$element/string">
						<xsl:value-of select="$element/string/stringvalue" />
					</xsl:when>
					<xsl:when test="$element/numeric">
						<xsl:value-of select="$element/numeric/numericvalue" />
					</xsl:when>
					<xsl:when test="$element/path">
						<xsl:value-of select="$element/path/pathvalue" />
					</xsl:when>
				</xsl:choose>
			</value>
		</textInputView>
	</xsl:template>

	<xsl:template name="transformTable">
		<xsl:param name="element" />
		<xsl:param name="parentId" />
		<tableView id="{$element/@id}" parentId="{$parentId}"
			rowBinding="table">
			<xsl:if test="$element/@dynamic">
				<xsl:attribute name="dynamic">
					<xsl:value-of select="'addAndRemove'" />
	    		</xsl:attribute>
			</xsl:if>
			<xsl:if test="$element/@export">
				<xsl:attribute name="export">
					<xsl:value-of select="'true'" />
	    		</xsl:attribute>
			</xsl:if>
			<xsl:if test="$element/column/choicecell">
				<xsl:attribute name="selectionType">
					<xsl:value-of select="'multiSelection'" />
	    		</xsl:attribute>
			</xsl:if>			
			<!-- columns -->
			<tableColumns>
				<xsl:for-each select="$element/column">
					<xsl:choose>
						<xsl:when test="./choicecell"></xsl:when>
						<xsl:otherwise>
						<tableColumnView id="{@id}" parentId="{$element/@id}">
							<!-- add renderType attribute -->
							<xsl:choose>
								<xsl:when test="./outputcell">
									<xsl:attribute name="renderType">
										<xsl:value-of select="'textView'" />
					    			</xsl:attribute>
								</xsl:when>
								<xsl:when test="./inputcell">
									<xsl:attribute name="renderType">
										<xsl:choose>
											<xsl:when test="./inputcell/password">
												<xsl:value-of select="'secureInput'" />
											</xsl:when>
											<xsl:when test="./inputcell/path">

												<xsl:if test="./inputcell/path/@type='file'">
													<xsl:value-of select="'fileInput'" />
												</xsl:if>
												<xsl:if test="./inputcell/path/@type='dir'">
													<xsl:value-of select="'directoryInput'" />
												</xsl:if>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="'textInput'" />
											</xsl:otherwise>
										</xsl:choose>
						    		</xsl:attribute>
									<xsl:if test="./inputcell/path/@bwslash">
										<xsl:attribute name="bwslash">
											<xsl:value-of select="./inputcell/path/@bwslash" />
										</xsl:attribute>
									</xsl:if>
									<xsl:if test="./inputcell/path/@endswith">
										<xsl:attribute name="endswith">
											<xsl:value-of select="./inputcell/path/@endswith" />
										</xsl:attribute>
									</xsl:if>
								</xsl:when>
<!--								<xsl:when test="./choicecell">
									<xsl:attribute name="renderType">
										<xsl:value-of select="'checkBox'" />
						    		</xsl:attribute>
								</xsl:when>    -->
							</xsl:choose>
							<!-- add caption element -->
							<xsl:if test="./caption">
								<caption>
									<xsl:value-of select="./caption" />
								</caption>
							</xsl:if>
							<dataBinding>
								<xsl:value-of select="@id" />
							</dataBinding>
						</tableColumnView>
						</xsl:otherwise>
					</xsl:choose>			
				</xsl:for-each>
			</tableColumns>
			<!-- values -->
			<tableValueProvider>
			  <tableOverview>
				<xsl:for-each select="$element/row">
			      <table>
				    <xsl:for-each select="./*">
                      <xsl:variable name="current" select="current()" />
                      <xsl:variable name="i" select="position()" />
                      <xsl:element name="{$element/column[$i]/@id}">
                        <xsl:value-of select="$current" />
                      </xsl:element>
				    </xsl:for-each>
			      </table>
			    </xsl:for-each>
			  </tableOverview>
			</tableValueProvider>
		</tableView>
	</xsl:template>
</xsl:stylesheet>