jQuery.sap.declare("com.sap.lm.sl.ui.sluiCore");
jQuery.sap.require("jquery.sap.resources");
jQuery.sap.require("sap.ui.core.IconPool");
var sLocale = sap.ui.getCore().getConfiguration().getLanguage();
var oBundle = jQuery.sap.resources({url: "slui/resources/uitext/slui.properties", locale: sLocale});
var functionsBeforeRendering = [];
var functionsAfterRendering = [];
var functionsBeforeDialogRendering = [];
var functionsAfterDialogRendering = [];
var dualStackResetInProgress = false;
var sluiCore = {
    inDebug: false,
    properties: {
    	suiLogo: true,
    	suiName: true,
    	suiMode: "",
    },
    mod: {
        jsclient: "slui.client.SLUIClient",
        jshmevw: "slui.client.HomeScreenview",
        jscntrl: "slui.client.HomeScreencontroller",
        jscnst: "slui.modules.constants.Constant",
        jsutil: "slui.modules.utility.Utility",
        jsshell: "slui.modules.renderers.Clientshell",
//        jsappInfo: "slui.modules.renderers.ApplicationInfo",
        jsexeInfo: "slui.modules.renderers.ProcessExecutionInfo",
        jsexeStat: "slui.modules.renderers.ProcessExecutionStatus",
        jsexeWizd: "slui.modules.renderers.ProcessExecutionWizard",
        jsexeCntrl: "slui.modules.renderers.ProcesExecutionControl",
        jsstepLst: "slui.modules.renderers.ProcessExecutionStepList",
        jslogs: "slui.modules.renderers.Logs",
        jsbrkpnts: "slui.modules.renderes.Breakpoints",
        jsprocLst: "slui.modules.renderers.ProcessCollectionList",
        jsproTLst: "slui.modules.renderers.ProcessCollectionTreeList",
        jsproSng: "slui.modules.renderers.SingleProcess",
        jshelp: "slui.modules.renderers.Help",
        jsrendr: "slui.modules.renderers.SimpleUIRenderers",
        jscomm: "slui.modules.communicator.ServiceCommunicator",
        jsrepo: "slui.modules.manager.ProcessRepository",
        jsexe: "slui.modules.manager.ProcessExecutor",
        jstask: "slui.modules.model.protocolModel.Task",
        jsproc: "slui.modules.model.uiModel.Process",
        jsprocDef: "slui.modules.model.protocolModel.ProcessDefinition",
        jsbaseMod: "slui.modules.model.protocolModel.BaseModel",
        jsdiaHdr: "slui.modules.model.protocolModel.DialogHeader",
        jsdiaBdy: "slui.modules.model.protocolModel.DialogBody",
        jscnfPrm: "slui.modules.model.protocolModel.ConfigParameter",
        jsdia: "slui.modules.model.protocolModel.Dialog",
        jserr: "slui.modules.model.protocolModel.Error",
        jsact: "slui.modules.model.protocolModel.Action",
        jsdiaProv: "slui.modules.renderers.DialogProvider",
        jsbrowse: "slui.modules.renderers.FileBrowser",
        jslogtail: "slui.modules.renderers.LogTail"
    },
    
    blacklistedXSS: function() {
    	var host = $(location).attr('host');
    	var href = $(location).attr('href');
    	var str = href.slice(href.search(host)+host.length);
    	return Boolean(str.match(/(javascript|src|onerror|%|<|>)/g));    	
    },
    
    whitelistedXSS: function() {
    	return Boolean($(location).attr('href').match(/\/lmsl\/sumabap\/([A-Z]|[a-z]|[0-9]){3}(([A-Z]|[a-z]|[0-9])?){5}(\/doc)?\/sluigui((\/\?)|(\/?$))/g));
    },
    
    getSLUIContextPath: function() {
//    	var xss = $(location).attr('href').match(/(javascript|src|onerror|%|<|>)/g);
//      var whitelistXSS = $(location).attr('href').match(/\/lmsl\/sumabap\/([A-Z]|[a-z]|[0-9]){3}(([A-Z]|[a-z]|[0-9])?){5}(\/doc)?\/sluigui((\/\?)|(\/?$))/g);
    	if (this.blacklistedXSS() || !this.whitelistedXSS()) throw "@ERROR: Not a valid URL!";
    	else {
            var returnPath = $(location).attr('href');
            if (returnPath) returnPath = returnPath.split("?")[0];
            if (returnPath.indexOf("slp.html") > -1) returnPath = returnPath.replace("slp.html", "");
            if (returnPath.indexOf("index.html") > -1) returnPath = returnPath.replace("index.html", "");
            if (returnPath.indexOf("dual.html") > -1) returnPath = returnPath.replace("dual.html", "");
            return returnPath;
    	}
    },
    
    getSLUICss: function() {
        $("<link/>", {
            rel: 	"stylesheet",
            type: 	"text/css",
            href: 	this.getSLUIContextPath() + "slui/resources/css/slui.css"
        }).appendTo("head");
    },

    prepareModulePath: function() {
//    	var xss = $(location).attr('href').match(/(javascript|src|onerror|%|<|>)/g);
//    	var whitelistXSS = $(location).attr('href').match(/\/lmsl\/sumabap\/([A-Z]|[a-z]|[0-9]){3}(([A-Z]|[a-z]|[0-9])?){5}(\/doc)?\/sluigui((\/\?)|(\/?$))/g);
    	if (this.blacklistedXSS() || !this.whitelistedXSS()) throw "@ERROR : Not a valid URL!";
    	else {
    		var returnPath = $(location).attr('href');
	        if (returnPath) {
//	            if (returnPath.indexOf("suihcb=true") > -1) sap.ui.getCore().applyTheme("sap_hcb");
	            if (returnPath.indexOf("suilogo=false") > -1) this.properties.suiLogo = false;
	            if (returnPath.indexOf("suiname=false") > -1) this.properties.suiName = false;
	            if (returnPath.indexOf("suidebug=true") > -1) this.inDebug = true;
	            else this.inDebug = false;
                this.registerAllModulePaths();
	        } 
	        else throw Error("SL UI Error : Unable to prepare modules path.");
    	}
    },
    
    registerAllModulePaths: function() {
        var sCnTxtPath = this.getSLUIContextPath();
        sCnTxtPath = sCnTxtPath + "slui/debug/";
        this.registerAllModulePathsExec(sCnTxtPath);
        this.loadAllModulePaths();        
    },
    
    registerAllModulePathsExec: function(sCnTxtPath) {
        jQuery.sap.registerModulePath(this.mod.jsclient, sCnTxtPath + "client/SLUIClient");
        jQuery.sap.registerModulePath(this.mod.jshmevw, sCnTxtPath + "client/HomeScreen.view");
        jQuery.sap.registerModulePath(this.mod.jscntrl, sCnTxtPath + "client/HomeScreen.controller");
        jQuery.sap.registerModulePath(this.mod.jscnst, sCnTxtPath + "modules/constants/Constant");
        jQuery.sap.registerModulePath(this.mod.jsutil, sCnTxtPath + "modules/utility/Utility");
        
        jQuery.sap.registerModulePath(this.mod.jsshell, sCnTxtPath + "modules/renderers/Clientshell.view");
//        jQuery.sap.registerModulePath(this.mod.jsappInfo, sCnTxtPath + "modules/renderers/ApplicationInfo.view");
        jQuery.sap.registerModulePath(this.mod.jsexeInfo, sCnTxtPath + "modules/renderers/ProcessExecutionInfo.view");
        jQuery.sap.registerModulePath(this.mod.jsexeStat, sCnTxtPath + "modules/renderers/ProcessExecutionStatus.view");
        jQuery.sap.registerModulePath(this.mod.jsexeWizd, sCnTxtPath + "modules/renderers/ProcessExecutionWizard.view");
        jQuery.sap.registerModulePath(this.mod.jsexeCntrl, sCnTxtPath + "modules/renderers/ProcesExecutionControl.view");
        jQuery.sap.registerModulePath(this.mod.jsstepLst, sCnTxtPath + "modules/renderers/ProcessExecutionStepList.view");
        jQuery.sap.registerModulePath(this.mod.jslogs, sCnTxtPath + "modules/renderers/Logs.view");
        jQuery.sap.registerModulePath(this.mod.jsbrkpnts, sCnTxtPath + "modules/renderers/Breakpoints");
        jQuery.sap.registerModulePath(this.mod.jsprocLst, sCnTxtPath + "modules/renderers/ProcessCollectionList.view");
        jQuery.sap.registerModulePath(this.mod.jsproTLst, sCnTxtPath + "modules/renderers/ProcessCollectionTreeList.view");
        jQuery.sap.registerModulePath(this.mod.jsproSng, sCnTxtPath + "modules/renderers/SingleProcess.view");
        jQuery.sap.registerModulePath(this.mod.jshelp, sCnTxtPath + "modules/renderers/Help.view");
        jQuery.sap.registerModulePath(this.mod.jsrendr, sCnTxtPath + "modules/renderers/SimpleUIRenderers");
        jQuery.sap.registerModulePath(this.mod.jscomm, sCnTxtPath + "modules/communicator/ServiceCommunicator");
        jQuery.sap.registerModulePath(this.mod.jsrepo, sCnTxtPath + "modules/manager/ProcessRepository");
        jQuery.sap.registerModulePath(this.mod.jsexe, sCnTxtPath + "modules/manager/ProcessExecutor");
        jQuery.sap.registerModulePath(this.mod.jstask, sCnTxtPath + "modules/model/protocolModel/Task");
        jQuery.sap.registerModulePath(this.mod.jsproc, sCnTxtPath + "modules/model/uiModel/Process");
        jQuery.sap.registerModulePath(this.mod.jsprocDef, sCnTxtPath + "modules/model/protocolModel/ProcessDefinition");
        jQuery.sap.registerModulePath(this.mod.jsbaseMod, sCnTxtPath + "modules/model/protocolModel/BaseModel");
        jQuery.sap.registerModulePath(this.mod.jsdiaHdr, sCnTxtPath + "modules/model/protocolModel/DialogHeader");
        jQuery.sap.registerModulePath(this.mod.jsdiaBdy, sCnTxtPath + "modules/model/protocolModel/DialogBody");
        jQuery.sap.registerModulePath(this.mod.jscnfPrm, sCnTxtPath + "modules/model/protocolModel/ConfigParameter");
        jQuery.sap.registerModulePath(this.mod.jsdia, sCnTxtPath + "modules/model/protocolModel/Dialog");
        jQuery.sap.registerModulePath(this.mod.jserr, sCnTxtPath + "modules/model/protocolModel/Error");
        jQuery.sap.registerModulePath(this.mod.jsact, sCnTxtPath + "modules/model/protocolModel/Action");
        jQuery.sap.registerModulePath(this.mod.jsdiaProv, sCnTxtPath + "modules/renderers/DialogProvider");
        jQuery.sap.registerModulePath(this.mod.jsbrowse, sCnTxtPath + "modules/renderers/FileBrowser");
        jQuery.sap.registerModulePath(this.mod.jslogtail, sCnTxtPath + "modules/renderers/LogTail");
        jQuery.sap.registerModulePath("support.modules", sCnTxtPath + "support/modules/");
    },
    
    loadAllModulePaths: function() {
        jQuery.sap.require(this.mod.jsclient);
        jQuery.sap.require(this.mod.jshmevw);
        jQuery.sap.require(this.mod.jscntrl);
        jQuery.sap.require(this.mod.jscnst);
        jQuery.sap.require(this.mod.jsutil);
        jQuery.sap.require(this.mod.jsshell);
//        jQuery.sap.require(this.mod.jsappInfo);
        jQuery.sap.require(this.mod.jsexeInfo);
        jQuery.sap.require(this.mod.jsexeStat);
        jQuery.sap.require(this.mod.jsexeWizd);
        jQuery.sap.require(this.mod.jsexeCntrl);
        jQuery.sap.require(this.mod.jsstepLst);
        jQuery.sap.require(this.mod.jslogs);
        jQuery.sap.require(this.mod.jsprocLst);
        jQuery.sap.require(this.mod.jsproTLst);
        jQuery.sap.require(this.mod.jsproSng);
        jQuery.sap.require(this.mod.jshelp);
        jQuery.sap.require(this.mod.jsrendr);
        jQuery.sap.require(this.mod.jscomm);
        jQuery.sap.require(this.mod.jsrepo);
        jQuery.sap.require(this.mod.jsexe);
        jQuery.sap.require(this.mod.jstask);
        jQuery.sap.require(this.mod.jsproc);
        jQuery.sap.require(this.mod.jsprocDef);
        jQuery.sap.require(this.mod.jsbaseMod);
        jQuery.sap.require(this.mod.jsdiaHdr);
        jQuery.sap.require(this.mod.jsdiaBdy);
        jQuery.sap.require(this.mod.jscnfPrm);
        jQuery.sap.require(this.mod.jsdia);
        jQuery.sap.require(this.mod.jserr);
        jQuery.sap.require(this.mod.jsact);
        jQuery.sap.require(this.mod.jsdiaProv);
        jQuery.sap.require(this.mod.jslogtail);
        jQuery.sap.require(this.mod.jsbrowse);
        jQuery.sap.require("sap.ui.core.BusyIndicator");
        jQuery.sap.require("support.modules.renderers.SupportMenus");
    },
    
    registerAllModulePathsForProductive: function(sCnTxtPath) {  
        //TODO: check if running this function would be sufficient compared to running registerAllModulePathsExec
        //TODO: if not needed to be deleted
        // register client.
        jQuery.sap.registerModulePath(this.mod.jsclient, sCnTxtPath + "client/SLUIClient");
        jQuery.sap.registerModulePath(this.mod.jshmevw, sCnTxtPath + "client/HomeScreen.view");
        jQuery.sap.registerModulePath(this.mod.jscntrl, sCnTxtPath + "client/HomeScreen.controller");
        jQuery.sap.registerModulePath(this.mod.jsshell, sCnTxtPath + "renderers/Clientshell");
//        jQuery.sap.registerModulePath(this.mod.jsappInfo, sCnTxtPath + "renderers/ApplicationInfo");
        jQuery.sap.registerModulePath(this.mod.jsexeInfo, sCnTxtPath + "renderers/ProcessExecutionInfo");
        jQuery.sap.registerModulePath(this.mod.jsexeStat, sCnTxtPath + "renderers/ProcessExecutionStatus");
        jQuery.sap.registerModulePath(this.mod.jsexeWizd, sCnTxtPath + "renderers/ProcessExecutionWizard");
        jQuery.sap.registerModulePath(this.mod.jsexeCntrl, sCnTxtPath + "renderers/ProcesExecutionControl");
        jQuery.sap.registerModulePath(this.mod.jsstepLst, sCnTxtPath + "renderers/ProcessExecutionStepList");
        jQuery.sap.registerModulePath(this.mod.jslogs, sCnTxtPath + "renderers/Logs");
        
        jQuery.sap.registerModulePath(this.mod.jsbrkpnts, sCnTxtPath + "renderers/Breakpoints");
        jQuery.sap.registerModulePath(this.mod.jsprocLst, sCnTxtPath + "renderers/ProcessCollectionList");
        jQuery.sap.registerModulePath(this.mod.jsproTLst, sCnTxtPath + "renderers/ProcessCollectionTreeList");
        jQuery.sap.registerModulePath(this.mod.jsproSng, sCnTxtPath + "renderers/SingleProcess");
        jQuery.sap.registerModulePath(this.mod.jshelp, sCnTxtPath + "renderers/Help");
        
        jQuery.sap.registerModulePath("support.modules", "slui/debug/support/modules/");
    }
};

var oStub;
var oGlobals;
sluiCore.prepareModulePath();
sluiCore.getSLUICss();
