/**
 * HomeScreen - SL UI client controller
 */
sap.ui.controller("HomeScreen", {
    // settings maps
    globProps: 		undefined,
    homeVwProps:	undefined,
    execVwProps:	undefined,
    //format
    sFormat:		undefined,
    cAdapColl:		[],
    cMenuColl:		[],
    //component 
    oProcRepo:		undefined,
    oComm:			undefined,
    oProcExe:		undefined,
    oAdapter:		undefined,
    oLogger:		undefined,
    oUtil:			undefined,
    sSelectedItem:	undefined,
    
    onInit: function () {
        this.rootView = this.getView();
        this.globProps = undefined;
        this.homeVwProps = undefined;
        this.execVwProps =undefined;
    },
    
    onExit: function () {
    	this.oLogger.logD("Exit method is called");
    },
    
    setUIClientProperties: function (oSetng) {
        if (oSetng) {
        	this.oUtil = new SLUIUtility();
        	this.oUtil.checkClientProperties(oSetng);
            this.oLogger = new SLUILogger(oSetng["enableTracing"]);
            this.oLogger.logD("Initialization method is called");
            this.oLogger.logD("Client level properties are received.");
            this.globProps = oSetng;
            this.globProps["showLogo"] = sluiCore.properties.suiLogo;
            this.globProps["showName"] = sluiCore.properties.suiName;
            this.globProps["postUITopology"] = sluiCore.properties.suiMode;
            //I306705
            this.rootView.applyConfigToClientView(oSetng[suiCnst.UI_VW_APP_HDR], oSetng[suiCnst.UI_VW_USR_LOGIN],
                oSetng[suiCnst.UI_VW_USR_NAME], oSetng[suiCnst.UI_VW_WEL_MSG], oSetng[suiCnst.UI_VW_ENBL_SERACH],
                false, oSetng[suiCnst.UI_VW_ENBL_FEEDER], oSetng[suiCnst.UI_VW_UI_MODE]);
            this._initializeControllerComponents();
        } 
        else this.oLogger.logW("Client level properties are empty! Unable to set the configurations to the UI.");
    },
    
    setHomeViewProperties: function (oSetng) {
        if (oSetng) {
            this.oLogger.logD("Homeview properties are received.");
            this.homeVwProps = oSetng;
            this.getView().applyConfigToHomeView(this.homeVwProps[suiCnst.UI_HMEVW_PRP_HOME_MODE]);
        } 
        else this.oLogger.logW("Home view properties are empty.");
    },
    
    setExecutionViewProperties: function (oSetng) {
        if (oSetng) {
            this.oLogger.logD("Execution view properties are received");
            this.execVwProps = oSetng;
            var custButtons = oSetng[suiCnst.UI_EXEVW_CUST_BTNS];
            if (custButtons && custButtons.length > 0) {
                this.oLogger.logD("Custom Buttons are hooked.");
                this.attachCustomHook(custButtons, "EXECNTL_BUTTON");
            }
        } 
        else this.oLogger.logW("Execution view properties are empty.");
    },

    startUIActivity: function () {
        // check for start process from UI
        this.getView().constructViewSequence();
        if (this.homeVwProps[suiCnst.UI_HMEVW_PRP_STRT_PROC_FROMUI] == false) {
            //default start from UI.
            if (this.homeVwProps['defaultStart'] === true && this.homeVwProps[suiCnst.UI_HMEVW_PRP_ROOTURL]) {
            	 if (this.homeVwProps[suiCnst.UI_HMEVW_PRP_ROOTURL]) {
                     this.oLogger.logD("Processes loaded with Root url.");
                     this.loadProcessFromBackEnd(this.homeVwProps[suiCnst.UI_HMEVW_PRP_ROOTURL]);
                 } else {
                     this.oLogger.logD("Processes loaded with base url.");
                     this.loadProcessFromBackEnd(this.globProps[suiCnst.UI_HMEVW_PRP_ROOTURL]);
                 }
            }
            else this.monitorProcessExecution(null, this.globProps[suiCnst.UI_VW_BASEURL]);
        } else {
            if (this.homeVwProps[suiCnst.UI_HMEVW_PRP_ROOTURL]) {
                this.oLogger.logD("Processes loaded with Root url.");
                this.loadProcessFromBackEnd(this.homeVwProps[suiCnst.UI_HMEVW_PRP_ROOTURL]);
            } else {
                this.oLogger.logD("Processes loaded with base url.");
                this.loadProcessFromBackEnd(this.globProps[suiCnst.UI_HMEVW_PRP_ROOTURL]);
            }
        }
    },
    
    uiSleep: function (milliseconds) {
    	  var start = new Date().getTime();
    	  for (var i = 0; i < 1e7; i++) if ((new Date().getTime() - start) > milliseconds) break;
    },
    	
    registerAdapters: function (oAdapt) {
        if (oAdapt) {
            this.oLogger.logD("Adapter objects are received");
            this.cAdapColl.push(oAdapt);
        } 
        else this.oLogger.logW("Adapter object is empty.");
    },
    
    _initializeControllerComponents: function () {
        if (this.globProps[suiCnst.UI_VW_DATATYPE]) {
            this.sFormat = this.globProps[suiCnst.UI_VW_DATATYPE];
            this.oLogger.logD("Controller components are initialized using config type");
        } else {
            this.sFormat = suiCnst.UI_DATA_FORMAT_JSON;
            this.oLogger.logD("Controller components are initialized with default type of JSON");
        }
        this.oComm = new SLUIServiceCommunicator(this.sFormat);
        this.oProcRepo = new SLUIProcessRepository(this.sFormat, this.oComm, this.oLogger);
    },

    startProcessExecution: function () {
        this.oLogger.logD("process execution start is triggered!");
        this._startProcessExecution(this.oProcRepo.leadProcId);
    },

    stopProcessExecution: function () {
        this.oLogger.logD("process execution stop is triggered!");
        clearTimeout(this.oProcExe.getSyncTimer());
        this.oProcExe.pollingActive = false;
        if (this.execVwProps["refreshOnExit"]=== false) {
        	this.oProcExe.oUIProc.diaColl = [];
        	this.oProcExe.oUIProc.isDiaRendered = false;
        	this.oProcExe.setTimerIntervel();
        	this.oProcExe.getSLPRoadMap();
        	this.oProcExe.getSLPMonitor();
        	this.oProcExe.getSLPAction();
        	this.oProcExe.getSLPMonitorWithTimer();
        }
        else {
            this.getView().destroyContent();
        	this.oProcExe.clearExecutor();
            this.oProcExe = undefined;
        }
    },

    moveToNextOfProcessExecution: function () {
        if (!this.oProcExe._checkForDirtyExecution()) {
            this.oLogger.logD("check for config is triggered.");
            this.oProcExe.checkConfig();
        } 
        else this.oLogger.logW("Config was stuck with dirty execution");
    },
    
    // Functionalities
    loadProcessFromBackEnd: function (sURL) {
        this.oLogger.logD("Load processes from backend SLP servers is triggered");
        this.oProcRepo.initialize(sURL, this);
    },
    
    _startProcessExecution: function (sProcId) {
        sap.ui.getCore().byId('_slui_worksetitemprocessexecution').setText("Process Execution");
        this.getView().updateViewUIForState(suiCnst.UI_VW_UPDATE_DIS_PRO_FRM_UI);
        this.oProcRepo.getProcessDefinition(sProcId);
    },

    monitorProcessExecution: function (oProcDef, sDirExeUrl) {
    	//I306705
    	if (!oProcDef) oProcDef = new Object();
    	if (this.homeVwProps[suiCnst.UI_HMEVW_PRP_HOME_MODE] === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_SINGLE) {
    		this.oProcExe = new SLUIProcessExecutor(sDirExeUrl, this.sFormat, this.oComm, this.oLogger, this.cAdapColl);
    		this.oProcExe.execute(oProcDef);
    	} else {
    		this.oProcExe = new SLUIProcessExecutor(sDirExeUrl,this.sFormat, this.oComm,  this.oLogger,this.cAdapColl);
    		this.oProcExe.execute(oProcDef);
    	}
    },
    
    updateView : function(sMode,addData){
    	sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).updateViewUIForState(sMode,null,addData);
    },

    attachCustomHook: function (oCustJS, tType) {
        if (oCustJS) {
            this.getView().uiSubVw.vExeCont.insertCustomButtonSeperator(true);
            for (var x = 0; x < oCustJS.length; x++) this.getView().uiSubVw.vExeCont.insertCustomButton(oCustJS[x]);
        }    
        else this.oLogger.logD("Custom JS adapters are empty.");
    },
    
    attachCustomViewToItem: function (sKey, sTxt, oItem) {
        if (oItem && sKey) this.getView().attachViewToworkSetItemOfClientShell(sKey, sTxt, oItem);
        else this.oLogger.logD("Unable to attach the view to client shell.");
    },
    
    attachMenuItems: function(sText, oFun) {
    	if (sText && oFun) this.cMenuColl.push({uiId:"", sText: sText, fun: oFun});
    },
    
    getRootShell: function() {
    	var oShell = null;
    	oShell= this.getView().vAppShell.appShell;
    	if (!oShell) sap.ui.getCore().byId("_slui.rootShell");	
    	return oShell;
    },
    
    removeMockServiceConnector: function() {
    	this.oComm = new SLUIServiceCommunicator(this.sFormat);
    	this.oProcExe.setExecutorCommunicator(this.oComm);
    },
    
    getGlobalProperties: function() {
    	return this.globProps;
    },
    
    getTaskListTableView: function() {
    	if (this.getView() && this.getView().vExeStpList && this.getView().vExeStpList.stepListTable) return  this.getView().vExeStpList.stepListTable;	
    	else throw Error("Unable to access Task list table.");
    },
    
    getLogTableView: function() {
    	if (this.getView() && this.getView().vLogs && this.getView().vLogs.logsListTable) return this.getView().vLogs.logsListTable;	
    	else throw Error("Unable to access log list table.");
    },
    
    getBreakpointTableView: function() {
    	if (this.getView() && this.getView().vBrkList && this.getView().vBrkList.brkPntListTable) return this.getView().vBrkList.brkPntListTable;	
    	else throw Error("Unable to access breakpoint list table.");
    },
    
    getSidePaneltableByIndex: function(index) {
    	 if 		(index === 1) return this.getTaskListTableView();
    	 else if 	(index === 2) return this.getLogTableView();
    	 else if	(index === 3) return this.getBreakpointTableView();
    	 else return null;
    },
    
    setBusyScreen: function(text) {
        this.getView().updateViewAsBusy(text, 0);
    },
    
    addBusyControl: function(text) {
        this.getView().updateViewAsBusy(text, 1);
    },
    
    removeBusyControl: function() {
        $("#_slui_busyImage_init").remove();
    }
});
