/**
 * Home view is same as Shell view. Inside Home view different kind of views can be placed. HomeScreenView.
 */
sap.ui.jsview("HomeScreen", {

    vAppShell:		undefined, // Application shell
    vAppInfo:		undefined, // Application Information
    vProcList:		undefined, // Process List
    vExeInfo:		undefined, // Execution Information
    vExeStus:		undefined, // Execution Status
    vExeWizd:		undefined, // Execution Wizard
    vAlert:			undefined, // Alert View
    vExeStpList:	undefined,
    vBrkList:		undefined,
    vExeCont:		undefined, // Execution Control
    vLogs:			undefined, // Logs
    vErrors:		undefined, // Errors
    errDialogShown:	false,
    
    // get controller for SL UI client
    getControllerName: function() {
        return "HomeScreen";
    },
    
    createContent: function(oController) {
    	var sType=  sap.ui.core.mvc.ViewType.JS;
        this.layout = new sap.ui.commons.layout.VerticalLayout({
            id: "_slui_invisblecontainer",
            width: "100%"
        });
        this.vAppShell = sap.ui.view({
            id: "_slui_appShellView",
            width: "100%",
            viewName: sluiCore.mod.jsshell,
            type: sType
        });
/*        this.vAppInfo = sap.ui.view({
            id: "_slui_appInfoView",
            width: "100%",
            viewName: sluiCore.mod.jsappInfo,
            type: sType
        });*/
        this.vExeInfo = sap.ui.view({
            id: "_slui_exeInfoView",
            width: "100%",
            viewName: sluiCore.mod.jsexeInfo,
            type: sType
        });
        this.vExeStus = sap.ui.view({
            id: "_slui_exeStatusView",
            width: "100%",
            viewName: sluiCore.mod.jsexeStat,
            type: sType
        });
        this.vExeWizd = sap.ui.view({
            id: "_slui_exeWizardView",
            width: "100%",
            viewName: sluiCore.mod.jsexeWizd,
            type: sType
        });
        this.vExeCont = sap.ui.view({
            id: "_slui_exeControlView",
            width: "100%",
            viewName: sluiCore.mod.jsexeCntrl,
            type: sType
        });
        this.vExeStpList = sap.ui.view({
            id: "_slui_execStepListView",
            width: "100%",
            viewName: sluiCore.mod.jsstepLst,
            type: sType
        });
        this.vLogs = sap.ui.view({
            id: "_slui_execLogs",
            width: "100%",
            viewName: sluiCore.mod.jslogs,
            type: sType
        });
        this.vBrkList = sap.ui.view({
        	id:"_slui_exe_brkPnts",
        	width:"100%",
        	viewName: sluiCore.mod.jsbrkpnts,
            type: sType
        });
       return this.vAppShell;
    },
    
    //I306705
    applyConfigToClientView: function(sAppHdrText, bUserLoginOn, sUserName, sWelcomeMsg, bSearchTool, bInspectorTool, bfeederTool,sUIMode) {
        this.vAppShell.supplyData(sAppHdrText, bUserLoginOn, sUserName, sWelcomeMsg, bSearchTool, bInspectorTool,bfeederTool,sUIMode);
    },
    
    applyConfigToHomeView: function(sTyp) {
    	var oLog=this.getController().oLogger; 
    	oLog.logD("Received home view type is " + sTyp);
    	var sType = sap.ui.core.mvc.ViewType.JS;
        if (sTyp ===suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_LIST) {
            this.vProcList = sap.ui.view({
                id: "_slui_processListView",
                width: "100%",
                viewName: sluiCore.mod.jsprocLst,
                type: sType
            });
            oLogr.logD("List type home view is generated.");
        } else if (sTyp === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_TLIST) {
            this.vProcList = sap.ui.view({
                id: "_slui_processTreeListView",
                width: "100%",
                viewName: sluiCore.mod.jsproTLst,
                type: sType
            });
            oLog.logD("Tree List type home view is generated.");
        } else if (sTyp === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_GROUP) {
            this.vProcList = sap.ui.view({
                id: "_slui_processGroupListView",
                width: "100%",
                viewName: sluiCore.mod.jsproGLst,
                type: sType
            });
            oLog.logD("Group type home view is generated.");            
        } else if (sTyp === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_SINGLE) {
            this.vProcList = sap.ui.view({
                id: "_slui_simpleProcessView",
                width: "100%",
                viewName: sluiCore.mod.jsproSng,
                type: sType
            });
            oLog.logD("Single type home view is generated.");
        } 
        else oLog.logW("Unidentified Home view type is received");
        this.updateViewUIForState(suiCnst.UI_VW_UPDATE_DIS_PRO_FRM_UI, this.layout);
    },

    constructViewSequence: function() {
        if (this.getController().homeVwProps[suiCnst.UI_HMEVW_PRP_STRT_PROC_FROMUI] === true) {
        	this.getController().oLogger.logD("Configured as start and monitor a process from UI");
            this.updateViewUIForState(suiCnst.UI_VW_UPDATE_START_PRO_FRM_UI, this.layout);
        } else {
        	this.getController().oLogger.logD("Configured as monitoring started process from UI");
        	this.updateViewUIForState(suiCnst.UI_VW_UPDATE_MON_PRO_FRM_UI, this.layout);
        }
        if (this.vAppShell) this.vAppShell.updateViewAfterRednering();	
    },
    
    updateViewUIForState: function(vState, oPLyt,addData) {
        oPLyt = this.layout;
        if (vState === suiCnst.UI_VW_UPDATE_DIS_PRO_FRM_UI) { // DISPLAY LIST OF PROCESSES
            if (this.vExeInfo && oPLyt.indexOfContent(this.vExeInfo) > -1) oPLyt.removeContent(this.vExeInfo);
            if (this.vExeStus && oPLyt.indexOfContent(this.vExeStus) > -1) oPLyt.removeContent(this.vExeStus);
            if (this.vExeWizd && oPLyt.indexOfContent(this.vExeWizd) > -1) oPLyt.removeContent(this.vExeWizd);
            if (this.vExeCont && oPLyt.indexOfContent(this.vExeCont) > -1) oPLyt.removeContent(this.vExeCont);
            this.vAppShell.removeLogsSidePaneBarItem();
            this.vAppShell.removeBreakPointsSidePanBarItem();
            this.vAppShell.removeTaskListSidePanBarItem();
            oPLyt.addContent(this.vProcList);
            this.vAppShell.insertViewForWorkSetItem(0, this.layout, true);
        } else if (vState === suiCnst.UI_VW_UPDATE_START_PRO_FRM_UI) {
            if (this.vExeInfo && oPLyt.indexOfContent(this.vExeInfo) > -1) oPLyt.removeContent(this.vExeInfo);
            if (this.vExeStus && oPLyt.indexOfContent(this.vExeStus) > -1) oPLyt.removeContent(this.vExeStus);
            if (this.vExeStpList && oPLyt.indexOfContent(this.vExeStpList) > -1) oPLyt.removeContent(this.vExeStpList);
            if (this.vExeWizd && oPLyt.indexOfContent(this.vExeWizd) > -1) oPLyt.removeContent(this.vExeWizd);
            if (this.vExeCont && oPLyt.indexOfContent(this.vExeCont) > -1) oPLyt.removeContent(this.vExeCont);
            oPLyt.addContent(this.vProcList);
            this.vAppShell.insertViewForWorkSetItem(0, this.layout, true);
        } else if (vState === suiCnst.UI_VW_UPDATE_MON_PRO_FRM_UI) {
            if (this.vProcList && oPLyt.indexOfContent(this.vProcList) > -1) oPLyt.removeContent(this.vProcList);
            oPLyt.addContent(this.vExeInfo);
            oPLyt.addContent(this.vExeStus);
            oPLyt.addContent(this.vExeWizd);
            oPLyt.addContent(this.vExeCont);
            this.vAppShell.insertViewForWorkSetItem(0, this.layout, true);
        } else if (vState == suiCnst.UI_VW_UPDATE_FNSH_UI) {
            this.vExeStus.updateContent(suiCnst.UI_DIS_EXE_FNSH);
            this.vExeCont.updateContent(suiCnst.UI_DIS_EXE_FNSH);
            this.vAppShell.insertViewForWorkSetItem(0, this.layout, false);
        } else {
            if (this.vProcList && oPLyt.indexOfContent(this.vProcList) > -1) oPLyt.removeContent(this.vProcList);
            oPLyt.addContent(this.vExeInfo);
            oPLyt.addContent(this.vExeStus);
            oPLyt.addContent(this.vExeWizd);
            oPLyt.addContent(this.vExeCont);
            this.vExeInfo.updateContent();
            if (this.getController().globProps["showSLPTasklistinSB"] === true) this.vAppShell.addTaskListSidePanBarItem();
            if (this.getController().globProps["showSLPLogsinSB"] === true) this.vAppShell.addLogsSidePanBarItem();
            if (this.getController().globProps["showSLPBreakPointsinSB"] === true) this.vAppShell.addBreakPointsSidePanBarItem();
        }
        switch (vState) {
        case suiCnst.UI_VW_UPDATE_MONITOR:
        case suiCnst.UI_VW_UPDATE_ROADMAP:
        	this.vExeStus.updateContent();
        	this.vExeWizd.updateContent();
        	break;
        case suiCnst.UI_VW_UPDATE_DIALOG :
        	this.vExeWizd.updateContent();
        	break;
        case suiCnst.UI_VW_UPDATE_ACTION :
        	this.vExeCont.updateContent();
        	break;
        case suiCnst.UI_VW_UPDATE_ERROR:
        	break;
        case suiCnst.UI_VW_UPDATE_LOG:
        	this.vLogs.updateContent(false);
        	break;
        case suiCnst.UI_VW_UPDATE_CONFIG:
        	break;
        case suiCnst.UI_VW_UPDATE_TASKLIST:
        	this.vExeStpList.updateContent(true, false);
        	break;
        case suiCnst.UI_VW_UPDATE_BREAKPOINTS:
        	this.vBrkList.updateContent(false);
        	break;
        case suiCnst.UI_VW_UPDATE_SERVICE_ERROR:
        	this.displayServiceErrorMessage();
        	break;
        case suiCnst.UI_VW_GET_LOG_WARNING:
        	this.displayLogInfo();
        	break;
        case suiCnst.UI_VW_ABOUT:
        	new SLUIDialogProvider().getAboutDialog();
        	break;
        default:
//        	"//DO NOTHING"
        }        
    },
    
    attachViewToworkSetItemOfClientShell: function(sItemKey, sItemTitleText, oItemView) {
        this.vAppShell.attachViewForWorkSetItem(sItemKey, sItemTitleText, oItemView);
    },
    
    getApplicationShell: function() {
        return this.vAppShell.shell;
    },
    
    getExecutionStatusView: function() {
    	return this.vExeStus;
    },
    
    displayServiceErrorMessage: function() {
    	if (this.getController().globProps["throwErrorOnUI"] == true) {
    		if (!this.errDialogShown) {
    			var errDia = new SLUIDialogProvider().errorDialog(this.getController().oProcExe.oUIProc.currentError);
    			if (errDia) {
    				errDia.open();
    				this.errDialogShown = true;
    			} 
    			else this.getController().oProcExe.pollingActive = true; //continue polling, otherwise you are lost in space
    		}
    	}
    },
    
    displayLogInfo: function() {
            new SLUIDialogProvider().getDialog("infoDialog", oBundle.getText("DIA_LOG_VANISHED_TXT"), oBundle.getText("DIA_LOG_VANISHED_TITLE")).open();
    },
    
    //mode 0: remove original content and add busy element
    //mode 1: do not clear original content and just add busy element
    updateViewAsBusy: function(text, mode) {
        var sucr = sap.ui.core;
        var busyId = "";
        if (mode === 0) {
            this.layout.removeAllContent();
            busyId = "_slui_busyImage";
        }
        else if(mode === 1) busyId = "_slui_busyImage_init";
    	this.layout.addContent(new sucr.HTML(busyId, {content: '<div style="width:100%;min-width:500px;min-height:300px; height:100%;" data-sap-ui-preserve="'+busyId+'" id="'+busyId+'"><div style="position:absolute;top:20%;left:15%;margin-top:-25px;margin-left:-25px;"><center><img src="slui/resources/logo/busy.gif" class="sapUiImg" role="presentation"><br>'+text+'</center></div></div>'}));
    },
    
    onBeforeRendering: function() {
    	if (functionsBeforeRendering && (functionsBeforeRendering.length > 0)) {
    		var funcToExecute;
    		for (var i=0; i < functionsBeforeRendering.length; i++) {
    			funcToExecute = functionsBeforeRendering[i];
    			if (funcToExecute) funcToExecute();
    		}
    	}
    },
    
    onAfterRendering: function() {
    	if (functionsAfterRendering && (functionsAfterRendering.length > 0)) {
    		var funcToExecute;
    		for (var i=0; i < functionsAfterRendering.length; i++) {
    			funcToExecute = functionsAfterRendering[i];
    			if (funcToExecute) funcToExecute();
    		}
    	}
    }
});