/**
 * SL UI Client public APIs are available from this module. Public APIs, Public Objects are exposed with a definitive
 * functions
 */
jQuery.sap.declare(sluiCore.mod.jsclient);
SLUIClient = function(id, title) {
    this.oFather = null;
    var view = sap.ui.view({
        id: "_slui_HomeScreen",
        viewName: "HomeScreen",
        type: sap.ui.core.mvc.ViewType.JS
    });
    if (id) {
        view.placeAt(id);
    }
    this.oFather = view.getController();
    oStub = this;
    return this;
};

SLUIClient.prototype.configureClient = function(oSettings) {
    // check for proper settings is missing - Need to be added later
    if (this.oFather) {
        if (oSettings) this.oFather.setUIClientProperties(oSettings);
        else throw new Error("SLUI:Error@UI Controller is empty , unable to set the configurations");
    } 
    else throw new Error("SLUI:ERROR@UI Controller is not initialized!");
};

SLUIClient.prototype.configureHomeView = function(oSettings) {
    if (this.oFather) {
        if (oSettings) this.oFather.setHomeViewProperties(oSettings);
        else throw new Error("SLUI:ERROR@Home view cannot be initialized due to missing home view configuration");
    }
};

SLUIClient.prototype.configureExecutionView = function(oSettings) {
    if (this.oFather) this.oFather.setExecutionViewProperties(oSettings);
    else throw new Error("SLUI:ERROR@Home view cannot be initialized due to missing home view configuration");
};

SLUIClient.prototype.start = function() {
    if (this.oFather) this.oFather.startUIActivity();
    else throw new Error("SLUI:ERROR@Unable to start the UI activity due to missing controller");
};

SLUIClient.prototype.getAppShell = function() {
    if (this.oFather) return this.oFather.getView().getApplicationShell();
    else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot access its view.");
};

SLUIClient.prototype.initializeProcessRegistry = function(resourceURL) {
    if (this.oFather) this.oFather.loadProcessFromBackEnd(resourceURL);
    else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot initialize the process registry");
};

SLUIClient.prototype.executeProcessFromRegistry = function(processID) {
    if (this.oFather) this.oFather.startProcessExecution(processID);
    else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot start the process execution from registry");
};

SLUIClient.prototype.registerAdapters = function(sId, sSLPResource, sUrlPattern, sRulePath) {
    if (sId && sRulePath) {
        if (sSLPResource == null || sSLPResource === "") sSLPResource = "/dialog";
        var oAdapt = {
            sId: sId,
            sSLPResource: sSLPResource,
            sURLPattern: sUrlPattern,
            sRulePath: sRulePath
        };
        this.oFather.registerAdapters(oAdapt);
    } 
    else throw new Error("SLUI:Error@Registering adapter failed due to missing attribute. Id:" + sId + " | URL pattern :" + sUrlPattern + " | Rule Path:" + sRulePath);
};

SLUIClient.prototype.attachNavigationItem = function(itemKey, itemTitleText, itemView) {
    if (itemKey && itemTitleText && itemView && this.oFather) this.oFather.attachCustomViewToItem(itemKey, itemTitleText, itemView);
    else throw new Error("SLUI:Error@Attaching custom navigation item to the view has failed");
};

SLUIClient.prototype.getRootShell = function() {
    if (this && this.oFather) return this.oFather.getRootShell();
    else return null;
};

SLUIClient.prototype.attachProcessUIInfo = function(displayName, description) {
    if (displayName && description) this.oFather.attachCustomViewToItem(itemKey, itemTitleText, itemView);
    else throw new Error("SLUI:Error@Attaching process UI detail is failed.");
};

SLUIClient.prototype.addCustomMenuItem = function(sText, oFun) {
    if (sText && oFun) this.oFather.attachMenuItems(sText, oFun);
    else throw new Error("SLUI:Error@Attaching custom Menu item to the view is failed");
};

SLUIClient.prototype.getCurrentProcess = function() {
    if (this && this.oFather) return this.oFather.oProcExe.oUIProc;
    else return null;
};

SLUIClient.prototype.getServiceConnector = function() {
    if (this && this.oFather && this.oFather.oComm) return this.oFather.oComm;
    else return null;
};

SLUIClient.prototype.setMockServiceConnector = function(oComm) {
    if (this && this.oFather && oComm) {
        this.oFather.oComm = oComm;
        this.oFather.oProcExe.setExecutorCommunicator(oComm);
    }
};

SLUIClient.prototype.getProcessExecutor = function() {
    if (this && this.oFather) return this.oFather.oProcExe;
};

SLUIClient.prototype.getGlobalProperties = function() {
    if (this && this.oFather) this.oFather.getGlobalProperties();
};

SLUIClient.prototype.removeMockServiceConnector = function() {
    if (this && this.oFather) this.oFather.removeMockServiceConnector();
};

SLUIClient.prototype.getRootController = function() {
    if (this.oFather) return this.oFather;
};

SLUIClient.prototype.getTaskListTable = function() {
    if (this.oFather) return this.oFather.getTaskListTableView();
    else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot access the specified view ");
};

SLUIClient.prototype.getLogistTable = function() {
    if (this.oFather) return this.oFather.getLogTableView();
    else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot access the specified view ");
};

SLUIClient.prototype.getBreakpointListTable = function() {
    if (this.oFather) return this.oFather.getBreakpointTableView();
    else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot access the specified view ");
};

SLUIClient.prototype.getSideTableByIndex = function(index) {
    if (this.oFather && index && index >0) return this.oFather.getSidePaneltableByIndex(index);
    else throw new Error("SLUI:Error@For given index, UI object cannot be accessed.");
};

SLUIClient.prototype.attachFunctionBeforeRendering = function(fnBeforeRendering) {
	 if (fnBeforeRendering) functionsBeforeRendering.push(fnBeforeRendering);
	 else throw new Error("SLUI:Error@Attaching a function before UI rendering has failed");
};

SLUIClient.prototype.attachFunctionAfterRendering = function(fnAfterRendering) {
	 if (fnAfterRendering) functionsAfterRendering.push(fnAfterRendering);
	 else throw new Error("SLUI:Error@Attaching a function after UI rendering has failed");
};

SLUIClient.prototype.attachFunctionBeforeDialogRendering = function(fnBeforeRendering) {
	 if (fnBeforeRendering) functionsBeforeDialogRendering.push(fnBeforeRendering);
	 else throw new Error("SLUI:Error@Attaching a function before metadialog  UI rendering has failed");
};

SLUIClient.prototype.attachFunctionAfterDialogRendering = function(fnAfterRendering) {
	 if (fnAfterRendering) functionsAfterDialogRendering.push(fnAfterRendering);
	 else throw new Error("SLUI:Error@Attaching a function after metadialog UI rendering has failed");
};

SLUIClient.prototype.getMonitorView = function() {
	if(this.oFather) return this.oFather.getView().getExecutionStatusView( );
	else throw new Error("SLUI:Error@SLUI Controller is empty. Cannot access the specified view ");
};
