jQuery.sap.declare(sluiCore.mod.jscomm);

SLUIServiceCommunicator = function(sFmat) {
    this.defHdr = {
        HTTP_METHOD_NAME:	suiCnst.HTTP_METHOD_GET,
        REQUEST_DATA_TYPE:	suiCnst.UI_DATA_FORMAT_JSON,
        ACCEPT_DATA_TYPE:	suiCnst.HTTP_RESP_TYPE_APP_JSON,
        CONTENT_TYPE:		suiCnst.HTTP_CNT_TYPE_APP_JSON
    };
    this.successCount = 0;
    this.cleanupTriggered = false;
    this.hasDialog = false;

    if (sFmat != null && sFmat != undefined) {
        if (sFmat === suiCnst.UI_DATA_FORMAT_JSON){
			this.defHdr.REQUEST_DATA_TYPE = suiCnst.UI_DATA_FORMAT_JSON;
			this.defHdr.ACCEPT_DATA_TYPE = suiCnst.HTTP_RESP_TYPE_APP_JSON;
		}else if (sFmat === suiCnst.UI_DATA_FORMAT_XML){
			this.defHdr.REQUEST_DATA_TYPE = suiCnst.UI_DATA_FORMAT_XML;
			this.defHdr.ACCEPT_DATA_TYPE = suiCnst.HTTP_RESP_TYPE_APP_XML;
		}
    }
};

// Creates a backend connection and in async mode 
SLUIServiceCommunicator.prototype.connect = function(sUrl, oHdr, fnParseData, fnOnError, fnOnSuccess, reqData, addData) {
    this._triggerConnect(sUrl, oHdr, fnParseData, fnOnError, fnOnSuccess, reqData, addData, true, false);
};

// sync mode 
SLUIServiceCommunicator.prototype.syncconnect = function(sUrl, oHdr, fnParseData, fnOnError, fnOnSuccess, reqData, addData) {
	this._triggerConnect(sUrl, oHdr, fnParseData, fnOnError, fnOnSuccess, reqData, addData, false, false);
};

//Exit sequence 
SLUIServiceCommunicator.prototype.exitPage = function() {
	
	function successReq(data) {
		// the unexpected case... at least for longer time
		var gloMode = $(data).children("Monitor").children("Task").first().children("globalmode").text();
		this.cleanupAllowed = ((gloMode === "ResetDone") || (gloMode === "COMPLETED"));
		var monStatus = $(data).children("Monitor").children("Task").first().children("status").text();
		this.hasDialog = (monStatus !== "slp.task.state.RUNNING");
		oStub.oFather.oProcExe.globalPollingActive = true; 
		if ((monStatus == "slp.task.state.FINISHED") && (++this.successCount < 4)) {setTimeout($.proxy(this.exitPage, this), 500); return;}
        if ((++this.successCount > 10) || this.hasDialog) {this.successCount = 0; oStub.oFather.oProcExe.oUIProc.triggerd.mon = false; this.cleanupTriggered = true; oStub.oFather.oProcExe.getSLPMonitorWithTimer();}
        else setTimeout($.proxy(this.exitPage, this), 2000);
	}
	function failReq(xhr, status, error) {
		// the expected case
		oStub.oFather.oProcExe.globalPollingActive = false;
		document.open();
		var htmlClosingPage="<HEAD></HEAD><body bgcolor=\"#DDEDF1\"><hr>The SUM ABAP server process (&quot;SAPup&quot;) has been ended. You may close the browser page now. For an immediate restart of SUM <a href=\".\">click here</a> or refresh the browser page.<hr></body>";							
		document.write(htmlClosingPage);
		window.stop();
	}

	oStub.oFather.oProcExe.pollingActive = false;       
	clearTimeout(oStub.oFather.oProcExe.executionSyncTimer);
	this.connect(oStub.oFather.oProcExe.oUIProc.urls.monitorUrl, null, null,  failReq, $.proxy(successReq, this), null, {slpResourceName: suiCnst.SLP_RESOURCE_MONITOR});
	oStub.oFather.oProcExe.globalPollingActive = false;
};

// service connection trigger
SLUIServiceCommunicator.prototype._triggerConnect = function(sUrl, oHdr, fnParseData, fnOnError, fnOnSuccess, reqData, addData, bSync, bCache) {
    if (sUrl) {
        if ((sUrl.indexOf("/exit")>-1)&&(oStub.oFather.oProcExe.httpServerExitTriggered)) bSync = false;//next call synchronized
        var result = null;
        //check pre-requite header fields 
        oHdr = this._checkHTTPHeaders(oHdr);
        if (reqData == null) {
            if ((typeof oStub.oFather.oProcExe === 'undefined')||(oStub.oFather.oProcExe.globalPollingActive)) {
                $.ajax({
                    url: sUrl,
                    type: oHdr.HTTP_METHOD_NAME,
                    dataType: oHdr.REQUEST_DATA_TYPE,
                    accept: oHdr.ACCEPT_DATA_TYPE,
                    async: bSync,
                    cache: bCache,
                    success: $.proxy(function(data, status, xhr) {
                        if ((sUrl.indexOf("/exit")>-1)&&(oStub.oFather.oProcExe.httpServerExitTriggered)) this.exitPage();
                        if ((sUrl.indexOf("/cleanup")>-1)&&(oStub.oFather.oProcExe.oUIProc.sState===suiCnst.SLP_TASK_STATUS_FINISHED)) setTimeout($.proxy(this.exitPage, this), 1000);
                        data = xhr.responseText;
                        oStub.oFather.oComm.logResponse(addData.slpResourceName, data);
                        var respHead = xhr.getResponseHeader(suiCnst.HTTP_CNT_TYPE_NAME);
                        addData.status = xhr.status;
                        if (respHead && (respHead.indexOf(suiCnst.HTTP_CNT_TYPE_TXT_PLAIN) === -1) && (respHead.indexOf(suiCnst.HTTP_CNT_TYPE_TXT_HTML) === -1) && (respHead.indexOf(suiCnst.HTTP_CNT_TYPE_APP_BIN) === -1)) {
                        	try {data = jQuery.parseXML(data);}
                        	catch(err) {
                        		oStub.oFather.oLogger.logD("Error occurred during MIME parsing: No valid XML" );
                        	}
                        }
                        if (fnParseData) data = fnParseData(data);
                        if (fnOnSuccess) fnOnSuccess(data, addData);	
                    }, this),
                    error: $.proxy(function(xhr, txtStat, errThrown) {
                            var errorObj = oStub.oFather.oComm._createErrorObject(addData.slpResourceName, xhr, txtStat, errThrown);
                            if (fnOnError) fnOnError(errorObj);
                            else  oStub.oFather.oLogger.logD("Error occurred in serivce communication" + txtStat );
                    }, this)
                });
            }
        } else {
            if ((typeof oStub.oFather.oProcExe === 'undefined')||(oStub.oFather.oProcExe.globalPollingActive)) {
                $.ajax({
                    url: sUrl,
                    type: oHdr.HTTP_METHOD_NAME,
                    dataType: oHdr.REQUEST_DATA_TYPE,
                    contentType: oHdr.CONTENT_TYPE,
                    accept: oHdr.ACCEPT_DATA_TYPE,
                    async: bSync,
                    data: reqData,
                    cache: bCache,
                    success: $.proxy(function(data, status, xhr) {
                        data = xhr.responseText;
                        addData.status = xhr.status;
                        oStub.oFather.oComm.logResponse(addData.slpResourceName, data);
                        data = jQuery.parseXML(data);
                        result = data;
                        if (fnParseData) result = fnParseData(data);
                        if (fnOnSuccess) fnOnSuccess(result, addData);	
                    }, this),
                    error: $.proxy(function(xhr, txtStat, errThrown) {
                            var errorObj = oStub.oFather.oComm._createErrorObject(addData.slpResourceName, xhr, txtStat, errThrown);
                            if (fnOnError) fnOnError(errorObj);
                            else oStub.oFather.oLogger.logD("Error occurred in serivce communication" + txtStat );
                    }, this)
                });
            }
        }
    } 
    else oStub.oFather.oLogger.logD("Serivce communication cannot be triggered without a valid url!");
};

SLUIServiceCommunicator.prototype.logResponse = function(sResourceName, dta) {
	oStub.oFather.oLogger.logD("--------------------------------------------------------------");
	oStub.oFather.oLogger.logD("Response Received At : " + new Date());
	oStub.oFather.oLogger.logD(dta);
	oStub.oFather.oLogger.logD("--------------------------------------------------------------");
};

SLUIServiceCommunicator.prototype._createErrorObject = function(sResourceName, xhr, txtStat, errThrown) {
    var respTxt = xhr.responseText;
    // do not set XML send an Object
    var errObj = {};
    //if service returns Error XML
    if ((respTxt && respTxt.indexOf("<") > -1) && (respTxt.indexOf(">") > -1)){
    	 if ($(respTxt).find("Error").length != 0) {
    	        var usrMessage = [];
    	        var devMessage = [];
    	        $.each($(respTxt).find("Error"), function() {
    	            usrMessage.push($(this).find("userMessage").text());
    	        });
    	        $.each($(respTxt).find("Error"), function() {
    	            devMessage.push($(this).find("devMessage").text());
    	        });
    	    	errObj.resourceName = sResourceName;
    	    	errObj.slpresourceName = sResourceName;
    	    	errObj.statusTxt = xhr.statusText;
    	    	errObj.statusCode = xhr.status;
    	    	errObj.usrMag = usrMessage;
    	    	errObj.devMsg = devMessage;
    	    } else {
    	    	errObj.resourceName = "SLP Resource: "+sResourceName;
    	    	errObj.slpresourceName = sResourceName;
    	    	errObj.statusTxt = xhr.statusText;
    	    	errObj.statusCode = xhr.status;
    	    	errObj.usrMag = "Internal error occurred. Press F5 to restore the session.";
    	    	errObj.devMsg = "Message from service : "+xhr.responseText + " ,| Check the browser console for more information."; 
    	    }
    } else {
    	errObj.resourceName = "SLP Resource: "+sResourceName;
    	errObj.slpresourceName = sResourceName;
    	errObj.statusTxt = xhr.statusText;
    	errObj.statusCode = xhr.status;
    	errObj.usrMag = "Internal error occurred. Press F5 to restore the session.";
    	errObj.devMsg = "Message from service : "+xhr.responseText + " ,| Check the browser console for more information."; 
    }
    return errObj;
};

// Check and pre-fill few HTTP Header Fields
SLUIServiceCommunicator.prototype._checkHTTPHeaders = function(oHdr) {
    if (oHdr != null) {
        if (oHdr.HTTP_METHOD_NAME === null || oHdr.HTTP_METHOD_NAME === undefined || oHdr.HTTP_METHOD_NAME === '') oHdr.HTTP_METHOD_NAME = this.defHdr.HTTP_METHOD_NAME;
        if (oHdr.REQUEST_DATA_TYPE === null || oHdr.REQUEST_DATA_TYPE === undefined || oHdr.REQUEST_DATA_TYPE === '') oHdr.REQUEST_DATA_TYPE = this.defHdr.REQUEST_DATA_TYPE;
        if (oHdr.ACCEPT_DATA_TYPE === null || oHdr.ACCEPT_DATA_TYPE === undefined || oHdr.ACCEPT_DATA_TYPE === '') oHdr.ACCEPT_DATA_TYPE = this.defHdr.ACCEPT_DATA_TYPE;
    } 
    else oHdr = this.defHdr;
    return oHdr;
};