jQuery.sap.declare(sluiCore.mod.jsexe);

SLUIProcessExecutor = function (sBUrl, sFormat, oComm, oLog, cAdapt) {
	this.initialize();
	this.oComm = oComm;
	this.oLog  = oLog;
	this.oFather = oStub.oFather;
    if (sFormat) this.sDataFormatType = sFormat;
    else this.oLog.logE("Process Executor Cannot be initialized out a base components!");

    if (sBUrl) this.sBaseURL = sBUrl;
    else this.oLog.logE("Process Executor Cannot be initialized with out base URL");

    if (cAdapt) this.cAdapters = cAdapt;
};

SLUIProcessExecutor.prototype.setExecutorCommunicator = function (oComm)
{
	if (oComm) this.oComm = oComm;
};

SLUIProcessExecutor.prototype.initialize = function() {
	this.executionSyncTimer = undefined;
	this.oProcDef =  undefined;
	this.oUIProcColl = [];
	this.oUIProc = undefined;
	this.sBaseURL= undefined;
	this.cAdapters = undefined;	
	this.sDataFormatType = undefined ;
	this.oComm = undefined;
	this.oLog = undefined;
	this.oFather = undefined;
	this.isFeedbackDisplayed = false;
	this.timerIntervel  = 6000;
	this.repeatMonitor = false;
	this.pollingActive = true;				// Status polling is active, i.e. not in dialog mode    
	this.globalPollingActive = true;		// stop polling globally, e.g. after httpserver exit, required to avoid new http server start
	this.httpServerExitTriggered = false;	// if exit pressed on Tool start required dialog
	this.fastPolls = 10;					// number of poll iterations with fast period, slowdown after 50%, "sleepy" after 100%
	this.lastProcState = [];
};

SLUIProcessExecutor.prototype.clearExecutor = function() {
	this.initialize();
};

SLUIProcessExecutor.prototype.execute = function(oProcDef) {
    if (oProcDef == null || oProcDef === '') this.oLog.logE("Process Executor cannot trigger the 'execute' event with out a Process definition");
    else {
        this.oProcDef = oProcDef;
        this._execute();
    }
};

SLUIProcessExecutor.prototype._execute = function() {
    this.oUIProcColl.push(new SLUIProcess(this.oProcDef, this.sBaseURL, this.sDataFormatType, this.cAdapters));	
    this.oUIProc = this.oUIProcColl[0];
    this.setTimerIntervel();
    this.getSLPRoadMap();
    this.getSLPMonitor();
/*  KB: for unknown reasons, loading this initial full tasklist (asynchronously) may lead to problems with HostAgent and Chrome --> commented out 08.03.2017 */
//	this.getSLPTaskList();
    this.getSLPAction();
    this.getSLPMonitorWithTimer();
};

SLUIProcessExecutor.prototype.externalExecute = function(bRoadMap, bMonitor, bAction, bDialog) {
    if (this.oUIProc) {
    	this.externalDebug = true;    	
    	oStub.oFather.getView().vExeWizd.distroyWizrdContent();
    	oStub.oFather.getView().vExeCont.oToolbar.destroyItems();
    	oStub.oFather.getView().vExeStus.progRdMap.destroySteps();    	
    	if (bRoadMap) {
    		this.oUIProc.conditionalReTrigger(true, false, false, false, false);
    		this.getSLPRoadMap();	
    	}
    	if (bMonitor) {
    		this.oUIProc.conditionalReTrigger(false, true, false, false, false);
    		this.getSLPMonitor();
    	}
    	if (bAction) {
    		this.oUIProc.conditionalReTrigger(false, false, false, true, false);
    		this.getSLPAction();	
    	}
    	if (bDialog) {
    		this.oUIProc.conditionalReTrigger(false, false, true, false, true);
    		this.getSLPConfig(true);
    		this.getSLPDialog();
    	}
    }
};

SLUIProcessExecutor.prototype.setTimerIntervel = function() {
	if (this.oFather.globProps["syncIntervel"]) this.timerIntervel = parseInt(this.oFather.globProps["syncIntervel"]);
};

SLUIProcessExecutor.prototype.getSLPMonitor = function() {
	if (this.oComm && this.oUIProc) this.oUIProc.loadMonitor(this.oComm);
	else this.oLog.logE("Unable to get Action resource without process object");
//	refresh tasklist table (small refresh - without polling data) if visible
	oStub.oFather.getView().vExeStpList.updateContent(true, false);
};

SLUIProcessExecutor.prototype.getSLPRoadMap = function() {
	if (this.oComm && this.oUIProc) this.oUIProc.loadRoadMap(this.oComm);
	else this.oLog.logE("Unable to get Action resource without process object");
};

SLUIProcessExecutor.prototype._triggerStartAction = function() {
	if (this.oComm && this.oUIProc.hasActions) this.oUIProc.triggerAction(this.oComm, "START");
    else this.oLog.logE("Unable to trigger start Action resource without process object");
};

// START ACTIONS
SLUIProcessExecutor.prototype.invokeTagetAction = function(sAtnId, typ, addData) {
    if (sAtnId) {
    	var btconfig = this.oFather.execVwProps["triggerConfigOnly"];
    	if (typ === suiCnst.SLP_ACTN_TYPE_SUBMIT && oStub.oFather.oUtil.checkMonitorState(this.oUIProc.sState, 3)) {
    		if (btconfig) this.checkConfig(addData);
    		else {
    			this.checkConfig(addData);
    		    if (this.oComm && this.oUIProc) this.oUIProc.invokeAction(sAtnId, this.oComm);
    		    else this.oLog.logE("Process Executor cannot trigger the target action without a Process definition");
    		}
    	} else {
    		if (this.oComm && this.oUIProc) {
				/* when state is FINISHED and cleanup is done, the Next button should trigger (1) feed config instead of next, (2) return to polling loop  */
				if ((this.oUIProc.sState===suiCnst.SLP_TASK_STATUS_FINISHED) && (typ===suiCnst.SLP_ACTN_TYPE_SUBMIT)) this.checkConfig(addData);
				else this.oUIProc.invokeAction(sAtnId, this.oComm);
    		} 
    		else this.oLog.logE("Process Executor cannot trigger the target action without a Process definition");
    	}
    } 
    else this.oLog.logD("Cannot trigger an action with out referencing action Id");
};

SLUIProcessExecutor.prototype.getSLPTaskList = function() {
    if (this.oComm && this.oUIProc) this.oUIProc.loadTasklist(this.oComm);
    else this.oLog.logE("Process Executor cannot get the Task List resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPTaskListByRoadMap = function(roadMapId) {
    if (this.oComm && this.oUIProc) this.oUIProc.loadTasklistByRoadMapId(this.oComm, roadMapId);
    else this.oLog.logE("Process Executor cannot get the Task List resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPBreakpoints = function() {
    if (this.oComm && this.oUIProc) this.oUIProc.loadBreakPoints(this.oComm);
    else this.oLog.logE("Process Executor cannot get the breakpoints List resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLUIMetaInfo = function() {
	if (this.oComm && this.oUIProc) this.oUIProc.loadMetaInfo(this.oComm);
	else this.oLog.logE("Process Executor cannot get the metainfo without a Process definition");
};

SLUIProcessExecutor.prototype.postSLPBreakPoint = function(sData) {
    if (this.oComm && this.oUIProc && sData ) this.oUIProc.postBreakPoint(this.oComm, sData);
    else this.oLog.logE("Process Executor cannot get the breakpoints List resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPMonitorWithTimer = function() {
    oStub.oFather.oProcExe.pollingActive = true;
    var fastPollCountDn = oStub.oFather.oProcExe.fastPolls;         //local var for countdown in this unique process
    if (typeof pollChecksLog === 'function') pollChecksLog();
    if (this.oComm && this.oUIProc) {
        this.executionSyncTimer = setTimeout(function pollMonitor() {
        	var sState = oStub.oFather.oProcExe.oUIProc.sState;
//        	console.log(sState);										// debug!
        	if (oStub.oFather.oProcExe.repeatMonitor) {
        	    oStub.oFather.oProcExe.repeatMonitor = false;
        		sState = "slp.task.state.RUNNING";
        		oStub.oFather.oProcExe.oUIProc.sState = "slp.task.state.RUNNING";  
        	}
        	
        	if (sState != undefined) {  
                    if (sState === suiCnst.SLP_TASK_STATUS_RUNNING) {
						if (oStub.oFather.oProcExe.oUIProc.oCommDel && oStub.oFather.oProcExe.oUIProc.oCommDel.cleanupTriggered && !oStub.oFather.oProcExe.oUIProc.oCommDel.hasDialog)
							  $.proxy(oStub.oFather.oProcExe.oUIProc.oCommDel.exitPage(), oStub.oFather.oProcExe.oUIProc.oCommDel);
	                    	else oStub.oFather.oProcExe.getSLPMonitor();
                        if (!oStub.oFather.oProcExe.oUIProc.hasRoadMap) oStub.oFather.oProcExe.getSLPRoadMap();
                        if (oStub.oFather.execVwProps[suiCnst.UI_EXEVW_PRP_RODMAP_PULL] === suiCnst.UI_PULL_TYPE_CONTINUAL) oStub.oFather.oProcExe.getSLPRoadMap();
                        if (oStub.oFather.execVwProps[suiCnst.UI_EXEVW_PRP_ACTION_PULL] === suiCnst.UI_PULL_TYPE_CONTINUAL) oStub.oFather.oProcExe.getSLPAction();
                    } else {
                        if (oStub.oFather.oUtil.checkMonitorState(sState, 1)) {
                            oStub.oFather.oProcExe.getSLPError();
                            oStub.oFather.oProcExe.pollingActive = !(oStub.oFather.oProcExe.oUIProc.isDiaRendered); 
                        }
                        else if (oStub.oFather.oUtil.checkMonitorState(sState, 3)) {
                            if (oStub.oFather.oProcExe.oUIProc.isDiaRendered) oStub.oFather.oProcExe.pollingActive = false;
                            else { 
                            	oStub.oFather.oProcExe.getSLPConfig(true);
                            	oStub.oFather.oProcExe.getSLPDialog();
                            }
                        }
                        else if (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_FINISHED) {
                            if (oStub.oFather.execVwProps["displayDialogOnFinish"] == true && !oStub.oFather.oProcExe.oUIProc.isDiaRendered) {
                            	oStub.oFather.oProcExe.getSLPConfig(true);
                            	oStub.oFather.oProcExe.getSLPDialog();
                            }
                            oStub.oFather.oProcExe.getSLPAction();
                            if (oStub.oFather.oProcExe.oUIProc.isDiaRendered) oStub.oFather.oProcExe.pollingActive = false;
                        } 
                        else if (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_SKIPPED) oStub.oFather.oProcExe.pollingActive = false;
                        else if (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_ABORTED) {
                            if (oStub.oFather.execVwProps["useDialogInAbort"] === true) {
                            	oStub.oFather.oProcExe.getSLPConfig(true);
                            	oStub.oFather.oProcExe.getSLPDialog();
                            }
                            else oStub.oFather.oProcExe.pollingActive = false;  	
                        } 
                        else if (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED) oStub.oFather.oProcExe.getSLPAction();
                        else if (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_BREAKPOINT) ; 
                    }
        	}
        	else oStub.oFather.oLogger.logI("Unable to predict the current status of process. Refresh page to retry.");
        	if (oStub.oFather.oProcExe.pollingActive) this.executionSyncTimer = setTimeout(pollMonitor, (fastPollCountDn > 0)? /*"sleepy" mode not yet reached?*/ (fastPollCountDn-- > (oStub.oFather.oProcExe.fastPolls / 2))? /*slowdown limit reached? */ oStub.oFather.oProcExe.timerIntervel : oStub.oFather.oProcExe.timerIntervel*3 : (((typeof pollChecksLog === 'function') ? pollChecksLog() : 0 ), oStub.oFather.oProcExe.timerIntervel*6 /* "sleepy" mode */) );
        }, this.timerIntervel);
    } 
    else this.oLog.logE("Process Executor cannot trigger Monitor resource event without a Process definition");
};

// DIALOGS
SLUIProcessExecutor.prototype.getSLPDialog = function(addData) {
    if (this.oComm && this.oUIProc) this.oUIProc.loadDialog(this.oComm,this.oFather.execVwProps[suiCnst.UI_EXEVW_PRP_USE_METADIALOG], addData);
    else this.oLog.logE("Process Executor cannot trigger SLP Dialog resource without a Process definition");
//	refresh tasklist table (big refresh - with polling data) if visible
	oStub.oFather.getView().vExeStpList.updateContent(true, true);    
};

SLUIProcessExecutor.prototype.getSLPError = function() {
    if (this.oComm && this.oUIProc) {
    	if (!this.oUIProc.isDiaRendered) {	
    		oStub.oFather.oProcExe.getSLPConfig(true);
    		oStub.oFather.oProcExe.getSLPDialog();
        }     
    } 
    else this.oLog.logE("Process Executor cannot trigger SLP Error resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPAction = function() {
    if (this.oComm && this.oUIProc) this.oUIProc.loadActions(this.oComm);
    else this.oLog.logE("Process Executor cannot trigger SLP Action resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPConfig = function(bPreclr) {
    if (this.oComm && this.oUIProc) this.oUIProc.loadConfig(this.oComm, bPreclr);
    else this.oLog.logE("Process Executor cannot trigger SLP Config resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPLogs = function() {
    if (this.oComm && this.oUIProc) this.oUIProc.loadLogs(this.oComm);
    else this.oLog.logE("Process Executor cannot trigger SLP Log resource without a Process definition");
};

SLUIProcessExecutor.prototype.getSLPLogContent = function(sLogID, fnSucc) {
    if (this.oComm && this.oUIProc) this.oUIProc.loadLogContent(sLogID, fnSucc, this.oComm);
    else this.oLog.logE("Process Executor cannot trigger SLP Action resource without a Process definition");
};

// PREPARE CONFIG - for back end consistency check
SLUIProcessExecutor.prototype.checkConfig = function(addData) {
    if (this.oComm && this.oUIProc) this.oUIProc.checkConfigParams(this.oComm, this.checkConfigPostprocess, addData);
    else this.oLog.logE("Process Executor cannot trigger Check Configurations without a Process definition");
};

//PREPARE CONFIG - for back end consistency check
SLUIProcessExecutor.prototype.checkConfigPostprocess = function(dta, addData) {
 	//after config post is finished with success, trigger monitor resource.
	if (addData) {
		oStub.oFather.oProcExe.getSLPMonitor();
		/* is the special situation when a cleanup is done and the tool start required dialog comes up with sState = "FINISHED",
		 * wee need to reload the browser because we cannot get rid of the FINISHED status of the tool.
		 */
		if (($(dta).find("Progress").text()==="0") && (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_FINISHED)) location.reload();
		if (dta != null || dta != undefined) {
			// render Popup
			if (($(dta).find("ValidationStatus") != null) && $(dta).find("ValidationStatus").children().length > 0) {
				bRrslt= false;
				oStub.oFather.oProcExe.oUIProc.valErr = [];
				$.each($(dta).find(suiCnst.SLP_PARAM_NAME),
					function(ind, prm) {
						if (($(prm).find(suiCnst.SLP_PARAM_VAL_RESULT) != null) && $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).children().length > 0) {
							var lenVR = $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).length;
							for (var z = 0; z < lenVR; z++) {
								var oVStatus = $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).children()[z];
								if (oVStatus) oStub.oFather.oProcExe.oUIProc.valErr.push({	paramId : $(prm).find(suiCnst.SLP_COMMON_ID)[0].textContent,
																							status : $(oVStatus).find(suiCnst.SLP_PARAM_VAL_STATUS)[0].textContent,
																							message : $(oVStatus).find(suiCnst.SLP_PARAM_VAL_MESSAGE)[0].textContent });
							}
						}
					}
				);
				oStub.oFather.oProcExe.getSLPDialog();
			} else {
				bRrslt= true; // ok
				oStub.oFather.oProcExe.oUIProc.isDiaRendered = false;
				//empty the dialogs
				oStub.oFather.oProcExe.oUIProc.diaColl = [];
				oStub.oFather.oProcExe.pollingActive = false;
				clearTimeout(oStub.oFather.oProcExe.executionSyncTimer);
				//Config post is success now check for monitor to update the progress details !
				if (oStub.oFather.oProcExe.oUIProc.oCommDel && oStub.oFather.oProcExe.oUIProc.oCommDel.cleanupTriggered && oStub.oFather.oProcExe.oUIProc.oCommDel.cleanupAllowed) $.proxy(oStub.oFather.oProcExe.oUIProc.oCommDel.exitPage(), oStub.oFather.oProcExe.oUIProc.oCommDel);
				else oStub.oFather.oProcExe.getSLPMonitorWithTimer();
			}
		} 
		else oStub.oFather.oProcExe.oUIProc.errComp["configParam"] = undefined;
	}
};

// PREPARE CONFIG - for back end consistency check
SLUIProcessExecutor.prototype._checkForDirtyExecution = function() {
    if (this.oComm && this.oUIProc) return this.oUIProc.diaInDrtyState;
};

// SEQUENCE TIMER
SLUIProcessExecutor.prototype.getSyncTimer = function() {
    if (this.oComm && this.oUIProc) return this.executionSyncTimer;
};
