jQuery.sap.declare(sluiCore.mod.jsrepo);

SLUIProcessRepository = function(sFmt, oComm, oLog) {	
	this.cProcLst = 	undefined;
    if (sFmt != undefined  && sFmt != '') {
        this.sFormat = sFmt;
        if (this.sFormat === suiCnst.UI_DATA_FORMAT_XML) this.cProcLst = new sap.ui.model.xml.XMLModel();
        else if (this.sFormat === suiCnst.UI_DATA_FORMAT_JSON) this.cProcLst = new sap.ui.model.json.JSONModel();
    }
	this.oComm = 		oComm;
	this.oLog = 		oLog;
	this.oFather = 		oStub.oFather;
	this.sData = 		undefined;
    this.leadProc =		undefined;
    this.eadProcId = 	undefined;
    this.errComp = 		{};	
    this.urls= {
        sBaseUrl: 		undefined,
        sProcUrl: 		undefined,
        sProcDefUrl: 	undefined,
        sInstUrl: 		undefined,
        sServiceUrl: 	undefined,
        sExeUrl: 		undefined,
        sStartUrl: 		undefined
    };
};

SLUIProcessRepository.prototype.initialize = function(sBUrl, oMod) {
    var oFather = oStub.oFather;
    var returnPath = window.location.href;
    if (returnPath) returnPath = returnPath.split("?")[0];
    if (returnPath) {
        returnPath = returnPath.replace("slp.html", "");
        returnPath = returnPath.replace("index.html", "");
        if (returnPath.indexOf("suidebug")>-1) {
        	 returnPath = returnPath.replace("suidebug=true", "");
             returnPath = returnPath.replace("suidebug=false", "");
        }
        if (returnPath.indexOf("suihcb")>-1) {
        	 returnPath = returnPath.replace("suihcb=true", "");
             returnPath = returnPath.replace("suihcb=false", "");	
        }
    }
    sBUrl = returnPath + sBUrl;
    this.urls.sBaseUrl = sBUrl;
    // Start : Changes for List to support SLP standard we need a URL context mappig here!
    // prProps.urls.sProcUrl = sBUrl + "/processes"; //Custom Chnages
    // End : Change of List

    if (oFather.homeVwProps[suiCnst.UI_HMEVW_PRP_HOME_MODE] === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_LIST) {
        this.urls.sProcUrl = sBUrl + "/processes";
        this.urls.sServiceUrl = sBUrl + "/services";
    } else if (oFather.homeVwProps[suiCnst.UI_HMEVW_PRP_HOME_MODE] === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_TLIST) {
        this.urls.sProcUrl = sBUrl + "/processes"; // ## COMMENT FOR PRODUCTION
        this.urls.sServiceUrl = sBUrl + "/services";
    } else if (oFather.homeVwProps[suiCnst.UI_HMEVW_PRP_HOME_MODE] === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_GROUP) {
        this.urls.sProcUrl = sBUrl + "/processes"; // ## COMMENT FOR PRODUCTION
        this.urls.sServiceUrl = sBUrl + "/services";
    } else if (oFather.homeVwProps[suiCnst.UI_HMEVW_PRP_HOME_MODE] === suiCnst.UI_HMEVW_PRP_HOME_MODE_TYP_SINGLE) {
        if (oFather.homeVwProps[suiCnst.UI_HMEVW_PRP_STRT_PROC_FROMUI] === true) {
            this.urls.sProcUrl = sBUrl + "/processes";
            this.urls.sServiceUrl = sBUrl + "/services";
        } else {
            this.urls.sProcUrl = sBUrl + "/processes";
            this.urls.sServiceUrl = sBUrl + "/services";
        }
    }
    this.urls.sProcDefUrl = sBUrl;
    this.loadServices();
};

SLUIProcessRepository.prototype.loadServices = function() {
	this.oComm.connect(this.urls.sServiceUrl, null, null, this._loadServiceFailure, this._loadServiceSuccess, null, {slpResourceName: "listCollection"});
};

SLUIProcessRepository.prototype._loadServiceSuccess = function(dta) {
	if (dta) {
		var oUIProcRepo = oStub.oFather.oProcRepo;
		var cServices = $(dta).find("Service");
		for (var pos = 0; pos < cServices.length; pos++) {
			var oService = cServices[pos];
			if (oService) {
				var oProcURL = $(oService).children("processes");
				if (oProcURL && (oProcURL.length>0)) oProcURL = oProcURL[0];
				if (oProcURL) {
					oUIProcRepo.urls.sExeUrl = oProcURL.textContent;
					oUIProcRepo.urls.sStartUrl = oUIProcRepo.urls.sBaseUrl+ "/" + oUIProcRepo.urls.sExeUrl;
				}
			}
		}
		if (oUIProcRepo.urls.sStartUrl) oUIProcRepo.loadAllProcess();
		else oStub.oFather.oLogger.logD("Process URL missing");
	}
	else oStub.oFather.oLogger.logD("Loading services successfully with empty data element");
};


SLUIProcessRepository.prototype._loadServiceFailure = function(errorObj) {
	if (errorObj) oStub.oFather.oProcRepo.errComp[errorObj.slpresourceName] = errorObj;
};


SLUIProcessRepository.prototype.loadAllProcess = function() {
	this.oComm.connect(this.urls.sStartUrl, null, null, this._loadAllProcessFailure, this._loadAllProcessSuccess, null, {slpResourceName:"listCollection"});
};

SLUIProcessRepository.prototype._loadAllProcessSuccess = function(dta) {
	if (dta) {
		var oUIProcRepo = oStub.oFather.oProcRepo;		
		if (oStub.oFather.homeVwProps['defaultStart'] === true) {
			oUIProcRepo.cProcLst.setData(dta);
			oUIProcRepo.sData = dta;
			oUIProcRepo.setDefaultProcessIdSelection();
			oStub.oFather.startProcessExecution();
		} else {
			if (oUIProcRepo.sFormat === suiCnst.UI_DATA_FORMAT_XML) {
				oUIProcRepo.cProcLst.setData(dta);
				oUIProcRepo.sData = dta;
		        oStub.oFather.getView().vProcList.modifyViewContents(1);
		        oUIProcRepo.errComp["listCollection"] = undefined;
		    } else if (oStub.oFather.oProcRepo.sFormat === suiCnst.UI_DATA_FORMAT_JSON) {
		    	oUIProcRepo.cProcLst.setData(dta);
		    	oStub.oFather.getView().vProcList.modifyViewContents(1);
		        oUIProcRepo.errComp["listCollection"] = undefined;
		    }
		}
	}
	else oStub.oFather.oLogger.logD("Loading all processes service is executed successfully with empty data element");
};

SLUIProcessRepository.prototype._loadAllProcessFailure = function(errorObj) {
	if(errorObj) oStub.oFather.oProcRepo.errComp[errorObj.slpresourceName] = errorObj;
};

SLUIProcessRepository.prototype._loadProcessParameter = function(sProcId) {
	var oXMlSer = new XMLSerializer();
	var sUIMode = this.oFather.globProps["uiMode"];
	var postParam = this.oFather.globProps["postUITopology"];
	if (sProcId && this.sData) {
		// I306705
			var cProc = $(this.sData).find("Process");
			for (var pos = 0; pos < cProc.length; pos++) {
				var oProc = cProc[pos];
				if (oProc) {
					var oId = $(oProc).children("id");
					if (oId && oId.length>0) oId = oId[0];
					if (oId) {
						var sId = oId.textContent;
						if (sId && sId === sProcId) {
							if (oProc) {
								var cParams = $(oProc).find("Parameter");
								for (var ppos = 0; ppos < cParams.length; ppos++ ) {
									var oParam = cParams[ppos];
									var oPId = $(oParam).children("id");
									if (oPId && oPId.length>0) oPId = oPId[0];
									var oPValue = $(oParam).children("value");
									if (oPValue && oPValue.length>0) oPValue = oPValue[0];
									if (oPId && (oPId.textContent === "UiTopology") && oPValue) {
												if (sUIMode==="dualStackUpgrade" || postParam === "dualStackUpgrade") oPValue.textContent="DUAL_STACK";
												else oPValue.textContent="JAVA_ONLY";
									}
								}
							}
						}
						sPostXml = oXMlSer.serializeToString(oProc);
						return sPostXml;
					}
					
				}
				
			}
	}
};

SLUIProcessRepository.prototype.getProcessDefinition = function(sProcId) {
    if (this.oComm && sProcId) {
        if (this.oFather) {
        	var postParm = this.oFather.execVwProps["postParameter"];
            var exeURL = this.oFather.execVwProps["executionURL"];
            var exePost = this.oFather.execVwProps["executionWithPost"];
            var sPostXml= "";
            if (exePost) {
            	if (postParm) sPostXml = this._loadProcessParameter(sProcId);
                var oHdr = {
                    HTTP_METHOD_NAME: suiCnst.HTTP_METHOD_POST,
         		   	REQUEST_DATA_TYPE: suiCnst.UI_DATA_FORMAT_XML,
         		   	ACCEPT_DATA_TYPE: suiCnst.HTTP_CNT_TYPE_APP_XML,
         		   	CONTENT_TYPE: "text/xml"
                };
                
                // urls
                if (exeURL && exeURL.trim() !== "") {
                    var kyWd = exeURL.substring(exeURL.indexOf("{"), exeURL.indexOf("}") + 1);
                    if (kyWd && kyWd === "{pid}") exeURL = exeURL.replace("{pid}", sProcId);
                    this.urls.sProcDefUrl = this.urls.sProcUrl + "/" + sProcId;
                    this.oComm.connect(this.urls.sStartUrl, oHdr, null, this._getProcessDefinitionFailure, this._getProcessDefinitionSuccess, sPostXml, {slpResourceName:"startProcess"});
                } else {
                    this.urls.sProcDefUrl = this.urls.sProcUrl + "/" + sProcId;
                    this.oComm.connect(this.urls.sProcDefUrl, oHdr, null, this._getProcessDefinitionFailure, this._getProcessDefinitionSuccess, sPostXml, {slpResourceName:"startProcess"});
                }
            } else {
                this.urls.sProcDefUrl = this.urls.sProcUrl + "/" + sProcId;
                this.oComm.connect(this.urls.sProcDefUrl, null, null, this._getProcessDefinitionFailure, this._getProcessDefinitionSuccess, sPostXml, {slpResourceName:"startProcess"});
            }
        } else {
            this.urls.sProcDefUrl = this.urls.sProcUrl + "/" + sProcId;
            this.oComm.connect(this.urls.sProcDefUrl, null, null, this._getProcessDefinitionFailure, this._getProcessDefinitionSuccess, sPostXml, {slpResourceName:"startProcess"});
        }
    } 
    else this.oLog.logE("Serivce communication could not triggered due to empty communicator object or process ID");
};

SLUIProcessRepository.prototype._getProcessDefinitionSuccess = function(dta) {
	oStub.oFather.oProcRepo._getDefineSelectecdProcess(dta);
    setTimeout(function(){$("#_slui_busyImage_init").remove();}, 1500);
};

SLUIProcessRepository.prototype._getProcessDefinitionFailure = function(errorObj) {
	if (errorObj) oStub.oFather.oProcRepo.errComp[errorObj.slpresourceName] = errorObj;
};

SLUIProcessRepository.prototype.setDefaultProcessIdSelection = function() {
	if (this.cProcLst && ($(this.cProcLst.getData()).find("id").length > 0)) {
		var currentID = $(this.cProcLst.getData()).find("id")[0].textContent;
	    if (currentID) this.leadProcId = currentID;
	}
};

SLUIProcessRepository.prototype._getDefineSelectecdProcess = function(oMod) {
    this.selectedProcess = new SLUIProcessDefinition(this.sFormat, oMod); // SLP based process model
    if (this.selectedProcess && this.oFather) this.oFather.monitorProcessExecution(this.selectedProcess, this.urls.sProcDefUrl);
};
