jQuery.sap.declare(sluiCore.mod.jsact);

SLUIAction = function (dataFormat, data) {
	 this.baseModel = new SLUIBaseModel(dataFormat, data);
	 if(this.baseModel){
	      this.objData =  this.baseModel.getData();
	      this.sDataFormat = this.baseModel.getDataFormat();
	      this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_ACTN_NAME);
	 }
};
SLUIAction.prototype.getType = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_TYPE));
	    } else {
	        return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_ACTN_TYPE);
	    }
	}else{
		return null;
	}
};
SLUIAction.prototype.getId = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        var id = this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID));
	        while (id.indexOf("@") > -1) {
	            id = id.replace("@", "-");
	        }
	        return id;
	
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID);
	    }
	}else{
		return null;
	}
};
SLUIAction.prototype.getName = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_DISP_NAME));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_DISP_NAME);
	    }
	}else{
		return null;
	}
};
SLUIAction.prototype.getDescription = function () {
	if(this.baseModel) {
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_DESC));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_DISP_NAME);
		}
	}else{
		return null;
	}
};
SLUIAction.prototype.isInDialog = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_INDIALOG));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_INDIALOG);
	    }
	}else{
		return null;
	}
};
SLUIAction.prototype.getActive = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return $.parseJSON(this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_ACTIVE)));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ACTN_ACTIVE);
	    }
	}else{
		return null;
	}
};