jQuery.sap.declare(sluiCore.mod.jscnfPrm);

SLUIConfigParameter = function(dataFormat, data, visited, rendered) {
	 this.baseModel = new SLUIBaseModel(dataFormat, data);
	 if(this.baseModel){
	    this.objData =  this.baseModel.getData();
	    this.sDataFormat = this.baseModel.getDataFormat();
	    this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_PARAM_NAME);
	    this.isVisited = visited;
		this.isRedered = rendered;
	 }
};

SLUIConfigParameter.prototype.getId = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_COMMON_ID));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID);
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getRequired = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_REQUIRED));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_REQUIRED);
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getSecure = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_SECURE));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_SECURE);
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getValue = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_VALUE,false,true));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_VALUE);
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getType = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TYPE,false,true));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TYPE);
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getDefaultValue = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_DEFAULT ));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_DEFAULT );
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getDisplayName = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.getDataFormat(),
					objData,suiCnst.SLP_PARAM_DIS_NAME));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_DIS_NAME);
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getStructure = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_STRU,false,true );
			//return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_STRU ));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_STRU );
		}
	 }else{
		 return null;
	 }
}; 
SLUIConfigParameter.prototype.getTupleValue = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TUP_VAL,false,true );
			//return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TUP_VAL ));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TUP_VAL );
		}
	 }else{
		 return null;
	 }
};
SLUIConfigParameter.prototype.getTableValue = function() {
	 if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TBL_VAL,false,true );
			//return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TBL_VAL,false,true));
		} else {
			return this.baseModel.dataLookUp(this.tData,suiCnst.SLP_PARAM_TBL_VAL );
		}
	 }else{
		 return null;
	 }
};