jQuery.sap.declare(sluiCore.mod.jsdia);

SLUIDialog = function(dataFormat, data, visited, rendered) {
	 this.baseModel = new SLUIBaseModel(dataFormat, data);
	 if(this.baseModel){
	     this.objData =  this.baseModel.getData();
	     this.sDataFormat = this.baseModel.getDataFormat();
	     this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_DIA_NAME);
	     this.isVisited = visited;
	     this.isRedered = rendered;
	 }
}; 
SLUIDialog.prototype.getId = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID);
		}
	}else{
		return null;
	}
};
SLUIDialog.prototype.getDialogName = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_DIA_DIAG_NAME));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_DIA_DIAG_NAME);
		}
	}else{
		return null;
	}
};
SLUIDialog.prototype.getDialogHeader = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return new SLUIDialogHeader(this.sDataFormat, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_DIA_HDR_NAME));
		} else {
			return new SLUIDialogHeader(this.sDataFormat, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_DIA_HDR_NAME));
		}
	}else{
		return null;
	}
};
SLUIDialog.prototype.getDialogBody = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return new SLUIDialogBody(this.sDataFormat, this.baseModel.dataLookUp(this.tData,suiCnst.SLP_DIA_BODY_NAME));
		} else {
			return new SLUIDialogBody(this.baseModel.dataLookUp(this.tData,suiCnst.SLP_DIA_BODY_NAME));
		}
	}else{
		return null;
	}
};
SLUIDialog.prototype.getDocDB = function() {
	if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData , suiCnst.SLP_DIA_DOC_DB));
		} else {
			return this.baseModel.dataLookUp(this.tData , suiCnst.SLP_DIA_DOC_DB);
		}
	}else{
		return null;
	}
};
SLUIDialog.prototype.getDocOpt = function() {
	if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData , suiCnst.SLP_DIA_DOC_OPT));
		} else {
			return this.baseModel.dataLookUp(this.tData , suiCnst.SLP_DIA_DOC_OPT);
		}
	}else{
		return null;
	}
};
SLUIDialog.prototype.getDocRef = function() {
	if(this.baseModel){
		if (this.sDataFormat=== suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData , suiCnst.SLP_DIA_DOC_REF));
		} else {
			return this.baseModel.dataLookUp(this.tData , suiCnst.SLP_DIA_DOC_REF);
		}
	}else{
		return null;
	}
};