jQuery.sap.declare("slui.modules.model.protocolModel.DialogBody");

SLUIDialogBody = function(dataFormat, data) {
	this.baseModel = new SLUIBaseModel(dataFormat, data);
	if(this.baseModel){
	   this.objData =  this.baseModel.getData();
	   this.sDataFormat = this.baseModel.getDataFormat();
	   this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_DIA_BODY_NAME,true);
	}
};
SLUIDialogBody.prototype.getGroupViews = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_DIA_UI_GRP_VW);
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_DIA_UI_GRP_VW);
		}
	}else{
		return 0;
	}
};
SLUIDialogBody.prototype.getGroupsViewLength = function() {
	return this.getGroupViews().length;
};
SLUIDialogBody.prototype.getGroupsViewAt = function(index) {
	var grpCollection = this.getGroupViews();
	if (grpCollection && grpCollection.length > 0 && index > -1) {
		return grpCollection[0];
	}
};