jQuery.sap.declare(sluiCore.mod.jsprocDef);

SLUIProcessDefinition = function(dataFormat, data) {
	this.baseModel = new SLUIBaseModel(dataFormat, data);
	if(this.baseModel){
	   this.objData =  this.baseModel.getData();
	   this.sDataFormat = this.baseModel.getDataFormat();
	   this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_PROCESS_DEF_NAME);
	}
};
SLUIProcessDefinition.prototype.getId = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID);
		}
	}else{
		return null;
	}
};
SLUIProcessDefinition.prototype.getDescription = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_DESC));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_DESC);
		}
	}else{
		return null;
	}
	
};
