jQuery.sap.declare(sluiCore.mod.jstask);

SLUITask = function (dataFormat, data) {
    this.baseModel = new SLUIBaseModel(dataFormat, data);
    if(this.baseModel){
       this.objData =  this.baseModel.getData();
       this.sDataFormat = this.baseModel.getDataFormat();
       this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_TASK_NAME);
    }
 };
SLUITask.prototype.getDescription = function () {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_DESC));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_DESC);
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.getName = function () {	
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
    		return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_DISP_NAME));
    	} else {
        	return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_DISP_NAME);
    	}
	}else{
		return null;
	}
};
SLUITask.prototype.getSelected = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, "selected"));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, "selected");
	    }
	}else{
		return null;
	}
	    
};
SLUITask.prototype.getId = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        var id = this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID));
	        while (id.indexOf("@") > -1) {
	            id = id.replace("@", "-");
	        }
	        return id;
	
	    } else {
	        var id = this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID);
	        while (id.indexOf("@") > -1) {
	            id = id.replace("@", "-");
	        }
	        return id;
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.getTechnicalName = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_TECH_NAME));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_TECH_NAME);
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.getType = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_TYPE));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_TYPE);
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.getStatus = function () {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_STATUS));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_STATUS);
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.setStatus = function (status) {
	if(this.baseModel){
	    if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel._setXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_STATUS), status);
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_STATUS);
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.getProgress = function () {
	if(this.baseModel){  
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_PROGRESS));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_PROGRESS);
	    }
	}else{
		return null;
	}
};
SLUITask.prototype.getProgressMessage = function () {
	if(this.baseModel){   
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_PROG_MSG));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_PROG_MSG);
	    }
	}else{
		return null;
	}	
};

SLUITask.prototype.getError = function () {
	if(this.baseModel){   
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData,"error"));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, "error");
	    }
	}else{
		return null;
	}	
};

SLUITask.prototype.getRefreshRate = function () {
	if(this.baseModel){    
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
	        return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_REFRESH_RATE));
	    } else {
	        return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_TASK_REFRESH_RATE);
	    }
	}else{
		return null;
	}
};