jQuery.sap.declare(sluiCore.mod.jsproc);

// SL UI Process object should not use father object - make use of local reference !
SLUIProcess = function(oProcDef, sRUrl, sFormat, cAdapt) {
	this.initialize();
	if (oProcDef && sRUrl) {
		this.dtaformat = sFormat;
		this.urls.rootURL = sRUrl;
		this.urls.stackType = suiCnst.PROC_STACK_TYPE_UNKNOWN;
		this.urls.procInstId = sRUrl.substr(suiCnst.SLP_URL_SEARCH_PATTERN.length, sRUrl.lastIndexOf("/") - suiCnst.SLP_URL_SEARCH_PATTERN.length);
		this.urls.stackType = suiCnst.PROC_STACK_TYPE_ABAP;                        
		this.urls.configUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_CONFIG;
		this.urls.actionsUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_ACTIONS;
		this.urls.tasklistUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_TASK_LIST;
		this.urls.monitorUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_MONITOR;
		this.urls.dialogsUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_DIALOGS;
		this.urls.errorsUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_ERRORS;
		this.urls.procMsgUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_PROGRESS_MESSAGES;
		this.urls.rootTaskUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_TASK_LIST + "/" + this.urls.procInstId;
		this.urls.roadMapUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_ROADMAP;
		this.urls.logsUrl = this.urls.rootURL + "/" + suiCnst.SLP_RESOURCE_LOGS;
		this.urls.errorsUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_ERRORS;
		this.urls.brkPntsUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_BREAKPOINTS;
		this.urls.fsEntriesUrl = this.urls.rootURL + "/"+ suiCnst.SLP_RESOURCE_FSENTRIES;
		this.urls.metaInfoUrl = window.location.href.split("?")[0]+ "slui/slui.metainfo.xml";
		this.urls.doResetUrl = this.urls.rootURL + "/"+ suiCnst.NONSLP_RESOURCE_IMMRESET;
		this.adapColl = cAdapt;
	} 
	else oStub.oFather.oLogger.logD("Unable to initialize the SL UI process reference Object due to missing base url or delegation object");
};

SLUIProcess.prototype.initialize = function() {
	// initialize all variables of this as instance variable
	// initialize all URL manipulators
	this.urls = {
		rootURL : 		undefined,
		procInstId : 	undefined,
		stackType : 	undefined,
		configUrl : 	undefined,
		actionsUrl : 	undefined,
		tasklistUrl : 	undefined,
		monitorUrl : 	undefined,
		dialogsUrl : 	undefined,
		errorsUrl : 	undefined,
		procMsgUrl : 	undefined,
		rootTaskUrl : 	undefined,
		roadMapUrl : 	undefined,
		brkPntsUrl : 	undefined,
		metaInfoUrl: 	undefined,
		doResetUrl: 	undefined
	};
	// flags
	this.rule = 			undefined;
	this.hasActions = 		false;
	this.hasRoadMap = 		false;
	this.diaInDrtyState = 	false;
	this.isDiaRendered = 	false;
	this.isActionRendered = false;
	this.preClearConfig = 	false;
	this.metaDialog = 		false;
	this.resettable = 		undefined;
	this.resetTriggered = 	undefined;
	// slp return
	this.actions = 			[];
	this.roadMaps = 		[];
	this.tskLstRef = 		[];
	this.curMonTskLst = 	[];
	this.diaParamMap = 		{};
	this.diaColl = 			[];
	this.valErr = 			[];
	this.paramInDrtState = 	[];
	this.configParams = 	[];
	this.errElm = 			[];
	this.roadMapTask = 		undefined;
	this.processTask = 		undefined;
	this.stepTask = 		undefined;
	// non slp
	this.adapColl = 		[];
	this.curDiaRes = 		undefined;
	this.logLst = 			undefined;
	this.tskLst = 			undefined;
	this.brkLst = 			undefined;
	this.oProcDef = 		undefined;
	this.metaInfoXml = 		undefined;
	this.sState = 			undefined;
	this.sError = 			undefined;
	this.currentError = 	undefined;
	this.errComp = 			{};
	this.aMetaURL = 		[];
	this.oFather = 			oStub.oFather;
	
	this.reTrigger();
};

SLUIProcess.prototype.getID = function() {
	return this.procInstId;
};

SLUIProcess.prototype.reTrigger = function() {
	this.triggerd = {
		cnfg: 		false,
		cnfgPst:	false,
		actn: 		false,
		actnPst: 	false,
		tsklst: 	false, 
		brkPnt:		false,
		log:		false,
		logCnt:		false,
		rdmap:		false,
		mon:		false,
		dlg:		false
	};
};

SLUIProcess.prototype.conditionalReTrigger = function(bRdMp, bMon, bCnf, bDia, bAcn) {
	if (bRdMp) this.triggerd.rdmap=false;
	if (bMon) this.triggerd.mon = false;
	if (bCnf) {this.triggerd.cnfg = false; this.triggerd.cnfgPst = false;}
	if (bDia) this.triggerd.dlg = false;
	if (bAcn) {this.triggerd.actn = false; this.triggerd.actnPst = false;}
};

SLUIProcess.prototype._loadResourceFailure = function(errorObj) {
	if (errorObj) {
		oStub.oFather.oProcExe.oUIProc.currentError  = errorObj;
		oStub.oFather.oProcExe.oUIProc.reTrigger();
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_SERVICE_ERROR);	//UI_VW_UPDATE_ROADMAP);
	}
	else oStub.oFather.oLogger.logD("Unable to use Error object to display error infomration");
};
        
SLUIProcess.prototype._loadLogFailure = function(errorObj) {
	if (errorObj) {
		oStub.oFather.oProcExe.oUIProc.currentError  = errorObj;
		oStub.oFather.oProcExe.oUIProc.reTrigger();
		oStub.oFather.updateView(suiCnst.UI_VW_GET_LOG_WARNING);
	}
	else oStub.oFather.oLogger.logD("Unable to use Error object to display error infomration");
};

// load road map resource of a process
SLUIProcess.prototype.loadRoadMap = function(oComm) {
	if (oComm && !this.triggerd.rdmap) {
		oComm.connect(this.urls.roadMapUrl, null, null, this._loadResourceFailure, this._loadRoadMapSuccess, null, {slpResourceName:suiCnst.SLP_RESOURCE_ROADMAP});	
		this.triggerd.rdmap = true;
	}
	else oStub.oFather.oLogger.logD("Unable to load roadmap resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadRoadMapSuccess = function(dta, addData) {
	if (dta) {
		var oUIProcDel = oStub.oFather.oProcExe.oUIProc;
		var tRdmp, oSteps, cCmpr = [];
		oUIProcDel.roadMaps = [];
		$.each($(dta).find(suiCnst.SLP_TASK_NAME), function(ind, tsk) {
			oUIProcDel.roadMaps.push(new SLUITask(oUIProcDel.dtaformat, tsk));
		});
		if (oUIProcDel.roadMaps.length < 1) oUIProcDel.hasRoadMap = false;
		else oUIProcDel.hasRoadMap = true;
		oUIProcDel.errComp[suiCnst.SLP_RESOURCE_ROADMAP] = undefined;		
		tRdmp = sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vExeStus.progRdMap;
		oSteps = tRdmp.getSteps();
		for (var indx = 0; indx < oSteps.length; indx++) if (oSteps[indx].getLabel()) cCmpr.push(oSteps[indx].getLabel());
		//view updates 
		// compare and clear the roadmap if new roadmap is present
		for (var indxj = 0; indxj < oUIProcDel.roadMaps.length; indxj++) if (cCmpr.indexOf(oUIProcDel.roadMaps[indxj].getName()) < 0) {tRdmp.destroySteps(); break;}
		oUIProcDel.triggerd.rdmap = false;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_ROADMAP, addData);
	}
	else oStub.oFather.oLogger.logD("Roadmap resource loaded successfully with empty data element");
};

//SLUI METAINFO
SLUIProcess.prototype.loadMetaInfo = function(oComm) {
	oComm.connect(this.urls.metaInfoUrl, null, null, this._loadResourceFailure, this._loadMetaInfoSuccess, null, {});
};

SLUIProcess.prototype._loadMetaInfoSuccess = function(dta) {
	if (dta) {
		oStub.oFather.oProcExe.oUIProc.metaInfoXml = dta;
		oStub.oFather.updateView(suiCnst.UI_VW_ABOUT, dta);
	}
	else oStub.oFather.oLogger.logD("Metainfo loaded successfully with empty data element");
};

//MONITOR INFO OF A PROCESS
SLUIProcess.prototype.loadMonitor = function(oComm) {
	if (oComm && !this.triggerd.mon) {
		oComm.connect(this.urls.monitorUrl, null, null,  this._loadResourceFailure, this._loadMonitorSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_MONITOR});
		this.triggerd.mon  = true;			
	}
	else oStub.oFather.oLogger.logD("Unable to load monitor resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadMonitorSuccess = function(dta, addData) {
	if (dta) {
		var oUIProcDel = oStub.oFather.oProcExe.oUIProc;
		oUIProcDel.curMonTskLst = [];
		$.each($(dta).find(suiCnst.SLP_TASK_NAME), function(index, tsk) {
			oUIProcDel.curMonTskLst.push(new SLUITask(oUIProcDel.dtaformat, tsk));
		});
		// switch filter for Task List on/off according to GLOBALMODE; if RESET is running ==> full Tasklist
		oStub.oFather.execVwProps["showRoadMapBasedTaskList"] = ($(dta).find("globalmode").text().indexOf("RESET") < 0); 
		oUIProcDel.triggerd.mon = false;
		oUIProcDel.errComp[suiCnst.SLP_RESOURCE_MONITOR] = undefined;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_MONITOR, addData);
	}
	else oStub.oFather.oLogger.logD("Monitor resource loaded successfully with empty data element");
};

// CONFIG resource of a process
SLUIProcess.prototype.loadConfig = function(oComm, bPreClear) {
	if (oComm && !this.triggerd.cnfg) {
		oComm.connect(this.urls.configUrl, null, null,  this._loadResourceFailure, this._loadConfigSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_CONFIG});
		this.preClearConfig = bPreClear;
		this.triggerd.cnfg = true;
	}
	else oStub.oFather.oLogger.logD("Unable to load config resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadConfigSuccess = function(dta) {
	if (dta) {
		if (oStub.oFather.oProcExe.oUIProc.preClearConfig) {
		    oStub.oFather.oProcExe.oUIProc.configParams = [];
			var sCnfgDta = $(dta).children("config");
			if (sCnfgDta) {
				$.each($(sCnfgDta).children(suiCnst.SLP_PARAM_NAME),
						function(ind, prm) {
							var cnfprm = new SLUIConfigParameter(oStub.oFather.oProcExe.oUIProc.dtaformat, prm);
							oStub.oFather.oProcExe.oUIProc.configParams.push(cnfprm);
							if ((oStub.oFather.oProcExe.oUIProc.diaParamMap[cnfprm.getId()] != undefined && oStub.oFather.oProcExe.oUIProc.diaParamMap[cnfprm.getId()].uiId == undefined)|| 
								oStub.oFather.oProcExe.oUIProc.diaParamMap[cnfprm.getId()] == undefined) 
							    		oStub.oFather.oProcExe.oUIProc.diaParamMap[cnfprm.getId()] = {uiId: "", value: "", uiAttrMap: null, currentValue: ""};								
						});
			}
		}
		oStub.oFather.oProcExe.oUIProc.valErr = [];
		$.each($(dta).find(suiCnst.SLP_PARAM_NAME),
			function(ind, prm) {
				if (($(prm).find(suiCnst.SLP_PARAM_VAL_RESULT) != null)&& $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).children().length > 0) {
					var lenVR = $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).length;
					for (var z = 0; z < lenVR; z++) {
						var oVStatus = $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).children()[z];
						if (oVStatus) {
						    oStub.oFather.oProcExe.oUIProc.valErr.push({
								paramId : $(prm).find(suiCnst.SLP_COMMON_ID)[0].textContent,
								status : $(oVStatus).find(suiCnst.SLP_PARAM_VAL_STATUS)[0].textContent,
								message : $(oVStatus).find(suiCnst.SLP_PARAM_VAL_MESSAGE)[0].textContent});
						}
					}
				}
			}
		);
		oStub.oFather.oProcExe.oUIProc.triggerd.cnfg = false;
		oStub.oFather.oProcExe.oUIProc.errComp[suiCnst.SLP_RESOURCE_CONFIG] = undefined;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_CONFIG);
	}
	else oStub.oFather.oLogger.logD("Config resource loaded successfully with empty data element");
};

//Load dialog object from backend 
SLUIProcess.prototype.loadDialog = function(oComm, bMetaDia, addData) {
	if (oComm && !this.triggerd.dlg) {
		this.metaDialog = bMetaDia;
		this.oCommDel = oComm;
		this.triggerd.dlg = true;
		oComm.connect(this.urls.dialogsUrl, null, null, this._loadResourceFailure, this._loadDialogSucess, null, {slpResourceName: suiCnst.SLP_RESOURCE_DIALOG});
	}
	else oStub.oFather.oLogger.logD("Unable to load dialog resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadDialogSucess = function(dta, addData) {
	if (dta) {
		var adapter = oStub.oFather.oProcExe.oUIProc._getAdapter("/dialogs");
		if (oStub.oFather.oProcExe.oUIProc.metaDialog && dta) {
			oStub.oFather.oProcExe.oUIProc.aMetaURL = [];   
			for (var i=0; i < ($(dta).find(suiCnst.SLP_DIA_METADIALOG)).length; i++) oStub.oFather.oProcExe.oUIProc.aMetaURL.push($(dta).find(suiCnst.SLP_DIA_METADIALOG)[i].textContent);
			var aURI = oStub.oFather.oProcExe.oUIProc.aMetaURL[0];
			if (aURI) {
				if (adapter) {
					if (adapter.sURLPattern) oStub.oFather.oProcExe.oUIProc.loadMetaDialog(oStub.oFather.oProcExe.oUIProc.urls.dialogsUrl + "/" + aURI+ adapter.sURLPattern, addData);
					else oStub.oFather.oProcExe.oUIProc.loadMetaDialog(oStub.oFather.oProcExe.oUIProc.urls.dialogsUrl + "/" + aURI, addData);
				} 
				else oStub.oFather.oProcExe.oUIProc.loadMetaDialog(oStub.oFather.oProcExe.oUIProc.urls.dialogsUrl + "/" + aURI, addData);
			}
		}
		oStub.oFather.oProcExe.oUIProc.triggerd.dlg = false;
	} 
	else oStub.oFather.oLogger.logD("Dialog resource loaded successfully with empty data element");
};

SLUIProcess.prototype.loadMetaDialog = function(sURL, addData) {
	if (sURL) {
		oStub.oFather.oProcExe.oUIProc.oCommDel = oStub.oFather.oProcExe.oComm;
		if (addData) addData.slpResourceName=suiCnst.SLP_RESOURCE_DIALOG;
		oStub.oFather.oProcExe.oUIProc.oCommDel.connect(sURL, null, null, this._loadResourceFailure, this._loadMetaDialogSucess, null, addData);
	}
	else oStub.oFather.oLogger.logD("unable to load meta dialog due to missing URL reference");
};

SLUIProcess.prototype._loadMetaDialogSucess = function(dta, addData) {
	if (dta) {
		var adapter = oStub.oFather.oProcExe.oUIProc._getAdapter("/dialogs");
		if (adapter) {
			if (dta.userMessage === undefined) {
				if (this.rule === undefined) this.rule = oStub.oFather.oProcExe.oUIProc._loadAdapterRule(adapter.sRulePath);
				dta = oStub.oFather.oProcExe.oUIProc._applyAdapterRule(dta, this.rule);
				//after applying the rule.
				if (typeof dta === "string") oStub.oFather.oLogger.logD(dta); else oStub.oFather.oLogger.logD(new XMLSerializer().serializeToString(dta));
				oStub.oFather.oProcExe.oUIProc.errComp[suiCnst.UI_RESOURCE_ADAPTER] = undefined;
			} 
			else oStub.oFather.oProcExe.oUIProc.errComp[suiCnst.UI_RESOURCE_ADAPTER] = dta;
		}
		oStub.oFather.oProcExe.oUIProc.diaColl = [];
		if (typeof dta === "string") dta = $.parseXML(dta);
		$.each($(dta).find(suiCnst.SLP_DIA_NAME), function(ind, dia) {
		    oStub.oFather.oProcExe.oUIProc.diaColl.push(new SLUIDialog(oStub.oFather.oProcExe.oUIProc.dtaformat, dia, false, false));
		});
		//after view update trigger action resource
		oStub.oFather.oProcExe.getSLPAction();
		oStub.oFather.oProcExe.oUIProc.errComp[suiCnst.SLP_RESOURCE_DIALOGS] = undefined;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_DIALOG, addData);		
	}
	else oStub.oFather.oLogger.logD("Meta Dialog resource loaded successfully with empty data element");
};

//ACTIONS AVALIBLE FOR A TASK
SLUIProcess.prototype.loadActions = function(oComm) {
	if (oComm && !this.triggerd.actn) {
		if (oStub.oFather.oProcExe.oUIProc) {
		    oStub.oFather.oProcExe.oUIProc.actions = [];
		    oStub.oFather.oProcExe.oUIProc.isActionRendered = false;
		}
		oComm.connect(this.urls.actionsUrl, null, null, this._loadResourceFailure, this._loadActionsSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_ACTION});
		this.triggerd.actn= true;
	}
	else oStub.oFather.oLogger.logD("Unable to load actions resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadActionsSuccess = function(dta) {
	if (dta) {
		oStub.oFather.oProcExe.oUIProc.actions = [];
		$.each($(dta).find(suiCnst.SLP_ACTN_NAME), function(ind, act) {
		    oStub.oFather.oProcExe.oUIProc.actions.push(new SLUIAction(oStub.oFather.oProcExe.oUIProc.dtaformat, act));
		});
		oStub.oFather.oProcExe.oUIProc.hasActions = true;
		oStub.oFather.oProcExe.oUIProc.triggerd.actn = false;
		oStub.oFather.oProcExe.oUIProc.errComp[suiCnst.SLP_RESOURCE_ACTIONS] = undefined;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_ACTION);
	}
	else oStub.oFather.oLogger.logD("Actions resource loaded successfully with empty data element");
};

SLUIProcess.prototype.invokeAction = function(atnId, oComm) {
	if (oComm && !this.triggerd.actnPst) {
		var hdrObj = {	HTTP_METHOD_NAME : suiCnst.HTTP_METHOD_POST,
						REQUEST_dta_TYPE : suiCnst.UI_DATA_FORMAT_XML };
		oComm.connect(this.urls.actionsUrl + "/" + atnId, hdrObj, null, this._loadResourceFailure, null, null, {slpResourceName: suiCnst.SLP_RESOURCE_ACTIONS});
	}
	else {
		if(atnId) oStub.oFather.oLogger.logD("Unable to trigger with action ("+atnId+") on actions monitor resource in UI Process object due to empty communicator object");
		else oStub.oFather.oLogger.logD("Unable to trigger with unkown action (no id ) on actions monitor resource in UI Process object due to empty communicator object");
	}
};

//START ACTION
SLUIProcess.prototype.triggerAction = function(oComm, aName) {
	if (this.actions && aName != null && aName != '' && oComm) {
		var canBeStarted = false;
		$.each(this.actions, function(index, act) {
			if (act.getId() === aName) canBeStarted = true;
		});
		if (!canBeStarted) oStub.oFather.oLogger.logE("Process Cannot be Started! - Start Action Not found");
	}
};

//load tasklist 
//GET ENTIRE TASK LIST OF A PROCESS
SLUIProcess.prototype.loadTasklist = function(oComm) {
	if (oComm && !this.triggerd.tsklst) {
		oComm.connect(this.urls.tasklistUrl, null, null, this._loadResourceFailure, this._loadTasklistSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_TASKLIST});	
		this.triggerd.tsklst = true;
	}
	else oStub.oFather.oLogger.logD("Unable to load monitor resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype.loadTasklistByRoadMapId = function(oComm,roadMapId) {
	if (oComm && !this.triggerd.tsklst) {
		oComm.connect(this.urls.tasklistUrl+"/"+roadMapId, null, null, this._loadResourceFailure, this._loadTasklistSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_TASKLIST});	
		this.triggerd.tsklst = true;
	}
	else oStub.oFather.oLogger.logD("Unable to load monitor resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadTasklistSuccess = function(dta) {
	if (dta) {
		if (!oStub.oFather.oProcExe.oUIProc.tskLst) {
			if (oStub.oFather.oProcExe.oUIProc.dtaformat === suiCnst.UI_DATA_FORMAT_XML) oStub.oFather.oProcExe.oUIProc.tskLst = new sap.ui.model.xml.XMLModel();
			else if (oStub.oFather.oProcExe.oUIProc.dtaformat === suiCnst.UI_DATA_FORMAT_JSON) oStub.oFather.oProcExe.oUIProc.tskLst = new sap.ui.model.json.JSONModel();
		}
		if (oStub.oFather.execVwProps.taskListFromJson) {
		    globals.abapTasklistModel = new sap.ui.model.json.JSONModel();
		    globals.abapTasklistModel.setSizeLimit(10000);
		    var jsonDta = slpxml2json(dta);
		    globals.abapTasklistModel.setData(jsonDta);
		    oStub.oFather.oProcExe.oUIProc.triggerd.tsklst = false;
		}
		else {                    
		    oStub.oFather.oProcExe.oUIProc.tskLst.setSizeLimit(10000);
		    oStub.oFather.oProcExe.oUIProc.tskLst.setData(dta);
		    oStub.oFather.oProcExe.oUIProc.triggerd.tsklst = false;
		}	
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_TASKLIST);
	}
	else oStub.oFather.oLogger.logD("Tasklist resource loaded successfully with empty data element");
};

//## NEED TO BE REVIVED 
SLUIProcess.prototype.checkConfigParams = function(oComm, fnHandler, addData) {
	if (oComm) {
		var xml = "<config xmlns=\"http:\/\/www.sap.com/lmsl/slp\">";  
		for (var x = 0; x < this.configParams.length; x++) {
			var param = this.configParams[x];
			var sUqId = this.diaParamMap[param.getId()].uiId;

			if (!addData) {
				if ((sUqId != null) && (sUqId != undefined) && (sUqId != "")) {
					if (sUqId.indexOf("_slui_valSelGrp_") > -1) { 													// value selector
						if (sUqId.indexOf("_slui_valSelGrp_dropDown_") > -1) this.diaParamMap[param.getId()].value = sap.ui.getCore().byId(sUqId).getSelectedKey();  
						else if (sUqId.indexOf("_slui_valSelGrp_checkBtn_") > -1) this.diaParamMap[param.getId()].value = sap.ui.getCore().byId(sUqId).getChecked(); 
						else if (sUqId.indexOf("_slui_valSelGrp_radioBtn_") > -1) this.diaParamMap[param.getId()].value = sap.ui.getCore().byId(sUqId).getSelectedItem().getKey(); 
						else {
							if (sap.ui.getCore().byId(sUqId).selectedValue) this.diaParamMap[param.getId()].value = sap.ui.getCore().byId(sUqId).selectedValue;
							else this.diaParamMap[param.getId()].value = "";
						}
						xml += this. _prepareParamXML(param, this.diaParamMap[param.getId()].value);
					} 
					else if (sUqId.indexOf("_slui_table") > -1) {
						var sXMLValue = "";
						var sTblXMLData = sap.ui.getCore().byId(sUqId).getModel().getData();
						var cnfTblVal = param.getTableValue(); 
						var tupColl = cnfTblVal.children();
						var struct = param.getStructure();
						var rows = sTblXMLData.firstChild.childNodes;
						var oUIProcDel = oStub.oFather.oProcExe.oUIProc;
						if (cnfTblVal && rows && tupColl) {
							if (rows.length == tupColl.length) {
								for (var tupCnt = 0; tupCnt < tupColl.length; tupCnt++) {
									var tuple = tupColl[tupCnt];
									var tPrms = $(tuple).find("Parameter");
									var rowChilds = rows[tupCnt].childNodes;
									sXMLValue += "<Tuple><id>" + tuple.childNodes[0].textContent + "</id><value>";
									if (tPrms && tPrms.length>0) 
										for (var t=0; t < tPrms.length; t++) {
											var prm=tPrms[t];
											var id = $(prm).find("id")[0].textContent;
											var value = this._getValFromTable(rowChilds, id);
											var cnfprm = new SLUIConfigParameter(oUIProcDel.dtaformat, prm);
											sXMLValue = sXMLValue + this._prepareParamXML(cnfprm, value);
										}
									sXMLValue += "</value></Tuple>";
								}
							}
							else {
								var start = 1;
								if (rows.length<tupColl.length) start = 1;
								else if (rows.length>tupColl.length) start = tupColl.length+1;
								var idCount = 1;
								for (var tupCnt = 0; tupCnt<rows.length; tupCnt++) {
									var row = rows[tupCnt];
									var tPrms = $(struct).find("Parameter");
									var rowChilds = rows[tupCnt].childNodes;
									//sXMLValue += "<Tuple><id>" + tupCnt + "</id><value>";
									sXMLValue += "<Tuple><id>" + idCount + "</id><value>";
									if (tPrms && tPrms.length>0) 
										for (var t=0; t < tPrms.length; t++) {
											var prm=tPrms[t];
											var id = $(prm).find("id")[0].textContent;
											var value = this._getValFromTable(rowChilds, id);
											var cnfprm = new SLUIConfigParameter(oUIProcDel.dtaformat, prm);
											sXMLValue = sXMLValue + this._prepareParamXML(cnfprm, value);
										}
									sXMLValue += "</value></Tuple>";
									idCount++;
								}
							}
						}
						xml += this._prepareParamXML(param,sXMLValue);
					} 
					else { 																							// normal text params.
						this.diaParamMap[param.getId()].value = sap.ui.getCore().byId(sUqId).getValue();
						xml += this._prepareParamXML(param, this.diaParamMap[param.getId()].value);
					}
				}
				else xml += this._prepareParamXML(param,"");
			} 
		}
		xml += "</config>"; // </parameters>
		oStub.oFather.oLogger.logD("--------------------------------------------------------------");
		oStub.oFather.oLogger.logD("CONFIG POST Request  | At : " + new Date());
		oStub.oFather.oLogger.logD(xml);
		oStub.oFather.oLogger.logD("--------------------------------------------------------------");
		var requestHdrObj = {	HTTP_METHOD_NAME : suiCnst.HTTP_METHOD_POST,
								REQUEST_DATA_TYPE : suiCnst.UI_DATA_FORMAT_XML,
								ACCEPT_DATA_TYPE : suiCnst.HTTP_RESP_TYPE_APP_XML,
								CONTENT_TYPE : suiCnst.HTTP_CNT_TYPE_APP_XML		};
		oComm.connect(this.urls.configUrl, requestHdrObj, null, this._loadResourceFailure,fnHandler, xml, {slpResourceName: suiCnst.SLP_RESOURCE_CONFIG});
	} 
	else oStub.oFather.oLogger.logD("Unable to post config data on config resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._getValFromTable = function(rowChilds, id) {
	if (rowChilds && id) for (var y=0; y < rowChilds.length; y++) if ((rowChilds[y].tagName != null) && (rowChilds[y].tagName != undefined) && (rowChilds[y].tagName != "") && (rowChilds[y].tagName === id)) return rowChilds[y].textContent;
};

SLUIProcess.prototype._prepareParamXML = function(param, value) {
	var xml = "<Parameter>";
	if (param.getId()) xml += "<id>"+param.getId()+ "</id>"; 
	if (param.getType()) xml += "<type>"+param.getType()+ "</type>";
	if (param.getDefaultValue()) xml += "<default>"+htmlEncode(param.getDefaultValue())+"</default>";
	if (param.getRequired()) xml += "<required>"+param.getRequired()+"</required>";
	if (param.getSecure()) xml += "<secure>"+param.getSecure()+"</secure>";
	
	if (param.getType()===suiCnst.SLP_PARAM_TYPE_SCALAR) {
		if (value) 	xml += "<value>"+htmlEncode(value)+"</value>";
		else 		xml += "<value></value>";
		if (param.getStructure()) 	xml += "<structure>"+param.getStructure().text()+"</structure>";
		else 						xml += "<structure></structure>";
		if (param.getTupleValue()) 		xml += "<tuplevalue>"+param.getTupleValue().text()+"</tuplevalue>";
		else 							xml += "<tuplevalue></tuplevalue>";
		if (param.getTableValue()) 	xml += "<tablevalue>"+param.getTableValue().text()+"</tablevalue>";
		else 						xml += "<tablevalue></tablevalue>";
	} else if (param.getType()===suiCnst.SLP_PARAM_TYPE_TABLE) {
		if (param.getValue()) 	xml += "<value>"+htmlEncode(param.getValue())+"</value>";
		else 					xml += "<value></value>";
		if (param.getStructure())
		{
			var xmlsr = new XMLSerializer();
			var dta = param.getStructure();
			if (dta && dta.length>0) {
				dta = dta[0];	
				xml += xmlsr.serializeToString(dta);
			}			
		} 
		else xml += "<structure></structure>";
		if (param.getTupleValue()) 	xml += "<tuplevalue>"+param.getTupleValue().text()+"</tuplevalue>";
		else 						xml += "<tuplevalue></tuplevalue>";
		if (value) 	xml += "<tablevalue>"+value+"</tablevalue>";
		else 		xml += "<tablevalue></tablevalue>";
	}
	xml += "<validationResult/></Parameter>";
	return xml;
};

//LOGS DATA
SLUIProcess.prototype.loadLogs = function(oComm) {
	if (oComm && !this.triggerd.log ) {
		oComm.connect(this.urls.logsUrl, null, null, this._loadResourceFailure, this._loadLogsSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_LOGS});	
		this.triggerd.log = true;
	}
	else oStub.oFather.oLogger.logD("Unable to load logs resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadLogsSuccess = function(dta) {
	if (dta) {
		if (oStub.oFather.oProcExe.oUIProc.dtaformat === suiCnst.UI_DATA_FORMAT_XML) {
		    oStub.oFather.oProcExe.oUIProc.logLst = new sap.ui.model.xml.XMLModel();
		    oStub.oFather.oProcExe.oUIProc.logLst.setData(dta);
		} 
		else if (oStub.oFather.oProcExe.oUIProc.dtaformat === suiCnst.UI_DATA_FORMAT_JSON) oStub.oFather.oProcExe.oUIProc.logLst = new sap.ui.model.json.JSONModel();
		oStub.oFather.oProcExe.oUIProc.triggerd.log = false;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_LOG);
	}
	else oStub.oFather.oLogger.logD("Logs resource loaded successfully with empty data element");
};

SLUIProcess.prototype.loadLogContent = function(sLogId, fnSUcc, oComm) {
	var logContentUrl;
	if (oStub.oFather.execVwProps["uselogsRelativeUrl"] == true) logContentUrl = this.urls.rootURL+sLogId;
	else logContentUrl = this.urls.logsUrl+"/"+sLogId;
	if (sLogId && oComm) {
		var requestHdrObj = {		HTTP_METHOD_NAME: suiCnst.HTTP_METHOD_GET,
			  						REQUEST_DATA_TYPE: suiCnst.UI_DATA_FORMAT_TEXT,
			  						ACCEPT_DATA_TYPE: suiCnst.HTTP_RESP_TYPE_TXT_PLAIN,
			  						CONTENT_TYPE: suiCnst.HTTP_CNT_TYPE_TXT_PLAIN			};
		oComm.connect(logContentUrl, requestHdrObj, null, this._loadLogFailure, fnSUcc, null, {slpResourceName: suiCnst.SLP_RESOURCE_LOGS});	
	}
	else {
		if (sLogId) oStub.oFather.oLogger.logD("Unable to load log content of log (id:"+sLogId+") from logs resource in UI Process object due to empty communicator object");
		else oStub.oFather.oLogger.logD("Unable to load logs resource in UI Process object due to empty communicator object");
	}
};

//ERRORS
SLUIProcess.prototype.loadError = function(oComm) {
	if (oComm) oComm.connect(this.urls.errorsUrl, null, null, this._loadResourceFailure, this._loadErrorSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_ERROR});	
	else oStub.oFather.oLogger.logD("Unable to load error resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadErrorSuccess = function(dta) {
	if (dta) {
		oStub.oFather.oProcExe.oUIProc.errElm = [];
		$.each($(dta).find(suiCnst.SLP_ERROR_NAME), function(ind, err) {
		    oStub.oFather.oProcExe.oUIProc.errElm.push(new SLUIError(oStub.oFather.oProcExe.oUIProc.dtaformat, err));
		});
		oStub.oFather.oProcExe.oUIProc.errComp[suiCnst.SLP_RESOURCE_ERROR] = undefined;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_ERROR);
	}
	else oStub.oFather.oLogger.logD("Logs resource loaded successfully with empty data element");
};

//BreakPoints
SLUIProcess.prototype.loadBreakPoints = function(oComm) {
	if (oComm && !this.triggerd.brkPnt) {
		oComm.connect(this.urls.brkPntsUrl, null, null, this._loadResourceFailure, this._loadBreakPointsSuccess, null, {slpResourceName: suiCnst.SLP_RESOURCE_BREAKPOINTS});	
		this.triggerd.brkPnt = true;
	}
	else oStub.oFather.oLogger.logD("Unable to load breakpoints resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._loadBreakPointsSuccess = function(dta) {
	if (dta) {
		if (oStub.oFather.oProcExe.oUIProc.dtaformat === suiCnst.UI_DATA_FORMAT_XML) oStub.oFather.oProcExe.oUIProc.brkLst = new sap.ui.model.xml.XMLModel();
		else if (oStub.oFather.oProcExe.oUIProc.dtaformat === suiCnst.UI_DATA_FORMAT_JSON) oStub.oFather.oProcExe.oUIProc.brkLst = new sap.ui.model.json.JSONModel();
		//replace 1 & 0 with true and false.
		var objXML = new XMLSerializer();
		var newDta = objXML.serializeToString(dta);
		while (newDta.indexOf("<enabled>0</enabled>") > 0 ) newDta= newDta.replace("<enabled>0</enabled>", "<enabled>false</enabled>");
		while (newDta.indexOf("<enabled>1</enabled>") > 0 ) newDta= newDta.replace("<enabled>1</enabled>", "<enabled>true</enabled>");
		oStub.oFather.oProcExe.oUIProc.brkLst.setXML(newDta);
		sap.ui.getCore().setModel(oStub.oFather.oProcExe.oUIProc.brkLst);
		oStub.oFather.oProcExe.oUIProc.triggerd.brkPnt = false;
		oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_BREAKPOINTS);
	}
	else oStub.oFather.oLogger.logD("Breakpoint resource loaded successfully with empty data element");
};


SLUIProcess.prototype.postBreakPoint = function(oComm, sData) {
	if (oComm) {
		var requestHdrObj = {	HTTP_METHOD_NAME : suiCnst.HTTP_METHOD_POST,
								CONTENT_TYPE : suiCnst.HTTP_CNT_TYPE_APP_XML	};
		oComm.connect(this.urls.brkPntsUrl, requestHdrObj, null, this._loadResourceFailure, this._postBreakPointSuccess, sData, {slpResourceName: suiCnst.SLP_RESOURCE_BREAKPOINTS});	
	}
	else oStub.oFather.oLogger.logD("Unable to load breakpoints resource in UI Process object due to empty communicator object");
};

SLUIProcess.prototype._postBreakPointSuccess = function(dta) {
	if (dta) {
	//	oStub.oFather.getView().vBrkList.brkPntListTable.setBusy(true);
	//	oStub.oFather.oProcExe.getSLPBreakpoints();
	}
	else oStub.oFather.oLogger.logD("Breakpoint resource loaded successfully with empty data element");	
};

//Adapter Related
SLUIProcess.prototype._getAdapter = function(sSLPResourceMapping) {
	if (this.adapColl && this.adapColl.length > 0) {
		for (var x = 0; x < this.adapColl.length; x++) if (this.adapColl[x].sSLPResource && this.adapColl[x].sSLPResource === sSLPResourceMapping) return this.adapColl[x];
	}
	else {
		oStub.oFather.oLogger.logD("Adapter rule collection is empty.");
		return null;
	}
};

SLUIProcess.prototype._loadAdapterRule = function(sAdapterPath) {
	if (sAdapterPath) {
		if (window.ActiveXObject || "ActiveXObject" in window) xhttp = new ActiveXObject("Msxml2.XMLHTTP.3.0");
		else xhttp = new XMLHttpRequest();
		xhttp.open("GET", sAdapterPath, false);
		xhttp.setRequestHeader("Cache-Control", "max-age=3600");
		xhttp.send("");
		return xhttp;
	} else {
		oStub.oFather.oLogger.logD("Adapter rule path is empty - unable to match it to SLP resource .");
		return null;
	}
};

SLUIProcess.prototype._applyAdapterRule = function(odtaDocument, ruleData) {
	if (odtaDocument && ruleData) {
		var result = null;
	    if (window.ActiveXObject || "ActiveXObject" in window) {                              // Internet Explorer
	    	if (typeof odtaDocument === "object") odtaDocument = new XMLSerializer().serializeToString(odtaDocument);
	    	var xmlDoc = new ActiveXObject("Msxml2.DOMDocument.6.0");
	    	xmlDoc.loadXML(odtaDocument);				
	    	var xslDoc = new ActiveXObject("Msxml2.DOMDocument.6.0");
	    	xslDoc.loadXML(ruleData.responseText);
	    	result = xmlDoc.transformNode(xslDoc);
	    } 
	    else if (document.implementation && document.implementation.createDocument) {       // Chrome, Firefox, ...
	    	if (typeof odtaDocument === "string") {
	    		try {odtaDocument = $.parseXML(odtaDocument);}
	    		catch (err) {return;}
	    	}
	    	xsltProcessor = new XSLTProcessor();
	    	xsltProcessor.importStylesheet(ruleData.responseXML);
	    	result = xsltProcessor.transformToDocument(odtaDocument);
	    }
	    return result;
	} else {
		oStub.oFather.oLogger.logD("The document is empty, unable to perform transformmation");
		return null;
	}
};
