sap.ui.jsview(sluiCore.mod.jsappInfo, {
	appHdr: 		undefined,
	appHdrTxt: 		undefined,
	appHdrTooltip: 	undefined,
	logoOn: 		true,
	userLogin: 		false,
	userName: 		undefined,
	welcomeMsg: 	false,
	
	supplyData: function(appHdrText, appHdrToolTip, welcomeMsg, logoOn, userLoginOn, userName) {
		if (appHdrText) this.appHdrTxt = appHdrText;
		if (appHdrToolTip) this.appHdrTooltip = appHdrToolTip;
		if (welcomeMsg) this.welcomeMsg = welcomeMsg;
		if (logoOn) this.logoOn = logoOn;
		if (userLoginOn) this.userLogin = userLoginOn;
		if (userName) this.userName = userName;
		this.updateContent();
	},
	
	createContent: function(oController) {
		this.appHdr = new sap.ui.commons.ApplicationHeader();
		this.appHdr.setDisplayWelcome(false);
		this.appHdr.setDisplayLogoff(false);
		return this._appHdr;
	},
	
	updateContent: function() {
		if (this.appHdrTxt) this.appHdr.setLogoText(this.appHdrTxt);
		if (this.appHdrTooltip) this.appHdr.setTooltip(this.appHdrTooltip);
		if (this.data._welcomeMsg) this.appHdr.setDisplayWelcome(this.welcomeMsg);
		else this.appHdr.setDisplayWelcome(false);
		if (this.userLogin) {
			this.appHdr.setDisplayLogoff(this.logoOn);
			if (this.userName) this.appHdr.setUserName(this.userName);
		} 
		else this.appHdr.setDisplayLogoff(false);
		if (this.logoOn) this.appHdr.setLogoSrc(suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_LOGO + "/saplogo.png");
		else this.appHdr.setLogoSrc();
	}
});
