sap.ui.jsview(sluiCore.mod.jsbrkpnts, {
    proBrkPntListContainer: undefined,
    brkPntListTable: 		undefined,
    breakPointsData: 		undefined,
    visibleRow: 			-12,
    sLogId: 				undefined,

    supplyData: function() {
    	this.updateContent();
    },
    
    createContent: function(oController) {
        this.proBrkPntListContainer = new sap.ui.commons.layout.VerticalLayout({width: "100%"});
        this.createBreakPointTable();
        return this.proBrkPntListContainer;
    },
    
    updateContent: function(update) {
        var oFCntrl = oStub.oFather;
        var oUIProc = oStub.oFather.oProcExe.oUIProc;
        this.breakPointsData = oUIProc.brkLst;
        if (this.brkPntListTable) {
            this.brkPntListTable.setModel(this.breakPointsData);
            this.brkPntListTable.bindRows("/Breakpoint");
            this.brkPntListTable.rerender();
        } 
        else if (this.proBrkPntListContainer == undefined) this.createContent();
        if (update) {
            oStub.oFather.oProcExe.getSLPBreakpoints();
            this.brkPntListTable.setBusy(true);
            var oNoDataLbl = new sap.ui.commons.Label({
                text: oBundle.getText("BRK_LOAD_LBL_TXT")
            });
            oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
            this.brkPntListTable.setNoData(oNoDataLbl);
        } else {
            this.brkPntListTable.setBusy(false);
            var oNoDataLbl = new sap.ui.commons.Label({
                text: oBundle.getText("NO_BRK_LBL_TXT")
            });
            oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
            this.brkPntListTable.setNoData(oNoDataLbl);
        }
        this.resizeTableHeightForVerticalScroll();
    },
    
    createBreakPointTable: function() {
        var suc = sap.ui.commons;
        var sut = sap.ui.table;
        var oNoDataLbl = new suc.Label({
            text: oBundle.getText("BRK_LOAD_LBL_TXT")
        });
        oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
        this.brkPntListTable = new sut.Table("_slui_table_brkPnts", {
            noData: oNoDataLbl
        });
        // status image
        var oBrkStatusIcon = new sap.ui.core.Icon({
            size: 					"15px",
            color: 					"#8F8F8F",
            activeColor: 			"white",
            activeBackgroundColor: 	"transparent",
			decorative: 			false,											//SUM_DMO_SAPUI5_ACC_SP19_ACC-264             
            width: 					"15px"
        });

        oBrkStatusIcon.bindProperty(suiCnst.UI5_ATTR_ISRC, suiCnst.SLP_BREAKPOINT_STATUS, function(oValue) {
            return oBreakPointViewHelper.generateStatusIcon(oValue);
        });
        oBrkStatusIcon.bindProperty(suiCnst.UI5_ATTR_TTIP, suiCnst.SLP_BREAKPOINT_STATUS, function(oValue) {
            return oBreakPointViewHelper.generateStatusTooltip(oValue);
        });
        oBrkStatusIcon.bindProperty(suiCnst.UI5_ATTR_COLOR, suiCnst.SLP_BREAKPOINT_STATUS, function(oValue) {
            return oBreakPointViewHelper.generateStatusColor(oValue);
        });
        oBrkStatusIcon.bindProperty(suiCnst.UI5_ATTR_ALT, suiCnst.SLP_BREAKPOINT_STATUS, function(oValue) {
            return oBreakPointViewHelper.generateStatusTooltip(oValue);					//SUM_DMO_SAPUI5_ACC_SP19_ACC-264
        });
        
        var oColStatus = new sut.Column("_slui_tbl_column_brkPntsStatus", {
            label: 		oBundle.getText("TBL_CLMN_HDR_STS_TXT"),
            template: 	oBrkStatusIcon,
            width: 		"13%", //75px
            hAlign: 	"Center"
        });
        this.brkPntListTable.addColumn(oColStatus);
        // technical name
        var oNameTxt = new suc.Label({
            width: "100%"
        });
        var oLblHdr = new suc.Label({
            text: oBundle.getText("TBL_CLMN_HDR_DEC_TXT")
        });
        oNameTxt.bindProperty(suiCnst.UI5_ATTR_TEXT, suiCnst.SLP_BREAKPOINT_TECHNAME);
        oNameTxt.bindProperty(suiCnst.UI5_ATTR_TTIP, suiCnst.SLP_BREAKPOINT_TECHNAME);
        
        var oColname = new sut.Column("_slui_tbl_column_brkPntId", {
            label: 				oLblHdr,
            template: 			oNameTxt,
            width: 				"72%", 
            sortProperty: 		suiCnst.SLP_BREAKPOINT_TECHNAME,
            filterProperty: 	suiCnst.SLP_BREAKPOINT_TECHNAME
        });
        this.brkPntListTable.addColumn(oColname);
        // enabled
        var oChkBx = new suc.CheckBox({
            width: "100%",
            change: function(oEvent) {
                var path = oEvent.getSource().getBindingContext().sPath;
                if (path) {
                    path = path.replace("/Breakpoint/", "");
                    path = parseInt(path);
                }
                var bChk = oEvent.getSource().getChecked();
                var oIndexModel = $(oEvent.getSource().getBindingContext().getModel().oData).find("Breakpoint")[path];
                if (oIndexModel) {
                    $(oIndexModel).find("enabled")[0].innerHTML = bChk;
                    var xmlSer = new XMLSerializer();
                    var sNSURL = "";
                    if (oBundle) sNSURL = oBundle.getText("URL_SAP_NS");
                    var sIndexModel = xmlSer.serializeToString(oIndexModel);
                    sIndexModel = sIndexModel.replace("<enabled>true</enabled>", "<enabled>1</enabled>");
                    sIndexModel = sIndexModel.replace("<enabled>false</enabled>", "<enabled>0</enabled>");
                    oIndexModel = "<breakpoints xmlns=\"" + sNSURL + "\">" + sIndexModel + "</breakpoints>";
                    oStub.oFather.oProcExe.postSLPBreakPoint(oIndexModel);
                }
            }
        });
        oChkBx.bindChecked({path: "enabled", type: new sap.ui.model.type.String()});
        var oColEnabled = new sut.Column("_slui_tbl_column_brkPntEnabled", {
            label: 			oBundle.getText("TBL_CLMN_HDR_ENABL_TXT"),
            template: 		oChkBx,
            hAlign: 		"Center",
            width: 			"15%", //75px
            sortProperty: 	suiCnst.SLP_BREAKPOINT_ENABLED
        });
        this.brkPntListTable.addColumn(oColEnabled);
        this.brkPntListTable.setToolbar(new suc.Toolbar({
            rightItems: [(new suc.Button("_slui_tbl_brkPnts_tbar_refresh_btn", {
                    text: oBundle.getText("BTN_REF_TXT"),
                    tooltip: oBundle.getText("REF_BRK_TIP_TXT"),
                    icon: "sap-icon://refresh", 
                    press: function(e) {
                        if (e) e.preventDefault();
                        oStub.oFather.getView().vBrkList.brkPntListTable.setBusy(true);
                        var oNoDataLbl = new sap.ui.commons.Label({
                            text: oBundle.getText("BRK_LOAD_LBL_TXT")
                        });
                        oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
                        oStub.oFather.getView().vBrkList.brkPntListTable.setNoData(oNoDataLbl);
                        for (var i = 0; i < oStub.oFather.getView().vBrkList.brkPntListTable.getColumns().length; i++) {
                            (oStub.oFather.getView().vBrkList.brkPntListTable.getColumns()[i]).setSorted(false);
                            (oStub.oFather.getView().vBrkList.brkPntListTable.getColumns()[i]).setFiltered(false);
                        }
                        oStub.oFather.oProcExe.getSLPBreakpoints();
                    }
                })).addStyleClass("refBtnIcon")]
        }));
        this.brkPntListTable.setSelectionMode(sut.SelectionMode.Single);
        this.brkPntListTable.setColumnHeaderVisible(true);
        this.brkPntListTable.setModel(this.breakPointsData);
        this.brkPntListTable.bindRows("/Breakpoint");
        this.proBrkPntListContainer.addContent(this.brkPntListTable);
        this.brkPntListTable.setSelectionBehavior(sut.SelectionBehavior.RowOnly);
        this.brkPntListTable.addStyleClass('sluiBreakptTable');
		this.brkPntListTable.addEventDelegate({
			onAfterRendering: function(evt) {
					var idx = -1;
					this.clearSelection();
					if (this.getModel()) $(this.getModel().getData()).find("status").each(function(i) {
						if (($(this).text() === suiCnst.SLP_BREAKPOINT_STATUS_AT)||($(this).text() === suiCnst.SLP_BREAKPOINT_STATUS_BEFORE)) {
							idx = i;
							return false; // this is to exit the each() loop when actual phase is found
						}
					});
					this.setSelectedIndex(idx);
					this.setFirstVisibleRow((idx>2) ? idx-3 : 0);
			}
		}, this.brkPntListTable);
    },
    
    isTagAvailable: function(data, tag) {
        var cTags = $(data).find(tag);
        if (cTags.length > 0) return true;
        else return false;
    },
    
    resizeTableHeightForVerticalScroll: function() {
        var iWidth = $(document).height() - 210;
        iWidth = Math.round(iWidth / 32);					// was: 28 - needed to be adjusted for SAPUI5 V1.46.0 
        this.brkPntListTable.setVisibleRowCount(iWidth);
        $(window).resize(function() {
            var iWidth = $(document).height() - 210;
            iWidth = Math.round(iWidth / 32);				// was: 28 - needed to be adjusted for SAPUI5 V1.46.0
            sap.ui.getCore().byId("_slui_table_brkPnts").setVisibleRowCount(iWidth);
        });
    }
});

var oBreakPointViewHelper = {
    generateStatusTooltip: function(oValue) {
        var imgSrc = "Breakpoint";
        switch (oValue) {
            case suiCnst.SLP_BREAKPOINT_STATUS_AT:
                imgSrc = oBundle.getText("BRK_STP_AT_TXT");
                break;
            case suiCnst.SLP_BREAKPOINT_STATUS_AFTER:
                imgSrc = oBundle.getText("BRK_STP_AFTR_TXT");
                break;
            case suiCnst.SLP_BREAKPOINT_STATUS_BEFORE:
                imgSrc = oBundle.getText("BRK_STP_BFR_TXT");
                break;
            default:
                imgSrc = oBundle.getText("BRK_STP_AT_TXT");
                break;
        }
        return imgSrc;
    },
    generateStatusIcon: function(oValue) {
        var iconSrc = "sap-icon://";
        switch (oValue) {
            case suiCnst.SLP_BREAKPOINT_STATUS_AT:
                iconSrc = iconSrc + "present";
                break;
            case suiCnst.SLP_BREAKPOINT_STATUS_AFTER:
                iconSrc = iconSrc + "past";
                break;
            case suiCnst.SLP_BREAKPOINT_STATUS_BEFORE:
                iconSrc = iconSrc + "future";
                break;
            default:
                iconSrc = iconSrc + "past";
                break;
        }
        return iconSrc;
    },
    generateStatusColor: function(oValue) {
        switch (oValue) {
            case suiCnst.SLP_BREAKPOINT_STATUS_AT:
                color = '#fdc411'; // like (old) @sapUiCriticalElement
                break;
            case suiCnst.SLP_BREAKPOINT_STATUS_AFTER:
                color = '#009823'; // like @sapUiPositiveElement but more green
                break;
            case suiCnst.SLP_BREAKPOINT_STATUS_BEFORE:
                color = '#005cd0'; // like @sapUiNeutralElement but more blue
                break;
            default:
                color = '#007cc0'; // @sapUiNeutralElement;
                break;
        }
        return color;
    }
};