sap.ui.jsview(sluiCore.mod.jsshell, {	
	appShell: 			undefined,
	appHdrText: 		undefined,
	appHdrTooltip: 		undefined,
	appIcon: 			suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_LOGO + "/saplogo.png",
	appIconToolTip: 	"SAP",
	userLogin: 			false,
	userName: 			undefined,
	welcomeMsg: 		false,
	searchTool: 		false,
	inspectorTool: 		false,
	feederTool: 		false,
	toolPopup: 			false,
	headerItems: 		undefined,
	workSetItemViews: 	undefined,
	UIMode: 			undefined,
	//I306705
	oMenuItems:			[],
	oFramSets:			[],
	//D034742
	iFrameLinked:		[],
	idxResetMenu: 		-1,
	idxCleanupMenu: 	-1,
	idxExitMenu: 		-1,
	
	supplyData: function(sAppHdrText, bUserLoginOn, sUserName, sWelcomeMsg, bSearchTool, bInspectorTool, bfeederTool, sUIMode) {
		if (sAppHdrText) this.appHdrText = sAppHdrText;
		if (bUserLoginOn) this.userLogin = bUserLoginOn;
		if (sUserName) this.userName = sUserName;
		if (sWelcomeMsg) this.welcomeMsg = sWelcomeMsg;
		if (bSearchTool) this.searchTool = bSearchTool;
		if (bInspectorTool) this.inspectorTool = bInspectorTool;
		if (bfeederTool) this.feederTool = bfeederTool;
		//I306705
		if (sUIMode) this.UIMode = sUIMode;
		this.updateContent();
	},

	createContent: function(oController) {
		this.appShell = new sap.ui.ux3.Shell("_slui_rootShell");
		this.appShell.addEventDelegate({onAfterRendering: function(evt) {$("#_slui_rootShell-wBar").css("margin-right", "0");}}, this.appShell);  
		this.workSetItemViews = [];
		this.appShell.setPaneWidth(400);
		this.appShell.attachPaneBarItemSelected(function(oEvent) {
			var sKey = oEvent.getParameter("key");
			var oShell = oEvent.oSource;
			switch (sKey) {
				case "slui_spbitasks":
					oShell.removeAllPaneContent(); 
					oShell.setPaneWidth(500);
					sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vExeStpList.updateContent(false, true);
					oShell.setPaneContent(sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vExeStpList.stepListTable, true);
					break;
				case "slui_spbilogs":
					oShell.removeAllPaneContent();
					oShell.setPaneWidth(500);
					sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vLogs.updateContent(true);
					oShell.setPaneContent(sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vLogs.logsListTable, true);
					break;
				case "slui_spbibreakpoints":
					oShell.removeAllPaneContent();
					oShell.setPaneWidth(500);
					sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vBrkList.updateContent(true); 
					oShell.setPaneContent(sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vBrkList.brkPntListTable, true);
					break;
				default:
					oShell.removeAllPaneContent();
			}
		});
		this.appShell.attachPaneClosed(function(oEvent) {
			var sId = oEvent.getParameter("id");
			var oShell = oEvent.oSource;
			switch (sId) {
				case "slui_spbitasks":
				case "slui_spbilogs":
				case "slui_spbibreakpoints":
					oShell.removeAllPaneContent();
			}
		});
		return this.appShell;
	},

	loadIFrame: function(index) {
		if (!this.iFrameLinked[index]){
			var _URL="";
			if (oFrameProps && oFrameProps.length!=0) {_URL = oFrameProps[index].targetURL;}
            $("#_slui_iframe_"+index+"_"+index).attr('src',_URL); 
            this.iFrameLinked[index] = true;
		}

		var oLyt = sap.ui.getCore().byId("_slui_invisblecontaineroverview");
		oLyt.setVisible(false);
        var refItem = $($("#mainDiv").find(".sapUiUx3ShellCanvas")[0]);
        if(refItem) $("#_slui_iframe_"+index).css("height",(refItem.height()-30));
        if ($("#_slui_iframe_"+index).css("display") === "none") $("#_slui_iframe_"+index).css("display","");
        $("#_slui_iframe_"+(index+1)%2).css("display","none");
	},

	updateContent: function() {
		if (((oStub.oFather.globProps["showLogo"] == true) || (oStub.oFather.globProps["showLogo"] == undefined)) && (this.appIcon && this.appIconToolTip)) {
			this.appShell.setAppIcon(this.appIcon);
			this.appShell.setAppIconTooltip(this.appIconToolTip);
		}
		if (((oStub.oFather.globProps["showName"] == true) || (oStub.oFather.globProps["showName"] == undefined)) && this.appHdrText) this.appShell.setAppTitle(this.appHdrText);
		if (this.userLogin) this.appShell.setShowLogoutButton(this.userLogin);
		else this.appShell.setShowLogoutButton(false);
		var suc = sap.ui.commons;
		var oTxt1 = new suc.TextView("slui_usrnametxt");
		if (this.userLogin) {
			if (this.userName) {
				oTxt1.setText(this.userName);
				oTxt1.setTooltip("User:" + this.userName);
			} else {
				oTxt1.setText("Administrator");
				oTxt1.setText("User:Administrator");
			}
			this.appShell.addHeaderItem(oTxt1);
		}
		var oTxt2 = new suc.TextView("slui_usrwelmsgtxt");
		if (this.userLogin) {
			if (this.welcomeMsg) {
				oTxt2.setText(this.welcomeMsg);
				oTxt2.setText(this.welcomeMsg);
			} else {
				oTxt2.setText("Welcome");
				oTxt2.setText("Welcome");
			}
			this.appShell.addHeaderItem(oTxt2);
		}
		if (this.searchTool) this.appShell.setShowSearchTool(this.searchTool);
		else this.appShell.setShowSearchTool(false);

		// enable inspector tool
		if (this.inspectorTool) this.appShell.setShowInspectorTool(this.inspectorTool);
		else this.appShell.setShowInspectorTool(false);

		// enable feeder tool
		if (this.feederTool) this.appShell.setShowFeederTool(this.feederTool);
		else this.appShell.setShowFeederTool(false);

		if ((oStub.oFather.globProps["showLegend"] === true) || (oStub.oFather.globProps["showLegend"] === undefined)) {
			var oLink = new suc.Link({
				text: 		" Legend ",
				toolTip: 	"Click to know more about icons used in this tool",
				press: function(e) {
					if(e) e.preventDefault();	
					var obj = new SLUIDialogProvider();
					if(obj) obj.getIconDialog().open();
				}
			});
			this.appShell.addHeaderItem(oLink);
		}
		var sux = sap.ui.ux3;
		this.appShell.addWorksetItem(new sux.NavigationItem("_slui_worksetitemprocessexecution", {
			key: "slui_key_processexecution",
			text: "Home"
		}));
		this.appShell.addWorksetItem(new sux.NavigationItem("slui_worksetItem_one", {
			key: "slui_key_nav_item_one",
			text: "Navigation Item 1",
			visible: false
		}));
		this.appShell.addWorksetItem(new sux.NavigationItem("slui_worksetItem_two", {
			key: "slui_key_nav_item_one",
			text: "Navigation Item 2",
			visible: false
		}));
		this.appShell.addWorksetItem(new sux.NavigationItem("slui_worksetItem_three", {
			key: "slui_key_nav_item_one",
			text: "Navigation Item 3",
			visible: false
		}));
		this.appShell.addWorksetItem(new sux.NavigationItem("slui_worksetItem_four", {
			key: "slui_key_nav_item_one",
			text: "Navigation Item 4",
			visible: false
		}));
		this.appShell.addWorksetItem(new sux.NavigationItem("slui_worksetItem_five", {
			key: "slui_key_nav_item_one",
			text: "Navigation Item 5",
			visible: false
		}));
		oStub.oFather.sSelectedItem = '_slui_worksetitemprocessexecution';
		this.appShell.attachWorksetItemSelected(function(oEvent) {
			var sId = oEvent.getParameter("id");
			var oShell = oEvent.oSource;
			var oSelfRef = oStub.oFather.getView().vAppShell; //get proper object
			switch (sId) {
				case "_slui_worksetitemprocessexecution":
				case "slui_worksetItem_one":
				case "slui_worksetItem_two":
				case "slui_worksetItem_three":
				case "slui_worksetItem_four":
				case "slui_worksetItem_five":
					oStub.oFather.sSelectedItem = sId;
					oShell.setContent(oSelfRef.workSetItemViews[sId]);
					break;
			}
		});
	},

	updateViewAfterRednering: function() {
		this.attachMenuToShell();
		this.attachHelpToShell();
	},

	enableResetMenu: function(text, oFunc, enabled) {
	    var oMenu = sap.ui.getCore().byId("more");
	    if (oMenu && (this.idxResetMenu >= 0)) {
                oMenu.getItems()[this.idxResetMenu].setVisible(Boolean(text));
                var selFct = oMenu.getItems()[this.idxResetMenu].mEventRegistry.select; 
                var len = (selFct ? selFct.length : 0);
                for (var x = 0; x < len; x++) oMenu.getItems()[this.idxResetMenu].detachSelect(selFct[x].fFunction);
                if (text) oMenu.getItems()[this.idxResetMenu].setText(text); 
                if (oFunc) oMenu.getItems()[this.idxResetMenu].attachSelect(oFunc); 
                oMenu.getItems()[this.idxResetMenu].setEnabled(enabled); 
	    }  
	},
	
	enableCleanupMenu: function(text, oFunc, enabled) {
	    var oMenu = sap.ui.getCore().byId("more");
	    if (oMenu && (this.idxCleanupMenu >= 0)) {
                oMenu.getItems()[this.idxCleanupMenu].setVisible(Boolean(text));
                var selFct = oMenu.getItems()[this.idxCleanupMenu].mEventRegistry.select; 
                var len = (selFct ? selFct.length : 0);
                for (var x = 0; x < len; x++) oMenu.getItems()[this.idxCleanupMenu].detachSelect(selFct[x].fFunction);
                if (text) oMenu.getItems()[this.idxCleanupMenu].setText(text); 
                if (oFunc) oMenu.getItems()[this.idxCleanupMenu].attachSelect(oFunc); 
                oMenu.getItems()[this.idxCleanupMenu].setEnabled(enabled); 
	    }  
	},
	
    enableExitMenu: function(text, oFunc, enabled) {
	    var oMenu = sap.ui.getCore().byId("more");
	    if (oMenu && (this.idxExitMenu >= 0)) {
                oMenu.getItems()[this.idxExitMenu].setVisible(Boolean(text));
                var selFct = oMenu.getItems()[this.idxExitMenu].mEventRegistry.select; 
                var len = (selFct ? selFct.length : 0);
                for (var x = 0; x < len; x++) oMenu.getItems()[this.idxExitMenu].detachSelect(selFct[x].fFunction);
                if (text) oMenu.getItems()[this.idxExitMenu].setText(text); 
                if (oFunc) oMenu.getItems()[this.idxExitMenu].attachSelect(oFunc); 
                oMenu.getItems()[this.idxExitMenu].setEnabled(enabled); 
	    }  
	},
	
	attachMenuToShell: function() {
		var obj = sap.ui.getCore().byId("_slui_menu_hdr1");
		if (!obj) {
			var suc = sap.ui.commons;
			var oMenu = new suc.Menu("more");
			if ((oStub.oFather.globProps["showMore"] === true) || (oStub.oFather.globProps["showMore"] === undefined)) {
				var oMenuBtn = new suc.MenuButton("_slui_menu_hdr1", {
					text: 		"More",
					tooltip: 	"Click for displaying more informations and menu options ",
					menu: 		oMenu
				});
				support.modules.renderers.SupportMenus.addSupportMenus(oClient);
				// construct menu items
				if (oStub && oStub.oFather && oStub.oFather.cMenuColl && oStub.oFather.cMenuColl.length > 0) {
					var mColl = oStub.oFather.cMenuColl;
					for (var x = 0; x < mColl.length; x++) {
						mColl[x].uiId ="_slui_menu_Item_"+x;
						var oMI = new suc.MenuItem(mColl[x].uiId, {text: mColl[x].sText});  
						mColl[x].item = oMI;
						oMenu.addItem(mColl[x].item);
						if (mColl[x].sText.indexOf("RESET")>-1) this.idxResetMenu = x;
						if (mColl[x].sText.indexOf("CLEANUP")>-1) this.idxCleanupMenu = x;
						if (mColl[x].sText.indexOf("EXIT")>-1) this.idxExitMenu = x;
					}
				}

				//add default items
				var abtMenu = new suc.MenuItem("_slui_menu_item_def_abt", {text: "About"});
				oMenu.addItem(abtMenu);
				oMenu.addItem(new suc.MenuItem("_slui_menu_item_def_logout", {text: "Logout"}));
				//add select event
				oMenuBtn.attachItemSelected(function(oEvent) {
					if (oStub && oStub.oFather && oStub.oFather.cMenuColl && oStub.oFather.cMenuColl.length>0) {
						var mColl = oStub.oFather.cMenuColl;
						for (var x = 0; x < mColl.length; x++) {
							if (oEvent.getParameter("itemId") === mColl[x].uiId) {
								var funDef = mColl[x].fun;
								if (funDef && (typeof funDef == "function")) {
									funDef();
									break;
								}
							}
						}
					}
					if (oEvent.getParameter("itemId") === "_slui_menu_item_def_abt") {
						var oUIProcDel = oStub.oFather.oProcExe.oUIProc;
						if (!oUIProcDel.metaInfoXml) oStub.oFather.oProcExe.getSLUIMetaInfo();
						else new SLUIDialogProvider().getAboutDialog();
					}
					else if (oEvent.getParameter("itemId") === "_slui_menu_item_def_logout") logout();
				});
				this.appShell.addHeaderItem(oMenuBtn);
				this.enableResetMenu(null, null, true);
				this.enableCleanupMenu(null, null, true);
				this.enableExitMenu(null, null, true);
			}
		}
	},
	
	attachHelpToShell: function() {
		var obj = sap.ui.getCore().byId("_slui_menu_hdr2");
		if (!obj) {
			var suc = sap.ui.commons;
			if ((oStub.oFather.globProps["showHelp"] === true) || (oStub.oFather.globProps["showHelp"] === undefined)) {
				var oMenuBtn = new suc.Link("_slui_menu_hdr2", {
					text: 		"Help",
					tooltip: 	"Click to open the guide for the current dialog",
					press: function(e) {
						if(e) e.preventDefault();
						openHelpWindow();
					}
				});
				this.appShell.addHeaderItem(oMenuBtn);
			}
		}
	},
	
	attachViewForWorkSetItem: function(sItemKey, sItemTitleText, oItemView) {
		if (sItemKey) {
			var worksetItem = null;
			var itemKey = null;
			switch (sItemKey) {
				case "public_slui_navItem1":
					itemKey = 'slui_worksetItem_one';
					break;
				case "public_slui_navItem2":
					itemKey = 'slui_worksetItem_two';
					break;
				case "public_slui_navItem3":
					itemKey = 'slui_worksetItem_three';
					break;
				case "public_slui_navItem4":
					itemKey = 'slui_worksetItem_four';
					break;
				case "public_slui_navItem5":
					itemKey = 'slui_worksetItem_five';
					break;
			}
			worksetItem = sap.ui.getCore().byId(itemKey);
			if (worksetItem) {
				worksetItem.setText(sItemTitleText);
				worksetItem.setVisible(true);
				this.workSetItemViews[itemKey] = oItemView;
			}
		}
	},

	insertViewForWorkSetItem: function(itemCount, child, addAgain) {
		var worksetItem = this.appShell.getWorksetItems()[0];
		if (worksetItem) {
			if (!this.workSetItemViews) this.workSetItemViews = new Object();
			// preserve the child
			this.workSetItemViews["_slui_worksetitemprocessexecution"] = child;
			if (addAgain) this.appShell.addContent(child);
		}
	},

	addBreakPointsSidePanBarItem: function() {
		if (!sap.ui.getCore().byId('slui_pitemBreakpoints')) 
			this.appShell.addPaneBarItem(new sap.ui.core.Item("slui_pitemBreakpoints", {	key: 	"slui_spbibreakpoints",
																							text: 	"Breakpoints"			}));
	},

	addLogsSidePanBarItem: function() {
		if (!sap.ui.getCore().byId('slui_pitemLogs')) 
			this.appShell.addPaneBarItem(new sap.ui.core.Item("slui_pitemLogs", {	key: 	"slui_spbilogs",
																					text: 	"Logs"				}));
	},

	addTaskListSidePanBarItem: function() {
		if (!sap.ui.getCore().byId('slui_pitemTaskList')) 
			this.appShell.addPaneBarItem(new sap.ui.core.Item("slui_pitemTaskList", {	key: 	"slui_spbitasks",
																						text: 	"Task List"			}));
	},

	removeBreakPointsSidePanBarItem: function() {
		if (sap.ui.getCore().byId('slui_pitemBreakpoints')) {
			if (this.appShell.isPaneOpen()) this.appShell.firePaneClosed("slui_spbibreakpoints");
			this.appShell.destroyPaneContent();
			this.appShell.removePaneBarItem("slui_spbibreakpoints");
		}
	},

	removeTaskListSidePanBarItem: function() {
		if (sap.ui.getCore().byId('slui_pitemTaskList')) {
			if (this.appShell.isPaneOpen()) this.appShell.firePaneClosed("slui_spbitasks");
			this.appShell.destroyPaneContent();
			this.appShell.removePaneBarItem("slui_spbitasks");
		}
	},

	removeLogsSidePaneBarItem: function() {
		if (sap.ui.getCore().byId('slui_pitemLogs')) {
			if (this.appShell.isPaneOpen()) this.appShell.firePaneClosed("slui_pitemLogs");
			this.appShell.destroyPaneContent();
			this.appShell.removePaneBarItem("slui_pitemLogs");
		}
	}
});

