jQuery.sap.declare(sluiCore.mod.jsdiaProv);

SLUIDialogProvider = function() {
	this.serviceErrorShown = false;
};

SLUIDialogProvider.prototype.getDialog = function(type, txt, title, settings) {
	var suc = sap.ui.commons;
	var sucr = sap.ui.core;
	var randomNr;
	var oCrypto = window.crypto || window.msCrypto;
	if (oCrypto) {
		var array = new Uint32Array(1);
		randomNr = oCrypto.getRandomValues(array)[0];
	}
	else randomNr = Math.random();
    oStdDia = new suc.Dialog('slui_dialog' + randomNr);
    var sHHTMLContent = "<div style=\"width:20px; height:75px;\"/>";
    var sVHTMLContent = "<div style=\"width:100%; height:20px;\"/>";
    oStdDia.setApplyContentPadding(false);
    oStdDia.setKeepInWindow(true);
    oStdDia.setModal(true);
    oStdDia.setResizable(false);
    oStdDia.setShowCloseButton(true);
    oStdDia.setHeight("200px");
    oStdDia.setMaxHeight("250px");
    oStdDia.setMaxWidth("900px");
    oStdDia.setMinHeight("200px");
    oStdDia.setMinWidth("450px");
    oStdDia.setAutoClose(false);

    var oText = new suc.TextView({
        wrapping: 	true,
        textAlign: 	sucr.TextAlign.Center
    });
    
	var oIcon = new sap.ui.core.Icon( {   
        size: 					"50px",  
        activeColor: 			"white",  
        activeBackgroundColor: 	"transparent",   
        width: 					"50px"
    });
    
    var oImage = new suc.Image({
        width: 		"50px",
        height: 	"50px"
    });
    
    var oVLayout = new suc.layout.VerticalLayout();
    var oHLayout = new suc.layout.HorizontalLayout();
    if (type === 'cancelDialog') {
        oStdDia.setTitle(oBundle.getText("CNF_LBL_TXT")); // + (title ? (" : " + title) : ":"+oBundle.getText("CAN_PRO_LBL_TXT")));
        oIcon.setSrc("sap-icon://sys-help-2");
        oIcon.setColor("#007CC0");
        if (txt && (txt != '')) oText.setText(txt); else oText.setText(oBundle.getText("CAN_CNF_LBL_TXT"));
        oStdDia.attachClosed(function() {oStub.oFather.getView().vExeCont.hideOrShowAllButtons(true);});
    } else if (type === 'infoDialog') {
        oStdDia.setTitle(oBundle.getText("DIA_HDR_INFO_TXT") + (title ? (": " + title) : ""));
        oIcon.setSrc("sap-icon://message-information");
        oIcon.setColor("#007DC0");
        if (txt) oText.setText(txt); else oText.setText(oBundle.getText("INF_DET_NOT_LBL_TXT"));
    } else if (type === 'warnDialog') {
        oStdDia.setTitle(oBundle.getText("WRN_LBL_TXT") + (title ? (": " + title) : ""));
        oIcon.setSrc("sap-icon://warning2");
        oIcon.setColor("#FED659");
        if (txt) oText.setText(txt); else oText.setText(oBundle.getText("WRN_DET_NOT_LBL_TXT"));
        if (settings.showButtons) {
            oStdDia.addButton(new suc.Button({text: "Reset", press: function() {
                    oStdDia.close();
                    settings.onExecute();
            }}));
            oStdDia.addButton(new suc.Button({text: "Cancel", press: function() {oStdDia.close();}}));
        }        
    } else if (type === 'successDialog') {
        oStdDia.setTitle(oBundle.getText("SUC_LBL_TXT") + (title ? (": " + title) : ""));
        oIcon.setSrc("sap-icon://message-success");
        oIcon.setColor("#008B00");
        if (txt) oText.setText(txt); else oText.setText(oBundle.getText("SUC_DET_NOT_LBL_TXT"));
        oText.setSemanticColor(suc.TextViewColor.Positive);
        if (settings.showButtons) {
            if(settings.onOKFunc) oStdDia.addButton(new suc.Button({text: "OK", press: function() {settings.onOKFunc();}}));
            else oStdDia.addButton(new suc.Button({text: "OK", press: function() {oStdDia.close();}}));
        }
    } else if (type === 'errorDialog') {
        oStdDia.setTitle(oBundle.getText("ERR_LBL_TXT") + (title ? (": " + title) : ""));
        oIcon.setSrc("sap-icon://error");
        oIcon.setColor("#CC0000");
        if (txt) oText.setText(txt); else oText.setText(oBundle.getText("ERR_DET_NOT_LBL_TXT"));
        oText.setSemanticColor(suc.TextViewColor.Negative);
        if (settings.showButtons) oStdDia.addButton(new suc.Button({text: "OK", press: function() {oStdDia.close();}}));
    } else if (type === 'aboutDialog') {
        oStdDia.setTitle(oBundle.getText("ABT_SUM_LBL_TXT"));
        oImage.setSrc(suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_LOGO + "/slui.png");
        if (txt) oText.setText(txt); oText.setText(oBundle.getText("SLP_VER_LBL_TXT"));
        oText.setSemanticColor(suc.TextViewColor.Negative);
    }
    oVLayout.addContent(new sucr.HTML({
        content: sVHTMLContent
    }));
    oHLayout.addContent(new sucr.HTML({
        content: sHHTMLContent
    }));
    if (type === 'aboutDialog') oHLayout.addContent(oImage);
    else oHLayout.addContent(oIcon);
    oHLayout.addContent(new sucr.HTML({
        content: sHHTMLContent
    }));
    oHLayout.addContent(oText);
    oHLayout.addContent(new sucr.HTML({
        content: sHHTMLContent
    }));
    oVLayout.addContent(oHLayout);
    oStdDia.addContent(oVLayout);
    return oStdDia;
};

SLUIDialogProvider.prototype.getSLPErrorDialog = function(title, errObj) {
    var sul = sap.ui.layout;
    var suc = sap.ui.commons;
    var randomNr;
	var oCrypto = window.crypto || window.msCrypto;
	if (oCrypto) {
		var array = new Uint32Array(1);
		randomNr = oCrypto.getRandomValues(array)[0];
	}
	else randomNr = Math.random();
    oStdDia = new suc.Dialog('slui_dialog' + randomNr);
    oStdDia.setApplyContentPadding(false);
    oStdDia.setKeepInWindow(true);
    oStdDia.setModal(true);
    oStdDia.setResizable(false);
    oStdDia.setShowCloseButton(true);
    oStdDia.setHeight("350px");
    oStdDia.setWidth("600px");
    oStdDia.setAutoClose(false);
    if (title) oStdDia.setTitle(title); else oStdDia.setTitle(oBundle.getText("DIA_HDR_ERR_TXT"));
    var oPLyt = new sul.VerticalLayout("slui_errLyt");
    var oHLyt = new sul.HorizontalLayout("slui_layoutHError");
    var oVLyt = new sul.VerticalLayout("slui_layoutV");
    var hCnt = "<div style=\"width:30px; height:200px;\"/>";
    var vCnt = "<div style=\"width:100%; height:20px;\"/>";
    var nLin = "<div style=\"width:100%; height:10px;\"/>";
    var nGap = "<div style=\"width:5px; height:5px;\"/>";
    var oUsrMsg = new suc.Label("slui_lbl_usrMsg", {
        wrapping: 	true,
        tooltip: 	(errObj ? (errObj.getUserMessage() ? errObj.getUserMessage() : oBundle.getText("ERR_DESC_NOT_LBL_TXT")) : oBundle.getText("ERR_DESC_NOT_LBL_TXT")),
        text: 		(errObj ? (errObj.getUserMessage() ? errObj.getUserMessage() : oBundle.getText("ERR_DESC_NOT_LBL_TXT")) : oBundle.getText("ERR_DESC_NOT_LBL_TXT")),
        design: 	sap.ui.commons.LabelDesign.Bold,
        width: 		"80%"
    });
    var oIcon = new sap.ui.core.Icon({  
        src: 					"sap-icon://error",  
        size: 					"50px",  
        color: 					"#CC0000",
        activeColor: 			"white",  
        activeBackgroundColor: 	"transparent",   
        width: 					"50px"
    });
    oVLyt.addContent(oUsrMsg);
    oVLyt.addContent(new sap.ui.core.HTML({
        content: 			nLin,
        sanitizeContent: 	true
    }));
    var c = new sap.ui.core.HTML({
        content: 			nGap,
        sanitizeContent: 	true
    });
    if (errObj) {
        if (errObj.getCode()) {
            var oCode = new sul.HorizontalLayout("slui_errCode", {
            	content: [new suc.Label("slui_lbl_errCode", {
                	text: 		oBundle.getText("ERR_CDE_LBL_TXT") + " " + errObj.getCode(),
                    tooltip: 	oBundle.getText("ERR_CDE_LBL_TXT") + " " + errObj.getCode(),
                    design: 	suc.LabelDesign.Bold,
                })]
            });
            if (errObj.getOccurredAt()) {
                oCode.addContent(new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }));
                oCode.addContent(new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }));
                oCode.addContent(new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }));
                oCode.addContent(new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }));
                oCode.addContent(new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }));
                oCode.addContent(new suc.Label("slui_lbl_occAt", {
                    text: 		oBundle.getText("OCR_AT_TXT") + " " + errObj.getOccurredAt(),
                    tooltip: 	oBundle.getText("OCR_AT_TXT") + " " + errObj.getOccurredAt(),
                    design: 	suc.LabelDesign.Bold,
                }));
            }
            oVLyt.addContent(oCode);
            oVLyt.addContent(new sap.ui.core.HTML({
                content: 			nLin,
                sanitizeContent: 	true
            }));
        }
        if (errObj.getDevMessage()) {
            var oDevMsg = new suc.TextArea({
                id: 		"slui_txt_devMsg",
                value: 		errObj.getDevMessage(),
                width: 		"430px",
                height: 	"100px",
                editable: 	false,
                visible: 	true
            });
            var oInfo = new suc.Link({
                text: 		oBundle.getText("ERR_MOR_LNK_TXT"),
                tooltip: 	oBundle.getText("ERR_MOR_TIP_TXT"),
                press: function() {
                    if (oDevMsg.getVisible()) oDevMsg.setVisible(false);
                    else oDevMsg.setVisible(true);
                }
            });
            oVLyt.addContent(oInfo);
            oVLyt.addContent(new sap.ui.core.HTML({
                content: 			nLin,
                sanitizeContent: 	true
            }));
            oVLyt.addContent(oDevMsg);
            oVLyt.addContent(new sap.ui.core.HTML({
                content: 			nLin,
                sanitizeContent: 	true
            }));
        }
        if (errObj.getLogs()) {
            var oLnk = new suc.Link("slui_lnk_log", {
                text: 		"  " + oBundle.getText("LOG_LNK_TXT"),
                tooltip: 	oBundle.getText("LOG_LNK_TXT"),
                press: function() {}
            });
            var fun = function() {
                window.open(errObj.getLogs());
            };
            oLnk.attachPress(fun);
            var oLog = new sul.HorizontalLayout("slui_log", {
                content: [new suc.Label("slui_lbl_log", {
                    text: 		oBundle.getText("CAN_ACC_TXT") + " "
                }), new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }), oLnk]
            });
            oVLyt.addContent(oLog);
            oVLyt.addContent(new sap.ui.core.HTML({
                content: 			nLin,
                sanitizeContent: 	true
            }));
        }
        if (errObj.getHelp()) {
            var oLnk = new suc.Link("slui_lnk_help", {
                text: 		"  "+ oBundle.getText("HERE_LNK_TXT"),
                tooltip: 	oBundle.getText("ADD_INF_TXT"),
            });
            var fun = function() {
                window.open(errObj.getHelp());
            };
            oLnk.attachPress(fun);
            var oHelp = new sul.HorizontalLayout("slui_helpLink", {
                content: [new suc.Label("slui_lbl_help", {
                    text: 	oBundle.getText("ADD_INF_TXT") + oBundle.getText("FND_TXT") + " "
                }), new sap.ui.core.HTML({
                    content: 			nGap,
                    sanitizeContent: 	true
                }), oLnk]
            });
            oVLyt.addContent(oHelp);
            oVLyt.addContent(new sap.ui.core.HTML({
                content: 			nLin,
                sanitizeContent: 	true
            }));
        }
    }
    oHLyt.addContent(new sap.ui.core.HTML({
        content: 			hCnt,
        sanitizeContent: 	true
    }));
    oHLyt.addContent(oIcon);
    oHLyt.addContent(new sap.ui.core.HTML({
        content: 			hCnt,
        sanitizeContent: 	true
    }));
    oHLyt.addContent(oVLyt);
    oHLyt.addContent(new sap.ui.core.HTML({
        content: 			hCnt,
        sanitizeContent: 	true
    }));
    oPLyt.addContent(new sap.ui.core.HTML({
        content: 			vCnt,
        sanitizeContent: 	true
    }));
    oPLyt.addContent(oHLyt);
    oPLyt.addContent(new sap.ui.core.HTML({
        content: 			vCnt,
        sanitizeContent: 	true
    }));
    oStdDia.addContent(oPLyt);
    return oStdDia;
};

SLUIDialogProvider.prototype.metaInfo = function(metaDataField) {
	var sMetaInfo;
	var oUIProcDel = oStub.oFather.oProcExe.oUIProc;
	if ($(oUIProcDel.metaInfoXml).find(metaDataField)) sMetaInfo = $(oUIProcDel.metaInfoXml).find(metaDataField)[0].textContent;
	if (!sMetaInfo) oStub.oFather.oLogger.logD("Meta data field "+metaDataField+" missing or empty");
	return sMetaInfo;
};

SLUIDialogProvider.prototype.getAboutDialog = function() {
	var suc = sap.ui.commons;
	var sulf = sap.ui.layout.form;
    oStdDia = new suc.Dialog();
    oStdDia.setTitle(oBundle.getText("DIA_HDR_INFO_TXT"));
    oStdDia.setApplyContentPadding(false);
    oStdDia.setKeepInWindow(true);
    oStdDia.setModal(true);
    oStdDia.setResizable(false);
    oStdDia.setShowCloseButton(false);
    oStdDia.setHeight("275px");
	oStdDia.setMinHeight("275px");
    oStdDia.setMaxHeight("275px");
    oStdDia.setMaxWidth("500px");
	oStdDia.setWidth("500px");
    oStdDia.setMinWidth("500px");
    oStdDia.setAutoClose(false);
    var extVersion = this.metaInfo("extendedVersion");
	var oLyt = new sulf.GridLayout({singleColumn: true});
	var oForm1 = new sulf.Form({
		width: 		"350px",
		layout: 	oLyt,
		formContainers: [
			new sulf.FormContainer({
				formElements: [
					new sulf.FormElement({
						label: 	new suc.Label({text: (oStub.oFather.globProps["productVersion"].name), layoutData: new sulf.GridElementData({hCells: "5"})}),
						fields:	[new suc.TextView({text: " "+oStub.oFather.globProps["productVersion"].version, layoutData: new sulf.GridElementData({hCells: "auto"})})]
					}),
					new sulf.FormElement({
						label: new suc.Label({text: ""})
					})
				]
			}),
			new sulf.FormContainer({
				formElements: [
					new sulf.FormElement({
						label: 	new suc.Label({text: oBundle.getText("SL_PROT_TXT"), layoutData: new sulf.GridElementData({hCells: "5"})}),
						fields:	[new suc.TextView({text: " "+oStub.oFather.globProps["protocolVersion"], layoutData: new sulf.GridElementData({hCells: "auto"})})]
					}),
					new sulf.FormElement({
						label: 	new suc.Label({text: oBundle.getText("SL_UI_TXT"), layoutData: new sulf.GridElementData({hCells: "5"})}),
						fields:	[new suc.TextView({text: " "+extVersion, layoutData: new sulf.GridElementData({hCells: "auto"})})]
					}),
					new sulf.FormElement({
						label: new suc.Label({text: ""})
					})
				]
			}),
			new sulf.FormContainer({
				formElements: [
					new sulf.FormElement({
						label: new suc.Label({text: "SAP SE "+new Date().getFullYear()+".", layoutData: new sulf.GridElementData({hCells: "4"})})
					})
				]
			})
		]
	});
	var oImage = new sap.ui.commons.Image({width: "64px"});
	oImage.setSrc(suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_LOGO + "/saplogo.png");
	oImage.setAlt("SAP");
	oImage.addStyleClass("displayImgCenter");
	var oLayout = new sap.ui.layout.HorizontalLayout({
		content: [oImage, oForm1]
	});
	oStdDia.addContent(oLayout);
        oStdDia.addButton(new suc.Button({
        	text: oBundle.getText("BTN_CLS_TXT"),
        	press: function() {oStdDia.close();}
    }));
    if (oStdDia) oStdDia.open();
};

SLUIDialogProvider.prototype.getIconDialog = function() {
	var suc = sap.ui.commons;
	var randomNr;
	oCrypto = window.crypto || window.msCrypto;
	if (oCrypto) randomNr = oCrypto.getRandomValues(new Uint32Array(1))[0]; else randomNr = Math.random();
    oStdDia = new suc.Dialog('slui_dialog' + randomNr);
    oStdDia.setTitle(oBundle.getText("DIA_HDR_LGND_TXT"));
    oStdDia.setApplyContentPadding(false);
    oStdDia.setKeepInWindow(true);
    oStdDia.setModal(true);
    oStdDia.setResizable(false);
    oStdDia.setShowCloseButton(false);
    oStdDia.setMinHeight("350px");
    oStdDia.setMaxHeight("500px");
    oStdDia.setMinWidth("1025px");
    oStdDia.setMaxWidth("1125px");
    oStdDia.setAutoClose(false);
    var HelpView = sap.ui.view({
        width: 		"100%",
        viewName: 	sluiCore.mod.jshelp,
        type: 		sap.ui.core.mvc.ViewType.JS
    });
    oStdDia.addContent(HelpView);
    oStdDia.addButton(new suc.Button({
        text: oBundle.getText("BTN_CLS_TXT"),
        press: function() {oStdDia.close();}
    }));
    return oStdDia;
};

SLUIDialogProvider.prototype.errorDialog = function(errorObject) {
	if (errorObject && errorObject.statusCode != 400) {
		var suc = sap.ui.commons;
	    var oErrorDialog = new suc.Dialog({
	        modal: 	true,
	        height:	"200px",
	        width:	"600px"
	    });
	    oErrorDialog.setTitle(oBundle.getText("DIA_HDR_ERR_TXT"));
	    var oIcon = new sap.ui.core.Icon({  
	        src: 					"sap-icon://error",  
	        size: 					"50px",  
	        color: 					"#CC0000",
	        activeColor: 			"white",  
	        activeBackgroundColor: 	"transparent",    
	        width: 					"50px"
	    });
	    var imagePaddingHLeft = new sap.ui.core.HTML({
	        content: 			"<div style=\"width:20px; height:75px;\"></div>",
	        sanitizeContent: 	true
	    });
	    var imagePaddingHRight = new sap.ui.core.HTML({
	        content: 			"<div style=\"width:20px; height:75px;\"></div>",
	        sanitizeContent: 	true
	    });
	    var imagePaddingV = new sap.ui.core.HTML({
	        content: 			"<div style=\"width:20px; height:25px;\"></div>",
	        sanitizeContent: 	true
	    });
	    var oLayoutImage = new sap.ui.layout.VerticalLayout({
	        content: [imagePaddingV, oIcon]
	    });
	    // UserMessage and more
	    var oLblUsrMsg = new suc.Label({design:sap.ui.commons.LabelDesign.Bold});
	    oLblUsrMsg.setText(errorObject.usrMag);
	    var errMsg = oBundle.getText("ERR_DET_LBL_TXT") + "\n\n";
	    if (errorObject.statusCode) errMsg = errMsg+ oBundle.getText("STS_CDE_LBL_TXT") + " " +errorObject.statusCode +"\n\n";
	    if (errorObject.statusTxt) errMsg = errMsg+ oBundle.getText("STS_TEXT_LBL_TXT") + " " +errorObject.statusTxt +"\n\n";
	    if (errorObject.devMsg) errMsg = errMsg+ oBundle.getText("DET_MG_TXT") + " " +errorObject.devMsg +"\n\n";
	    if (errorObject.occurdAt) errMsg = errMsg+ oBundle.getText("OCR_AT_TXT") + " " +errorObject.occurdAt +"\n\n";
	    var textArea = new suc.TextArea({
	        value: 		errMsg,
	        width: 		"450px",
	        height: 	"200px",
	        visible:	false
	    }).setEditable(false);
	    var oLink = new suc.Link({
	        text: 		oBundle.getText("ERR_MOR_LNK_TXT"),
	        tooltip: 	oBundle.getText("ERR_MOR_TIP_TXT"),
	        press: $.proxy(function() {
	            if (textArea.getVisible()) {
	            	oErrorDialog.setWidth("600px");
	            	oErrorDialog.setHeight("200px");
	            	textArea.setVisible(false);
	            } else {
	            	oErrorDialog.setWidth("600px");
	            	oErrorDialog.setHeight("350px");
	            	textArea.setVisible(true);
	            }
	        }, this)
	    });
	    var oLayoutV = new sap.ui.layout.VerticalLayout({
	        content: [oLblUsrMsg, oLink, textArea]
	    });
	    var oLayoutH = new sap.ui.layout.HorizontalLayout({
	        content: [imagePaddingHLeft, oLayoutImage, imagePaddingHRight, oLayoutV]
	    });
	    oErrorDialog.addContent(oLayoutH);
	    oErrorDialog.addButton(new suc.Button({
	        text: 	oBundle.getText("BTN_OK_TXT"),
	        press: 	function() {
	            oErrorDialog.close();
	            oStub.oFather.getView().errDialogShown = false;
	        }
	    }));
	    return oErrorDialog;
	}
};

SLUIDialogProvider.prototype.getLogDialog = function(tit, obj, oContent) {
    var oDialog = new sap.ui.commons.Dialog({
        modal: 			true,
        keepInWindow: 	true
    });
	this.file = "Download.txt";
	this.content = oContent;
	this.hide = false;
	var _a = tit.split("/");
	if (_a && (_a.length > 0)) {
		this.file = _a[_a.length-1];
		var _c = this.file.split(".");
		if (_c && (_c.length > 0)) {
			var ext = _c[_c.length-1];
			if (ext.toUpperCase() === "SAR") this.hide = true;
		}
	}
    oDialog.setTitle(tit);
    oDialog.setMaxWidth("900px");
    oDialog.setMinHeight("708px");
    oDialog.setMaxHeight("708px");
    oDialog.setMinWidth("900px");
    if (this.hide) {
    	oContent.getContent()[0].setTextAlign(sap.ui.core.TextAlign.Center);
        oContent.getContent()[0].setValue(oBundle.getText("LOG_MSG_BINARY"));    	
    } 
    oDialog.addContent(oContent);
    oDialog.addButton(new sap.ui.commons.Button({
		icon: 	"sap-icon://download",
        press: 	$.proxy(function() {saveFile(this.file);}, this)
    }));
    var close = new sap.ui.commons.Button({
        text: oBundle.getText("BTN_OK_TXT"),
        press: function() {oDialog.close();}
    });
    oDialog.addButton(close).setInitialFocus(close);
    return oDialog;
};

SLUIDialogProvider.prototype.getFeedbackDialog = function(tit, sURL) {
    var oDialog = new sap.ui.commons.Dialog('feedbackDialog', {
        modal: 				true,
        keepInWindow: 		true,
        showCloseButton: 	false
    });
    oDialog.setTitle(tit);
    oDialog.setMinHeight("700px");
    oDialog.setMinWidth("1000px");
    feedbackHTML = new sap.ui.core.HTML({
    	content: "<iframe  width=\"100%\" height=\"600px\" src=\"" + sURL + "\" ></iframe>",
    	sanitizeContent: true
    });
    oDialog.addContent(feedbackHTML);
    oDialog.addButton(new sap.ui.commons.Button({
        text: oBundle.getText("BTN_CLS_TXT"),
        press: function() {oDialog.close();}
    }));
    return oDialog;
};
