jQuery.sap.declare(sluiCore.mod.jsbrowse);

/*
 * id: ID for the control
 * type: suiCnst.SLP_DIA_ATTR_TXTINP_DIRECTORY or suiCnst.SLP_DIA_ATTR_TXTINP_FILE
 * layout: sap.ui.layout.GridData Object (e.g. sap.ui.layout.GridData({span: "L6 M6 S12", linebreak: false}))
 * title: string (title of the browser tree window, e.g. "Please select a File")
 * filter: oData style filter that can be appendes as URL parameter, e.g. "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27"
 */

SLUIFileBrowser = function(id, type, layout, title, filter, chgCB) {
	this.pickedNode = undefined;
	this.type = type;
	this.title = title;
	this.filter = filter;
	var options = {
		"showValueHelp": 	true,
		"valueHelpRequest": $.proxy(this.browse, this)
	};

	if (layout) options.layoutData = layout;
	if (chgCB) options.change = chgCB;
	
	if (id) return new sap.m.Input(id, options); 
	else return new sap.m.Input(options);
};


SLUIFileBrowser.prototype.browse = function(evt){
	function explorer() {
		var popup;
		var browseArea;
		var oNodeRoot;
		var hook;
	}
	var oModel = new sap.ui.model.xml.XMLModel();
	sap.ui.getCore().setModel(oModel, "fileSystemEntries");
	explorer.hook = evt.getSource();
	explorer.popup = new sap.ui.commons.Dialog({modal: true, resizable: false});
	explorer.popup.setTitle(this.title);
	explorer.popup.setWidth("600px");
	explorer.popup.setHeight("350px");
	explorer.popup.attachClosed(function(evt) {
		explorer.browseArea.removeAllNodes();
		explorer.browseArea.destroyNodes();
		explorer.oNodeRoot.removeAllNodes();
		explorer.oNodeRoot.destroyNodes();
		explorer.oNodeRoot = undefined;
	});
	explorer.browseArea = new sap.ui.commons.Tree({width: "570px", height: "auto", selectionMode: sap.ui.commons.TreeSelectionMode.Single, select: SLUIFileBrowser.prototype.pick});
	explorer.browseArea.setShowHeader(false);
	explorer.browseArea.setTitle("Explorer");
	explorer.browseArea.setShowHeaderIcons(true);
	explorer.browseArea.setShowHorizontalScrollbar(false);
	explorer.browseArea.attachBrowserEvent("dblclick", $.proxy(function(){if (SLUIFileBrowser.prototype.picked(oModel, explorer.oNodeRoot, this.type, false, explorer.hook, this.filter)) explorer.popup.close();}, this));
	var preSel = (explorer.hook.getValue().length?explorer.hook.getValue():"/").split(/[/\\]/);
	if (preSel && (preSel[preSel.length-1] !== "")) preSel.push("");			
	var text, icon, drive, winUNC = false;
	if (explorer.hook.getValue().substr(0, 2) === "\\\\") {
		winUNC = true;
		preSel.shift(); preSel.shift();
		text = "\\\\\\\\"+preSel[0];
		icon = "slui/resources/others/network.gif";
		drive = preSel[0] = "\\\\"+preSel[0]; 
		preSel.shift();
	}
	else if (preSel[0][1] == ':') {
		text = preSel[0];
		icon = "slui/resources/others/disk.gif";
		drive = preSel[0]; 
		preSel.shift();
	} 
	else if ((globals.osDirSeparator === "\\") && (explorer.hook.getValue()==="")) {
		preSel.shift();
		text = location.hostname;
		icon = "slui/resources/others/system.gif";
		drive = "";														
	}
	else {
		if (explorer.hook.getValue()!=="") {preSel.shift(); drive = globals.osDirSeparator;}
		else drive = "";
		text = globals.osDirSeparator;
		icon = "slui/resources/others/folder.gif";
	}
	explorer.oNodeRoot = new sap.ui.commons.TreeNode({text: text, icon: icon, expanded: true});
	// now, I need to do strange things. Sometimes (don't know why and when), one of the preceeding "\\" for Windows-UNC-paths gets lost in the deep internals of the SAPUI5 controls.
	// So I prospectively have put four "\" into the control and look now, whether all 4 "\" do survived. If yes, I eliminate 2 of them afterwards. If not, I'm fine. 
	// Sorry for that, but only with this completely crazy method, I can make sure, that the correct UNC-Path survives in the SAPUI5 control. 
	if (explorer.oNodeRoot.getText().substr(0, 4) === "\\\\\\\\") explorer.oNodeRoot.setText(text = explorer.oNodeRoot.getText().slice(2));
	explorer.oNodeRoot.addCustomData(new sap.ui.core.CustomData({key: "type", value: "slp.fileSystemEntry.type.DIRECTORY"}));
	explorer.oNodeRoot.addCustomData(new sap.ui.core.CustomData({key: "path", value: text}));

	var scrollInd = 0;
	var scrollMax = 0;
	for (var i=0, path=drive, thisNode=explorer.oNodeRoot, nextNode, success=cont=true; success && cont && (i < preSel.length); i++) {
		var boolArry = SLUIFileBrowser.prototype.exploreTree(oModel, thisNode, this.type, path, this.filter);
		success = boolArry[0];
		cont = boolArry[1];
		nextNode = thisNode.getNodes().find(function(elem){return (elem.getProperty("text") === preSel[i]);});
		if (nextNode) {
			thisNode = nextNode;
			scrollInd += thisNode.getParent().indexOfNode(thisNode);
			scrollMax += thisNode.getParent().getNodes().length;
			nextNode.expand(false, false);
			winUNC = false; //from now on, we can even treat WinUNC paths like normal paths because we found one existing level
		}
		else if (winUNC) { 
			if (text.slice(text.length-1) !== globals.osDirSeparator) text += globals.osDirSeparator;
			text += preSel[i];
			explorer.oNodeRoot.setText(text); 
			if (explorer.oNodeRoot.getText().substr(0, 4) === "\\\\\\\\") explorer.oNodeRoot.setText(explorer.oNodeRoot.getText().slice(2));
			explorer.oNodeRoot.getCustomData()[1].setValue(text);
			if (explorer.oNodeRoot.getCustomData()[1].getValue().substr(0, 4) === "\\\\\\\\") explorer.oNodeRoot.getCustomData()[1].setValue(explorer.oNodeRoot.getCustomData()[1].getValue().slice(2));
		}
		else {cont = false; scrollMax += thisNode.getNodes().length;}
		if (path.slice(path.length-1) !== globals.osDirSeparator) path += globals.osDirSeparator;
		path += preSel[i];
	}
	if (!success) sap.m.MessageToast.show("Error: No file system access.");
	SLUIFileBrowser.prototype.set(thisNode).select(false, true);
	explorer.browseArea.addNode(explorer.oNodeRoot);
	explorer.popup.scrollRatio = (scrollMax == 0) ? 0 : scrollInd / scrollMax; 	//calculate ratio where to find preselected entry in tree! this is cool! 
	explorer.popup.addContent(explorer.browseArea);
	var oBtnCn = new sap.ui.commons.Button({text: "Cancel", press: function () {explorer.popup.close();}});
	var oBtnOk = new sap.ui.commons.Button({
		text: "OK", 
		press: $.proxy(function(){if (SLUIFileBrowser.prototype.picked(oModel, explorer.oNodeRoot, this.type, true, explorer.hook, this.filter)) explorer.popup.close();}, this)
	});
	explorer.popup.addButton(oBtnOk);
	explorer.popup.addButton(oBtnCn);
	// try to scroll to the selected position if everything works as expected...
	// However, do it later, even later than onAfterRendering, let's say 500ms afterwards (sorry, we have no later event)
	explorer.popup.addEventDelegate(
	{
		onAfterRendering: function(evt) {
			this.ctrl = "";
			setTimeout($.proxy(function scroll(){ 
				var ctrl = this.getDomRef("cont");
				if (ctrl && ctrl.scrollHeight && $(ctrl) && (typeof $(ctrl).scrollTop === "function"))
					$(ctrl).scrollTop(Math.floor(this.scrollRatio * ctrl.scrollHeight));  //awesome algorithm, isn't it? Don't forget to like it...  ;-)
				if (this.ctrl != ctrl) {this.ctrl = ctrl; setTimeout($.proxy(scroll, this), 500);}
			}, this), 500);
		}
	}, explorer.popup); 
	explorer.popup.open();
};


SLUIFileBrowser.prototype.getFileSystemEntries = function(oModel, path, urlparam) {
	if (path && ((path[0] !== globals.osDirSeparator) || (path.substr(0, 2) === "\\\\"))) path = "/" + path;
	//windows backslashes need to be changed to slashes except the windows network UNC double backslash
	//special characters must be URLencoded except the slashes 
	path = encodeURIComponent(path.replace(/\\\\/g, "\%5C\%5C").replace(/\\/g, "/").replace(/\%5C\%5C/g, "\\\\")).replace(/\%2F/g, "/");
	$.ajax({
		type: 		"GET",
		url: 		oStub.oFather.oProcExe.oUIProc.urls.fsEntriesUrl + path + (urlparam ? "?" + urlparam : ""),
		dataType: 	"text",
		cache: 		false,
		async : 	false,
		success: 	function (xml) {oModel.setXML(xml);},
		error: 		function (xhr, options, errorText) {
						oModel.setXML('<?xml version="1.0" encoding="UTF-8" standalone="yes"?><fileSystemEntries />');
						sap.m.MessageToast.show("Error: Server does not answer Filesystem request");
						jQuery.sap.log.error("GET /fileSystemEntries Failure: " + errorText);
					}
	});
};


SLUIFileBrowser.prototype.exploreTree = function (oModel, oNode, sType, path, urlparam) {
	SLUIFileBrowser.prototype.getFileSystemEntries(oModel, path, urlparam);
	oNode.destroyNodes();
	this.arry 	= [];
	this.path 	= path;
	this.sType 	= sType;
	var list 	= $(oModel.getXML()).find("fileSystemEntry");
	this.cont 	= !list.length; //this is a flag indicating whether subdirectories for potential further iterations are in the result list 
	oNode.setHasExpander(!this.cont); //at this point of time we know exactly whether the selected subdir has children --> update the expand symbol
	try {
		list.each($.proxy(function(ind, act){
			var escaped = false; //this is an indicator whether curly brackets are used -> SAPUI5 controls behave differently then
			var expander = false; //this is a flag indicating whether the treenode should get an expand symbol, otherwise it gets an end dot.
			var doubleEscSystem; 
			var name = $(act).find("name").text();	
			var type = $(act).find("type").text();
			var absPath = this.path + ((this.path.slice(this.path.length-1) !== globals.osDirSeparator) ? globals.osDirSeparator : "") + name;
			var icon = "";
			if      (type === "slp.fileSystemEntry.type.FILE") {if (this.sType === suiCnst.SLP_DIA_ATTR_TXTINP_DIRECTORY) return; icon = "slui/resources/others/file.gif";}
			else if (type === "slp.fileSystemEntry.type.DIRECTORY") { 
				this.cont = true; //yes, directory found; caller might want to continue drowning deeper
				expander = true;  //show directories as expandable (='triangle') by default; status can change to 'dot' later
				if ((globals.osDirSeparator === "\\") && (name.length === 2) && (name[1] === ":")) icon = "slui/resources/others/disk.gif";
				else icon = "slui/resources/others/folder.gif"; 
			}
			if ((absPath.indexOf("{") > -1) || (absPath.indexOf("}") > -1)) {
				escaped = true; //yes, curly brackets found; probably need to extra-escape them 
				name = name.replace(/{/g, "\\{").replace(/}/g, "\\}");
			}
			var tempNode = 	new sap.ui.commons.TreeNode({text: name, icon: icon, expanded: false, hasExpander: expander, toggleOpenState: function(evt){
				var oNodeSel = evt.getSource();
				oNodeSel.destroyNodes();
				oNodeSel.select(false, true);
				if (oNodeSel.getExpanded()) $("#"+oNodeSel.getId()).dblclick();
			}});
			if (escaped) { //now I need to check whether the extra-escaping was good
				var nodeName = tempNode.getText();
				doubleEscSystem = ((nodeName.indexOf("\\{") > -1) || (nodeName.indexOf("\\}") > -1)) ? false : ((nodeName.indexOf("{") > -1) || (nodeName.indexOf("}") > -1)) ? true : undefined;
				if (doubleEscSystem === false) tempNode.setText(nodeName.replace(/\\{/g, "{").replace(/\\}/g, "}"));    //change back 
			}
			tempNode.addCustomData(new sap.ui.core.CustomData({key: "type", value: type}));
			// now, I need to do strange things. Sometimes (don't know why and when), one of the preceeding "\\" for Windows-UNC-paths gets lost in the deep internals of the SAPUI5 controls.
			// So I prospectively put four "\" into the control and look afterwards, whether all 4 "\" do survive. If yes, I eliminate 2 of them afterwards. If not, I'm fine. 
			// Sorry for that, but only with this completely crazy method, I can make sure, that the correct UNC-Path survives in the SAPUI5 control. 
			var tempCstD;
			if (doubleEscSystem != false) {
				var cmp = absPath.replace(/\\/g, "\\\\").replace(/\\\\\\\\/, "\\\\\\\\\\\\\\\\").replace(/{/g, "\\\{").replace(/}/g, "\\\}");
				tempCstD = new sap.ui.core.CustomData({key: "path", value: cmp});
				if (!doubleEscSystem && (tempCstD.getValue() === cmp)) tempCstD.setValue(absPath.replace(/\\\\/, "\\\\\\\\"));
			}
			else tempCstD = new sap.ui.core.CustomData({key: "path", value: absPath.replace(/\\\\/, "\\\\\\\\")});
			if (tempCstD.getValue().substr(0, 4) === "\\\\\\\\") tempCstD.setValue(tempCstD.getValue().slice(2));
			tempNode.addCustomData(tempCstD);
			this.arry.push(tempNode);
		}, this));
		this.arry.sort(function(a, b) {
			var ac = a.getProperty("text");
			var bc = b.getProperty("text");
			return ac > bc ? 1 : ac < bc ? -1 : 0;
		});
		for (var i = 0; i < this.arry.length; i++) oNode.addNode(this.arry[i]);
	}
	catch (err) {return [false, false];}
	return [true, this.cont];
};


SLUIFileBrowser.prototype.set = function(oNode) {
	this.pickedNode = oNode;
	return oNode;
};


SLUIFileBrowser.prototype.pick = function(evt) {
	SLUIFileBrowser.prototype.set(evt.getParameter("node"));
};


SLUIFileBrowser.prototype.picked = function(oModel, oNode, sType, bExplicit, hook, urlparam) {
	function findType(elem) {return elem.getProperty("key") === "type";}
	function findPath(elem) {return elem.getProperty("key") === "path";}
	function deepFindSelected(oNode) {
		if (oNode.getIsSelected()) return oNode;
		else {
			var selNode = oNode.getNodes().find(function(elem){return elem.getIsSelected();});
			if (selNode) {
				oNode.getNodes().forEach(function(elem){if (elem != selNode) elem.collapse();});
				selNode.expand(false, false);
				return selNode;
			}
			var expNode = oNode.getNodes().find(function(elem){return elem.getExpanded();});
			return expNode ? deepFindSelected(expNode) : oNode;				
		}
	}
	if (this.pickedNode || bExplicit) {
		var name = this.pickedNode.getProperty("text");
		var type = this.pickedNode.getCustomData().find(findType).getProperty("value");
		var absPath = this.pickedNode.getCustomData().find(findPath).getProperty("value");
		if (absPath === location.hostname) absPath = "";
		if      ((type === "slp.fileSystemEntry.type.FILE") || bExplicit) {
			if ((absPath.length > 2) && (absPath[0]==="\\") && (absPath[2]===":")) absPath = absPath.slice(1);
			if ((type === "slp.fileSystemEntry.type.DIRECTORY") && (absPath.slice(absPath.length-1) !== globals.osDirSeparator)) absPath += globals.osDirSeparator;
			hook.setValue(absPath);
			hook.fireChange();
			return true;
		}
		else if (type === "slp.fileSystemEntry.type.DIRECTORY") if (!SLUIFileBrowser.prototype.exploreTree(oModel, deepFindSelected(oNode), sType, absPath, urlparam)[0]) sap.m.MessageToast.show("Error: No file system access.");
	}	
	return false;
};

