sap.ui.jsview(sluiCore.mod.jshelp, {
	data: {},
	supplyData: function() {},
	createContent: function(oController) {
		var oHLytIcons = new sap.ui.commons.layout.HorizontalLayout({width: "100%"});
		//--------------------------------------------------------------------------------------------------------------
		//Task Status Icons
		//-------------------------------------------------------------------------------------------------------------- 
		var statusData = [{
			statusName: 	oBundle.getText("INI_STS_LBL_TXT"),
			src: 			"sap-icon://status-negative",
			color: 			"#8F8F8F"
		}, {
			statusName: 	oBundle.getText("RUN_STS_LBL_TXT"),
			src: 			"sap-icon://media-play",
			color: 			"#007dc0"
		}, {
			statusName: 	oBundle.getText("ERR_STS_LBL_TXT"),
			src: 			"sap-icon://message-error",
			color: 			"#cc0000"
		}, {
			statusName: 	oBundle.getText("DIA_STS_LBL_TXT"),
			src: 			"sap-icon://status-inactive",
			color: 			"#fdc411"
		}, {
			statusName: 	oBundle.getText("FIN_STS_LBL_TXT"),
			src: 			"sap-icon://status-completed",
			color: 			"#008b00"
		}, {
			statusName: 	oBundle.getText("ABR_STS_LBL_TXT"),
			src: 			"sap-icon://sys-cancel",
			color: 			"#cc0000"
		}, {
			statusName: 	oBundle.getText("SKP_STS_LBL_TXT"),
			src: 			"sap-icon://overlay",
			color: 			"#007dc0"
		}, {
			statusName: 	oBundle.getText("ACN_STS_LBL_TXT"),
			src: 			"sap-icon://to-be-reviewed",
			color: 			"#007dc0"
		}, {
			statusName: 	oBundle.getText("BRK_STS_LBL_TXT"),
			src: 			"sap-icon://navigation-right-arrow",
			color: 			"#fdc411"
		}, {
			statusName: 	oBundle.getText("UNK_STS_LBL_TXT"),
			src: 			"sap-icon://refresh",
			color: 			"#70c070"
		}];
		var oStatusTable = new sap.ui.table.Table({
			visibleRowCount:	 	10,
			selectionMode: 			sap.ui.table.SelectionMode.None,
			editable: 				false,
			width: 					"255px",
			enableColumnReordering:	false
		});
		var oStatusIcon = new sap.ui.core.Icon( {   
            size: 					"15px",  
            activeColor: 			"white",  
            activeBackgroundColor: 	"transparent",  
            width: 					"15px"
        });
		oStatusIcon.bindProperty(suiCnst.UI5_ATTR_ISRC, "src");
		oStatusIcon.bindProperty(suiCnst.UI5_ATTR_COLOR, "color");
		oStatusTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_ICO_TXT")}),
			template: 	oStatusIcon,
			width: 		"50px",
			hAlign: 	"Center",
			resizable: 	false
		}));
		oStatusTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_MEA_TXT")}),
			template: 	new sap.ui.commons.TextView().bindProperty("text", "statusName"),
			width: 		"200px",
			resizable: 	false
		}));
		var oStatusModel = new sap.ui.model.json.JSONModel();
		oStatusModel.setData({modelData: statusData});
		oStatusTable.setModel(oStatusModel);
		oStatusTable.bindRows("/modelData");
		//--------------------------------------------------------------------------------------------------------------
		// Task type images
		//--------------------------------------------------------------------------------------------------------------
		var typeData = [{
			typeName: 	oBundle.getText("PRO_LBL_TXT"),
			src: 		suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_TYPE + "/ico_process.png",
			color: 		"#66a800"
		}, {
			typeName: 	oBundle.getText("TAK_LBL_TXT"),
			src: 		suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_TYPE + "/ico_task.png",
			color: 		"#eeeeee"
		}, {
			typeName: 	oBundle.getText("SER_LBL_TXT"),
			src: 		suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_TYPE + "/ico_service.png",
			color: 		"#eeeeee"
		}, {
			typeName: 	oBundle.getText("RDM_LBL_TXT"),
			src: 		suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_TYPE + "/ico_roadmap.png",
			color: 		"#eeeeee"
		}];
		var oTypeTable = new sap.ui.table.Table({
			visibleRowCount: 			10,
			selectionMode: 				sap.ui.table.SelectionMode.None,
			editable: 					false,
			width: 						"255px",
			enableColumnReordering: 	false
		});
		oTypeTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_ICO_TXT")}),
			template: 	new sap.ui.commons.Image({width:"16px",height:"16px"}).bindProperty(suiCnst.UI5_ATTR_ISRC, "src"),
			width: 		"50px",
			hAlign: 	"Center",
			resizable: 	false
		}));
		oTypeTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_MEA_TXT")}),
			template: 	new sap.ui.commons.TextView().bindProperty("text", "typeName"),
			width: 		"200px",
			resizable: 	false
		}));
		var oTypeModel = new sap.ui.model.json.JSONModel();
		oTypeModel.setData({modelData: typeData});
		oTypeTable.setModel(oTypeModel);
		oTypeTable.bindRows("/modelData");
		//--------------------------------------------------------------------------------------------------------------
		// Log format types 
		//--------------------------------------------------------------------------------------------------------------
		var logFrmtData = [{
			formatName: 	oBundle.getText("CSV_LBL_TXT"),
			src: 			"sap-icon://excel-attachment",
			color: 			"#000000"
		}, {
			formatName: 	oBundle.getText("GLF_LBL_TXT"),
			src: 			"sap-icon://document-text",
			color: 			"#000000"
		}, {
			formatName: 	oBundle.getText("HTM_LBL_TXT"),
			src: 			"sap-icon://attachment-html",
			color: 			"#000000"
		}, {
			formatName: 	oBundle.getText("TEXT_LBL_TXT"),
			src: 			"sap-icon://attachment-text-file",
			color: 			"#000000"
		}, {
			formatName: 	oBundle.getText("XML_LBL_TXT"),
			src: 			"sap-icon://create",
			color: 			"#000000"
		}];
		var oLogFrmtTable = new sap.ui.table.Table({
			visibleRowCount: 			10,
			selectionMode: 				sap.ui.table.SelectionMode.None,
			editable: 					false,
			width: 						"255px",
			enableColumnReordering: 	false
		});
		var oLogFrmtIcon = new sap.ui.core.Icon({  
                    size: 					"15px",  
                    activeColor: 			"white",  
                    activeBackgroundColor: 	"transparent",  
                    width: 					"15px"
		});
		oLogFrmtIcon.bindProperty(suiCnst.UI5_ATTR_ISRC, "src");
		oLogFrmtIcon.bindProperty(suiCnst.UI5_ATTR_COLOR, "color");
		oLogFrmtTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_ICO_TXT")}),
			template: 	oLogFrmtIcon,
			width: 		"50px",
			hAlign: 	"Center",
			resizable: 	false
		}));
		oLogFrmtTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_MEA_TXT")}),
			template: 	new sap.ui.commons.TextView().bindProperty("text", "formatName"),
			width: 		"200px",
			resizable: 	false
		}));
		var oLogModel = new sap.ui.model.json.JSONModel();
		oLogModel.setData({modelData: logFrmtData});
		oLogFrmtTable.setModel(oLogModel);
		oLogFrmtTable.bindRows("/modelData");
		//--------------------------------------------------------------------------------------------------------------
		// breakpoint status types
		//--------------------------------------------------------------------------------------------------------------
		var brkStatusData = [{
			statusName: 	oBundle.getText("BEF_STP_TXT"),
			src: 			"sap-icon://past",
			color: 			"#009823"
		}, {
			statusName: 	oBundle.getText("CUR_STP_TXT"),
			src: 			"sap-icon://present",
			color: 			"#fdc411"
		}, {
			statusName: 	oBundle.getText("AT_STP_TXT"),
			src: 			"sap-icon://future",
			color: 			"#005cd0"
		}];
		var obrkStatTable = new sap.ui.table.Table({
			visibleRowCount: 			10,
			selectionMode: 				sap.ui.table.SelectionMode.None,
			editable: 					false,
			width: 						"255px",
			enableColumnReordering: 	false
		});
		var oBrkStatusIcon = new sap.ui.core.Icon({  
			size:					"15px",  
			activeColor: 			"white",  
			activeBackgroundColor: 	"transparent",  
			width: 					"15px"
		});
		oBrkStatusIcon.bindProperty(suiCnst.UI5_ATTR_ISRC, "src");
		oBrkStatusIcon.bindProperty(suiCnst.UI5_ATTR_COLOR, "color");
		obrkStatTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_ICO_TXT")}),
			template: 	oBrkStatusIcon,
			width: 		"50px",
			hAlign: 	"Center",
			resizable: 	false
		}));
		obrkStatTable.addColumn(new sap.ui.table.Column({
			label: 		new sap.ui.commons.Label({text: oBundle.getText("TBL_CLMN_HDR_MEA_TXT")}),
			template: 	new sap.ui.commons.TextView().bindProperty("text", "statusName"),
			width: 		"200px",
			resizable: 	false
		}));
		var oBrkStatModel = new sap.ui.model.json.JSONModel();
		oBrkStatModel.setData({modelData: brkStatusData});
		obrkStatTable.setModel(oBrkStatModel);
		obrkStatTable.bindRows("/modelData");
		//--------------------------------------------------------------------------------------------------------------
		//assign to root container
		//--------------------------------------------------------------------------------------------------------------
		var oVLytStatusIcons = new sap.ui.commons.layout.VerticalLayout({
			width: "100%",
			content: [new sap.ui.commons.TextView({
				text: 		oBundle.getText("TBL_HDR_STS_ICO_TXT"),
				design: 	sap.ui.commons.TextViewDesign.H6,
				textAlign: 	sap.ui.core.TextAlign.Center
			}), oStatusTable]
		});
		var oVLytTypeIcons = new sap.ui.commons.layout.VerticalLayout({
			width: "100%",
			content: [new sap.ui.commons.TextView({
				text: 		oBundle.getText("TBL_HDR_TYP_ICO_TXT"),
				design: 	sap.ui.commons.TextViewDesign.H6,
				textAlign: 	sap.ui.core.TextAlign.Center
			}), oTypeTable]
		});
		var oVLytLgFrmtIcons = new sap.ui.commons.layout.VerticalLayout({
			width: "100%",
			content: [new sap.ui.commons.TextView({
				text: 		oBundle.getText("TBL_HDR_LOG_FORM_TXT"),
				design: 	sap.ui.commons.TextViewDesign.H6,
				textAlign: 	sap.ui.core.TextAlign.Center
			}), oLogFrmtTable]
		});		
		var oVLytBrkStatIcons = new sap.ui.commons.layout.VerticalLayout({
			width: "100%",
			content: [new sap.ui.commons.TextView({
				text: 		oBundle.getText("TBL_HDR_BR_STS_ICO_TXT"),
				design: 	sap.ui.commons.TextViewDesign.H6,
				textAlign: 	sap.ui.core.TextAlign.Center
			}), obrkStatTable]
		});
		oHLytIcons.addContent(oVLytStatusIcons);
		oHLytIcons.addContent(oVLytTypeIcons);
		oHLytIcons.addContent(oVLytBrkStatIcons);
		oHLytIcons.addContent(oVLytLgFrmtIcons);
		return oHLytIcons;
	},
	updateContent: function() {}
});
