jQuery.sap.declare(sluiCore.mod.jslogtail);

/*
 */

SLUILogTail = function(id, tool, sid) {
	var obj;
	var options = {
		"modal": 	false,
		"resizable": true
	};
	this.tool = tool;
	this.sid = sid;
	this.timeoutID = false;
	this.sapupLogFilesXML = "";
	this.getMainLogfileNames();

	if (id) obj = new sap.ui.commons.Dialog(id, options); 
	else obj = new sap.ui.commons.Dialog(options);
	
    obj.setTitle("Log Tail Viewer");
    obj.setWidth("600px");
    obj.setHeight("350px");
    obj.attachClosed($.proxy(function() {this.stopPoll();}, this));

    this.selector = new sap.ui.commons.DropdownBox();
    this.selector.setTooltip("Logfile to tail");
    this.selector.setEditable(true);
    this.selector.setWidth("200px");
	
	/*** get main log files ***/
	var logs = this.sapupLogFilesXML.getElementsByTagName("Log");
	for (var i = 0; i < logs.length; i++) {
		var singleLogElement = $(logs[i]).find('displayName').first().text();
		if ((singleLogElement === "SAPup.log") || (singleLogElement.startsWith("SAPup_") && singleLogElement.endsWith(".log"))) {
			this.selector.setValue(singleLogElement	);
		}
		var oItem = new sap.ui.core.ListItem();
		oItem.setText(singleLogElement);
		this.selector.addItem(oItem);
	}
	
	obj.addContent(this.selector);
	obj.addContent(new sap.ui.commons.HorizontalDivider());
	
	this.logArea = new sap.ui.commons.TextArea({editable: false,  width: "100%", height: "200px"});
    obj.addContent(this.logArea);
	sap.ui.core.ResizeHandler.register(this.logArea, function(evt){evt.control.setHeight(evt.control.getParent().getHeight().split("px")[0]-145+"px");});

	var oBtnPs = new sap.ui.commons.Button({icon: "sap-icon://pause", tooltip: "Pause", press: $.proxy(function(evt) {
		if (evt.getSource().getIcon() === "sap-icon://pause") {                	     
			window.clearInterval(this.timeoutID);
			evt.getSource().setIcon("sap-icon://play").setTooltip("Continue");
		} else {
			this.timeoutID = window.setInterval($.proxy(this.poll, this), 2000);
			evt.getSource().setIcon("sap-icon://pause").setTooltip("Pause");
		} 
	}, this)});
	var oBtnOk = new sap.ui.commons.Button({text: "Close", press: $.proxy(function() {
			window.clearInterval(this.timeoutID);
			obj.close();
	}, this)});
	obj.addButton(oBtnPs);
	obj.addButton(oBtnOk);
	obj.open();

	this.stopPoll();
	this.poll();
	this.timeoutID = window.setInterval($.proxy(this.poll, this), 2000);
	
	return obj;
};


SLUILogTail.prototype.poll = function() {
	if (Boolean(this.selector.getValue())) $.ajax({
		type: "GET",
		url: "/slp/" + this.tool + "/" + this.sid + "/logs/" + encodeURIComponent(this.selector.getValue()) + "?lineoffset=-100",
		cache: false,
		dataType: "text",
		success: $.proxy(function(logcontent) {
			var logAreaId = this.logArea.getId();
			this.logArea.setValue(logcontent);
			$('#' + logAreaId).scrollTop($('#' + logAreaId)[0].scrollHeight);
		}, this),
		error: $.proxy(function(xhr, options, errorText) {
			this.logArea.setValue("Error: " + errorText);
		}, this)
	});
	else this.logArea.setText("No data available");
};

SLUILogTail.prototype.stopPoll = function() {
	if (this.timeoutID != false) {
		window.clearInterval(this.timeoutID);
		this.timeoutID = false;
	}
};          

SLUILogTail.prototype.getMainLogfileNames = function() {
	$.ajax({
		type: "GET",
		url: "/slp/" + this.tool + "/" + this.sid + "/logs?mainlogs=on",
		dataType: "xml",
		async: false,
		success: $.proxy(function(monitorContent) {
					this.sapupLogFilesXML = monitorContent;
				},this),
		error: function(xhr, options, errorText) {
					return("<logs><Log><displayName>No log files available ...</displayName><Log><logs>");
				}
	});
};

