sap.ui.jsview(sluiCore.mod.jslogs, {
	processLogsListContainer: 	undefined,
	logsListTable: 				undefined,
	logsModel: 					undefined,
	calloutLog: 				undefined,
	overlayLog: 				undefined,
	logsData: 					undefined,
	visibleRow: 				-12,
	sLogId: 					undefined,
	
	supplyData: function() {this.updateContent();},
	
	createContent: function(oController) {
		this.processLogsListContainer = new sap.ui.commons.layout.VerticalLayout({width: "100%"});
		this.createLogTable();
		return this.processLogsListContainer;
	},
	
	updateContent: function(update) {
		this.logsData = oStub.oFather.oProcExe.oUIProc.logLst;
		if (this.logsListTable) {
			this.logsListTable.setModel(this.logsData);
			this.logsListTable.bindRows("/Log");
			this.logsListTable.rerender();
		} 
		else if (!this.processLogsListContainer) this.createContent();
		if (this.logsData) this.removeNoDataColumn();
		if (update) {
			oStub.oFather.oProcExe.getSLPLogs();
			this.logsListTable.setBusy(true);
			var oNoDataLbl = new sap.ui.commons.Label({text: oBundle.getText("LOAD_LOG_LBL_TXT")});
			oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
			this.logsListTable.setNoData(oNoDataLbl);
		} else {
			this.logsListTable.setBusy(false);
			var oNoDataLbl = new sap.ui.commons.Label({text: oBundle.getText("NO_LOG_LBL_TXT")});
			oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
			this.logsListTable.setNoData(oNoDataLbl);
		}		
		this.resizeTableHeightForVerticalScroll();
	},
	
	createLogTable: function() {
		var suc = sap.ui.commons;
		var sut = sap.ui.table;
		var oNoDataLbl = new sap.ui.commons.Label({text: oBundle.getText("LOAD_LOG_LBL_TXT")});
		oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
		this.logsListTable = new sut.Table("_slui_table_logs", {noData: oNoDataLbl});
		this.addLogFormatColumn();
		this.addDescriptionColumn();
		this.addLastModifiedColumn();
		this.addSizeColumn();
		this.logsListTable.setToolbar(new suc.Toolbar({
			rightItems: [(new suc.Button("_slui_tbl_logs_tbar_refresh_btn", {
				text: 		oBundle.getText("BTN_REF_TXT"),
				tooltip: 	oBundle.getText("REF_LOG_TIP_TXT"),
				icon: 		"sap-icon://refresh",
				press: function(e) {
					if (e) {e.preventDefault();}
					oStub.oFather.getView().vLogs.logsListTable.setModel(undefined);
					oStub.oFather.getView().vLogs.logsListTable.bindRows("/Log");
					oStub.oFather.getView().vLogs.logsListTable.rerender();
					oStub.oFather.getView().vLogs.logsListTable.setBusy(true);
					var oNoDataLbl = new sap.ui.commons.Label({text: oBundle.getText("LOAD_LOG_LBL_TXT")});
					oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
					oStub.oFather.getView().vLogs.logsListTable.setNoData(oNoDataLbl);
					for (var i=0; i < oStub.oFather.getView().vLogs.logsListTable.getColumns().length; i++) {
						oStub.oFather.getView().vLogs.logsListTable.getColumns()[i].setSorted(false);
						oStub.oFather.getView().vLogs.logsListTable.getColumns()[i].setFiltered(false);
					}
					oStub.oFather.oProcExe.getSLPLogs();
				}
			})).addStyleClass("refBtnIcon")]
		}));
		this.logsListTable.setSelectionMode(sut.SelectionMode.None);
		this.logsListTable.setColumnHeaderVisible(true);
		this.logsListTable.setModel(this.logsData);
		this.logsListTable.bindRows("/Log");
		this.processLogsListContainer.addContent(this.logsListTable);
	},
	
	addLogFormatColumn: function() {
		var suc = sap.ui.commons;
		var sut = sap.ui.table;
		var oLogFrmtIcon = new sap.ui.core.Icon({  
            size : 					"15px",  
            color: 					"#000000",
            activeColor: 			"white",  
            activeBackgroundColor: 	"transparent",  
			decorative: 			false,								//SUM_DMO_SAPUI5_ACC_SP19_ACC-264             
            width: 					"15px",
			press: function(evt) {
				var _a = evt.getSource().data("logfile").split("/");
				if (_a && _a.length) saveFile(_a[_a.length-1]);
			}
        });
		var oCustData = new sap.ui.core.CustomData({key: "logfile", value: ""});
		oCustData.bindProperty(suiCnst.SLP_PARAM_VALUE, suiCnst.SLP_LOG_CONTENT, function(oValue) {return oValue;}); 
		oLogFrmtIcon.addCustomData(oCustData);
		oLogFrmtIcon.bindProperty(suiCnst.UI5_ATTR_ISRC, suiCnst.SLP_LOG_FORMAT, function(oValue) {return oLogViewHelper.generateFormatIcon(oValue);});
		oLogFrmtIcon.bindProperty(suiCnst.UI5_ATTR_TTIP, suiCnst.SLP_LOG_FORMAT, function(oValue) {return oLogViewHelper.generateFormatTooltip(oValue);});
		oLogFrmtIcon.bindProperty(suiCnst.UI5_ATTR_ALT, suiCnst.SLP_LOG_FORMAT, function(oValue) {
			return oLogViewHelper.generateFormatTooltip(oValue);								//SUM_DMO_SAPUI5_ACC_SP19_ACC-264
		});
		oLblHdr = new suc.Label({	icon: 		"sap-icon://download",
									tooltip: 	"Click to download log file",	
									textAlign: 	"Center"						});
		var oColFormat = new sut.Column("_slui_tbl_column_logsFormat", {
			label: 		oLblHdr,
			template: 	oLogFrmtIcon,
			width: 		"39px",
			hAlign: 	"Center"
		});
		this.logsListTable.addColumn(oColFormat);
	},
	
	addDescriptionColumn: function() {
		var suc = sap.ui.commons;
		var sut = sap.ui.table;
		var oLnkVw1 = new suc.Link({width: "100%"});
		oLnkVw1.attachPress(function(oEvent) {
			var sLog = oEvent.getSource().getText();
			var path = oEvent.getSource().getBindingContext().sPath;
			if (path) path = parseInt(path.replace("/Log/", ""));
			var oIndexModel = $(oEvent.getSource().getBindingContext().getModel().oData).find("Log")[path];
			if (oIndexModel) {
				if ($(oIndexModel).find(suiCnst.SLP_LOG_FORMAT).text() === "slp.log.format.XML") window.open(oStub.oFather.globProps.sluiBaseUrl + encodeURIComponent($(oIndexModel).find(suiCnst.SLP_LOG_CONTENT).text()).replace(/\%2F/g, "/"));
				else sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vLogs.getLogContent(encodeURIComponent($(oIndexModel).find(suiCnst.SLP_LOG_CONTENT).text()).replace(/\%2F/g, "/"));                                
			}
		});
		oLnkVw1.bindProperty(suiCnst.UI5_ATTR_TEXT, suiCnst.SLP_LOG_DISPNAME);
		oLnkVw1.bindProperty(suiCnst.UI5_ATTR_TTIP, suiCnst.SLP_LOG_DISPNAME);
		var oLblHdr = new suc.Label({text: oBundle.getText("TBL_CLMN_HDR_LDEC_TXT")});
		var oColKey = new sut.Column("_slui_tbl_column_logsId", {	label: 			oLblHdr,
																	template: 		oLnkVw1,
																	width: 			"50%",
																	sortProperty:  	suiCnst.SLP_LOG_DISPNAME,
																	filterProperty:	suiCnst.SLP_LOG_DISPNAME	});
		this.logsListTable.addColumn(oColKey);
	},
	
	addLastModifiedColumn: function() {
		var suc = sap.ui.commons;
		var sut = sap.ui.table;
		var oTxtVw1 = new suc.TextView({width: "100%"});
		oTxtVw1.bindProperty(suiCnst.UI5_ATTR_TEXT, suiCnst.SLP_LOG_LAST_MODIFIED, function(oValue) {
			if (oValue) return oValue.substring(0, 4) + "." + oValue.substring(5, 7) + "." + oValue.substring(8, 10) + " - " + oValue.substring(11, 19);
		});
		oTxtVw1.bindProperty(suiCnst.UI5_ATTR_TTIP, suiCnst.SLP_LOG_LAST_MODIFIED, function(oValue) {
			if (oValue) return oBundle.getText("TBL_CLMN_HDR_MOD_TXT") + " : " + oValue.substring(0, 4) + "." + oValue.substring(5, 7) + "." + oValue.substring(8, 10) + " - " + oValue.substring(11, 19);
		});
		var oColLatMod = new sut.Column("_slui_tbl_column_logsLastModiffied", {	label: 			oBundle.getText("TBL_CLMN_HDR_MOD_TXT"),
																				template: 		oTxtVw1,
																				width: 			"31%",
																				sortProperty: 	suiCnst.SLP_LOG_LAST_MODIFIED 			});
		this.logsListTable.addColumn(oColLatMod);
	},
	
	addSizeColumn: function() {
		var suc = sap.ui.commons;
		var sut = sap.ui.table;
		var oTxtVwSize = new suc.TextView({width: "100%"});
		oTxtVwSize.bindProperty(suiCnst.UI5_ATTR_TEXT, suiCnst.SLP_LOG_SIZE, function(oValue) {
			if (oValue) return "" + oValue + " bytes";
		});
		oTxtVwSize.bindProperty(suiCnst.UI5_ATTR_TTIP, suiCnst.SLP_LOG_SIZE, function(oValue) {
			if (oValue) return "" + oValue + " bytes";
		});
		var oColLogSize = new sut.Column("_slui_tbl_column_logSize", {	label: 			oBundle.getText("LOG_SIZ_LBL_TXT"),
																		template: 		oTxtVwSize,
																		width: 			"19%",
																		sortProperty: 	suiCnst.SLP_LOG_SIZE 				});
		this.logsListTable.addColumn(oColLogSize);
	},
	
	removeNoDataColumn: function() {
		if (!this.isTagAvailable(this.logsData, suiCnst.SLP_LOG_LAST_MODIFIED)) this.logsListTable.removeColumn("_slui_tbl_column_logsLastModiffied");
		if (!this.isTagAvailable(this.logsData, suiCnst.SLP_LOG_SIZE)) this.logsListTable.removeColumn("_slui_tbl_column_logSize");
	},
	
	isTagAvailable: function(data, tag) {
		if (data) return ($(data.getData()).find(tag).length > 0);
		else return false;
	},
	
	resizeTableHeightForVerticalScroll: function() {
		var iWidth = $(document).height() - 210;
		iWidth = Math.round(iWidth / 32);					// was: 28 - needed to be adjusted for SAPUI5 V1.46.0
		this.logsListTable.setVisibleRowCount(iWidth);
		$(window).resize(function() {
			var iWidth = $(document).height() - 210;
			iWidth = Math.round(iWidth / 32);				// was: 28 - needed to be adjusted for SAPUI5 V1.46.0
			sap.ui.getCore().byId("_slui_table_logs").setVisibleRowCount(iWidth);
		});
	},
	
	getLogContent: function(sLog) {
		this.sLogId = sLog;
		oStub.oFather.oProcExe.getSLPLogContent(sLog, this._getLogContentSuccess);
	},
	
	_getLogContentSuccess: function(dta) {
		var oLytV = new sap.ui.layout.VerticalLayout();
		var oLbl = new sap.ui.commons.TextArea({	width: 		"870px",
													height: 	"600px",
												// 	wrapping: 	true,
													editable: 	false,
													textAlign: 	sap.ui.core.TextAlign.Left	});
        if (dta && dta.length === 0) {
        	oLbl.setTextAlign(sap.ui.core.TextAlign.Center);
            oLbl.setValue(oBundle.getText("LOG_MSG_EMPTY_TXT"));
        } 
        else oLbl.setValue(dta);
		oLytV.addContent(oLbl);
		new SLUIDialogProvider().getLogDialog("Log: " + decodeURIComponent(oStub.oFather.getView().vLogs.sLogId.replace("/logs/", "/log/")), this, oLytV).open();
	}
});

var oLogViewHelper = {
	generateFormatTooltip: function(oValue) {
		var imgSrc = oBundle.getText("LOG_TYP_GEN_TXT");
		switch (oValue) {
			case suiCnst.SLP_LOG_FORMAT_GLF:
				imgSrc = oBundle.getText("LOG_TYP_GEN_TXT");
				break;
			case suiCnst.SLP_LOG_FORMAT_HTML:
				imgSrc = oBundle.getText("LOG_TYP_HTM_TXT");
				break;
			case suiCnst.SLP_LOG_FORMAT_TXT:
				imgSrc = oBundle.getText("LOG_TYP_TEXT_TXT");
				break;
			default:
				imgSrc = oBundle.getText("LOG_TYP_GEN_TXT");
				break;
		}
		return imgSrc;
	},

	generateFormatIcon: function(oValue) {
		var iconSrc = "sap-icon://";
		switch (oValue) {
			case suiCnst.SLP_LOG_FORMAT_GLF:
				iconSrc = iconSrc + "document-text";
				break;
			case suiCnst.SLP_LOG_FORMAT_HTML:
				iconSrc = iconSrc + "attachment-html";
				break;
			case suiCnst.SLP_LOG_FORMAT_TXT:
				iconSrc = iconSrc + "attachment-text-file";
				break;
			default:
				iconSrc = iconSrc + "document-text";
				break;
		}
		return iconSrc;
	}
};
